/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.tilt;

import java.util.Scanner;
import tech.octopusdragon.proj.tilt.Direction;
import tech.octopusdragon.proj.tilt.Game;
import tech.octopusdragon.proj.tilt.GameState;
import tech.octopusdragon.proj.tilt.PieceLocation;
import tech.octopusdragon.proj.tilt.Space;

public class TiltDemo {
    public static void main(String[] args) {
        PieceLocation[] gridPieces = new PieceLocation[]{new PieceLocation(Space.BLUE_SLIDER, 0, 0), new PieceLocation(Space.GREEN_SLIDER, 2, 0), new PieceLocation(Space.BLUE_SLIDER, 2, 1), new PieceLocation(Space.BLOCKER, 1, 4)};
        Game game = new Game(gridPieces);
        Scanner keyboard = new Scanner(System.in);
        boolean keepGoing = true;
        do {
            TiltDemo.printGrid(game);
            System.out.println("\n-----\n");
            if (game.gameState() == GameState.WIN) {
                System.out.println("You win!");
                keepGoing = false;
                break;
            }
            if (game.gameState() == GameState.LOSE) {
                System.out.println("You lose...");
                keepGoing = false;
                break;
            }
            boolean validInput = true;
            do {
                System.out.print("Enter your move: ");
                String userInput = keyboard.nextLine();
                System.out.println();
                switch (userInput.toLowerCase().charAt(0)) {
                    case 'u': {
                        game.tilt(Direction.UP);
                        break;
                    }
                    case 'd': {
                        game.tilt(Direction.DOWN);
                        break;
                    }
                    case 'l': {
                        game.tilt(Direction.LEFT);
                        break;
                    }
                    case 'r': {
                        game.tilt(Direction.RIGHT);
                        break;
                    }
                    case 'q': {
                        keepGoing = false;
                        break;
                    }
                    default: {
                        validInput = false;
                    }
                }
            } while (!validInput);
        } while (keepGoing);
        keyboard.close();
        System.out.println("Goodbye");
    }

    public static void printGrid(Game grid) {
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 5) {
                TiltDemo.printSpace(grid.getSpace(i, j));
                if (j < 4) {
                    System.out.print(" - ");
                }
                ++j;
            }
            System.out.println();
            if (i < 4) {
                j = 0;
                while (j < 4) {
                    System.out.print("|   ");
                    ++j;
                }
                System.out.print(" | ");
                System.out.println();
            }
            ++i;
        }
    }

    public static void printSpace(Space space) {
        char spaceChar;
        switch (space) {
            case GREEN_SLIDER: {
                spaceChar = 'g';
                break;
            }
            case BLUE_SLIDER: {
                spaceChar = 'b';
                break;
            }
            case BLOCKER: {
                spaceChar = '\u25a1';
                break;
            }
            case HOLE: {
                spaceChar = '\u25cf';
                break;
            }
            default: {
                spaceChar = ' ';
            }
        }
        System.out.print(spaceChar);
    }
}

