/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.tilt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javafx.animation.Animation;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.util.Duration;
import tech.octopusdragon.proj.tilt.Direction;
import tech.octopusdragon.proj.tilt.FromTo;
import tech.octopusdragon.proj.tilt.Game;
import tech.octopusdragon.proj.tilt.GameState;
import tech.octopusdragon.proj.tilt.PieceLocation;
import tech.octopusdragon.proj.tilt.Space;

public class TiltApplication
extends Application {
    private static final Image SPACE_IMAGE = new Image(TiltApplication.class.getClassLoader().getResourceAsStream("space.png"));
    private static final Image HOLE_IMAGE = new Image(TiltApplication.class.getClassLoader().getResourceAsStream("hole.png"));
    private static final Image GREEN_SLIDER_IMAGE = new Image(TiltApplication.class.getClassLoader().getResourceAsStream("green_slider.png"));
    private static final Image BLUE_SLIDER_IMAGE = new Image(TiltApplication.class.getClassLoader().getResourceAsStream("blue_slider.png"));
    private static final Image BLOCKER_IMAGE = new Image(TiltApplication.class.getClassLoader().getResourceAsStream("blocker.png"));
    private static final Image UP_ARROW_IMAGE = new Image(TiltApplication.class.getClassLoader().getResourceAsStream("up_arrow.png"));
    private static final Image DOWN_ARROW_IMAGE = new Image(TiltApplication.class.getClassLoader().getResourceAsStream("down_arrow.png"));
    private static final Image LEFT_ARROW_IMAGE = new Image(TiltApplication.class.getClassLoader().getResourceAsStream("left_arrow.png"));
    private static final Image RIGHT_ARROW_IMAGE = new Image(TiltApplication.class.getClassLoader().getResourceAsStream("right_arrow.png"));
    private static final double ANIMATION_DURATION = 220.0;
    private static final double SPACING = 2.0;
    private StackPane root;
    private BorderPane borderPane;
    private MenuBar menuBar;
    private Menu gameMenu;
    private MenuItem newGameItem;
    private MenuItem restartItem;
    private MenuItem undoItem;
    private MenuItem howToPlayItem;
    private GridPane board;
    private Label numMovesLabel;
    private StackPane upArrow;
    private ImageView upArrowIV;
    private StackPane downArrow;
    private ImageView downArrowIV;
    private StackPane leftArrow;
    private ImageView leftArrowIV;
    private StackPane rightArrow;
    private ImageView rightArrowIV;
    private GridPane gridPane;
    private StackPane[][] grid;
    private ImageView[][] spaces;
    private ImageView[][] pieces;
    private Game game;
    private int lastLevel;
    private boolean arrowsDisabled;
    private boolean animationPlaying;

    public void init() {
        this.animationPlaying = false;
    }

    public void start(Stage primaryStage) {
        this.buildGui();
        Scene scene = new Scene((Parent)this.root);
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getClassLoader().getResource("styles.css").toExternalForm());
        this.createKeyBindings(scene);
        primaryStage.setScene(scene);
        primaryStage.setTitle("Tilt");
        primaryStage.setResizable(false);
        this.newGameDialog();
        primaryStage.show();
    }

    public void buildGui() {
        this.gridPane = new GridPane();
        this.grid = new StackPane[5][5];
        this.spaces = new ImageView[5][5];
        this.pieces = new ImageView[5][5];
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 5) {
                this.grid[i][j] = new StackPane();
                this.spaces[i][j] = new ImageView(SPACE_IMAGE);
                this.grid[i][j].getChildren().add((Object)this.spaces[i][j]);
                this.pieces[i][j] = new ImageView();
                this.grid[i][j].getChildren().add((Object)this.pieces[i][j]);
                this.gridPane.add((Node)this.grid[i][j], j, i);
                ++j;
            }
            ++i;
        }
        this.upArrowIV = new ImageView(UP_ARROW_IMAGE);
        this.upArrow = new StackPane(new Node[]{this.upArrowIV});
        this.upArrow.getStyleClass().add((Object)"arrow");
        this.upArrow.setOnMouseClicked(e -> this.tilt(Direction.UP));
        this.downArrowIV = new ImageView(DOWN_ARROW_IMAGE);
        this.downArrow = new StackPane(new Node[]{this.downArrowIV});
        this.downArrow.getStyleClass().add((Object)"arrow");
        this.downArrow.setOnMouseClicked(e -> this.tilt(Direction.DOWN));
        this.leftArrowIV = new ImageView(LEFT_ARROW_IMAGE);
        this.leftArrow = new StackPane(new Node[]{this.leftArrowIV});
        this.leftArrow.getStyleClass().add((Object)"arrow");
        this.leftArrow.setOnMouseClicked(e -> this.tilt(Direction.LEFT));
        this.rightArrowIV = new ImageView(RIGHT_ARROW_IMAGE);
        this.rightArrow = new StackPane(new Node[]{this.rightArrowIV});
        this.rightArrow.getStyleClass().add((Object)"arrow");
        this.rightArrow.setOnMouseClicked(e -> this.tilt(Direction.RIGHT));
        this.numMovesLabel = new Label();
        this.board = new GridPane();
        this.board.setHgap(2.0);
        this.board.setVgap(2.0);
        this.board.add((Node)this.gridPane, 1, 1);
        this.board.add((Node)this.upArrow, 1, 0);
        this.board.add((Node)this.rightArrow, 2, 1);
        this.board.add((Node)this.downArrow, 1, 2);
        this.board.add((Node)this.leftArrow, 0, 1);
        this.board.add((Node)this.numMovesLabel, 0, 3);
        GridPane.setColumnSpan((Node)this.numMovesLabel, (Integer)3);
        GridPane.setHalignment((Node)this.numMovesLabel, (HPos)HPos.RIGHT);
        this.menuBar = new MenuBar();
        this.gameMenu = new Menu("Game");
        this.newGameItem = new MenuItem("New Game");
        this.newGameItem.setAccelerator(KeyCombination.keyCombination((String)"n"));
        this.newGameItem.setOnAction(e -> this.newGameDialog());
        this.gameMenu.getItems().add((Object)this.newGameItem);
        this.restartItem = new MenuItem("Restart");
        this.restartItem.setAccelerator(KeyCombination.keyCombination((String)"r"));
        this.restartItem.setOnAction(e -> this.newGame(this.lastLevel));
        this.gameMenu.getItems().add((Object)this.restartItem);
        this.undoItem = new MenuItem("Undo");
        this.undoItem.setAccelerator(KeyCombination.keyCombination((String)"u"));
        this.undoItem.setOnAction(e -> this.undo());
        this.gameMenu.getItems().add((Object)this.undoItem);
        this.howToPlayItem = new MenuItem("How to Play");
        this.howToPlayItem.setOnAction(e -> this.howToPlayDialog());
        this.gameMenu.getItems().add((Object)this.howToPlayItem);
        this.menuBar.getMenus().add((Object)this.gameMenu);
        this.borderPane = new BorderPane();
        this.borderPane.setCenter((Node)this.board);
        this.borderPane.setTop((Node)this.menuBar);
        this.root = new StackPane(new Node[]{this.borderPane});
    }

    public void updateGrid() {
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 5) {
                Image newImage;
                switch (this.game.getSpace(i, j)) {
                    case HOLE: {
                        newImage = HOLE_IMAGE;
                        break;
                    }
                    case GREEN_SLIDER: {
                        newImage = GREEN_SLIDER_IMAGE;
                        break;
                    }
                    case BLUE_SLIDER: {
                        newImage = BLUE_SLIDER_IMAGE;
                        break;
                    }
                    case BLOCKER: {
                        newImage = BLOCKER_IMAGE;
                        break;
                    }
                    default: {
                        newImage = null;
                    }
                }
                if (newImage != this.pieces[i][j].getImage()) {
                    this.pieces[i][j].setImage(newImage);
                }
                ++j;
            }
            ++i;
        }
        this.numMovesLabel.setText("Moves made: " + this.game.getNumMoves());
    }

    public void createKeyBindings(Scene scene) {
        scene.setOnKeyPressed(e -> {
            switch (e.getCode()) {
                case UP: 
                case W: {
                    this.tilt(Direction.UP);
                    break;
                }
                case DOWN: 
                case S: {
                    this.tilt(Direction.DOWN);
                    break;
                }
                case LEFT: 
                case A: {
                    this.tilt(Direction.LEFT);
                    break;
                }
                case RIGHT: 
                case D: {
                    this.tilt(Direction.RIGHT);
                    break;
                }
            }
        });
    }

    public void tilt(Direction direction) {
        if (this.arrowsDisabled) {
            return;
        }
        FromTo[] movements = this.game.tilt(direction);
        Animation tiltAnimation = this.tiltAnimation(movements);
        tiltAnimation.play();
    }

    public Animation tiltAnimation(FromTo[] movements) {
        ParallelTransition allMovements = new ParallelTransition();
        FromTo[] fromToArray = movements;
        int n = movements.length;
        int n2 = 0;
        while (n2 < n) {
            FromTo movement = fromToArray[n2];
            StackPane fromGridSquare = this.grid[movement.getFromRow()][movement.getFromColumn()];
            Bounds fromBounds = fromGridSquare.localToScene(fromGridSquare.getBoundsInLocal());
            StackPane toGridSquare = this.grid[movement.getToRow()][movement.getToColumn()];
            Bounds toBounds = toGridSquare.localToScene(toGridSquare.getBoundsInLocal());
            ImageView fromPiece = this.pieces[movement.getFromRow()][movement.getFromColumn()];
            ImageView piece = new ImageView(fromPiece.getImage());
            StackPane.setAlignment((Node)piece, (Pos)Pos.TOP_LEFT);
            this.root.getChildren().add((Object)piece);
            fromPiece.setImage(null);
            int spacesMoved = 0;
            spacesMoved += Math.abs(movement.getToRow() - movement.getFromRow());
            TranslateTransition moveAnimation = new TranslateTransition(Duration.millis((double)(220.0 * (double)(spacesMoved += Math.abs(movement.getToColumn() - movement.getFromColumn())))), (Node)piece);
            moveAnimation.setFromX(fromBounds.getMinX());
            moveAnimation.setFromY(fromBounds.getMinY());
            moveAnimation.setToX(toBounds.getMinX());
            moveAnimation.setToY(toBounds.getMinY());
            allMovements.getChildren().add((Object)moveAnimation);
            if (this.game.getSpace(movement.getToRow(), movement.getToColumn()) == Space.HOLE) {
                moveAnimation.setOnFinished(e -> this.root.getChildren().remove((Object)piece));
            }
            ++n2;
        }
        allMovements.setOnFinished(e -> {
            this.updateGrid();
            this.animationPlaying = false;
            ArrayList<Node> nodesToRemove = new ArrayList<Node>();
            for (Node node : this.root.getChildren()) {
                if (node == this.borderPane) continue;
                nodesToRemove.add(node);
            }
            for (Node node : nodesToRemove) {
                this.root.getChildren().remove((Object)node);
            }
            if (this.game.isOver()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TiltApplication.this.endGame();
                    }
                });
            } else {
                this.enableArrows();
            }
        });
        this.disableArrows();
        this.animationPlaying = true;
        return allMovements;
    }

    public void undo() {
        if (this.animationPlaying || this.game.gameState() == GameState.WIN) {
            return;
        }
        this.game.undo();
        this.updateGrid();
        if (this.arrowsDisabled) {
            this.enableArrows();
        }
    }

    public void disableArrows() {
        this.arrowsDisabled = true;
        this.upArrow.getStyleClass().remove((Object)"active");
        this.downArrow.getStyleClass().remove((Object)"active");
        this.leftArrow.getStyleClass().remove((Object)"active");
        this.rightArrow.getStyleClass().remove((Object)"active");
    }

    public void enableArrows() {
        this.arrowsDisabled = false;
        this.upArrow.getStyleClass().add((Object)"active");
        this.downArrow.getStyleClass().add((Object)"active");
        this.leftArrow.getStyleClass().add((Object)"active");
        this.rightArrow.getStyleClass().add((Object)"active");
    }

    public void newGame(int level) {
        PieceLocation[] gridPieces = this.readLevel(String.format("level%02d.txt", level));
        this.game = new Game(gridPieces);
        this.enableArrows();
        this.updateGrid();
    }

    public void newGameDialog() {
        ButtonType startButtonType = new ButtonType("Start", ButtonBar.ButtonData.OK_DONE);
        ButtonType exitButtonType = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        Spinner levelSpinner = new Spinner(1, 40, this.lastLevel);
        levelSpinner.setEditable(true);
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{startButtonType, exitButtonType});
        dialog.setTitle("Tilt - New Game");
        dialog.setHeaderText("What level do you want to play?");
        dialog.getDialogPane().setContent((Node)levelSpinner);
        dialog.showAndWait().ifPresent(response -> {
            if (response == startButtonType) {
                this.lastLevel = (Integer)levelSpinner.getValue();
                this.newGame((Integer)levelSpinner.getValue());
            }
        });
    }

    public void howToPlayDialog() {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("how_to_play.txt");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader in = new BufferedReader(inputStreamReader);
        String howToPlayStr = "";
        try {
            String line;
            while ((line = in.readLine()) != null) {
                howToPlayStr = String.valueOf(howToPlayStr) + line;
            }
        }
        catch (IOException e) {
            System.out.println("Error trying to read how to play text file...");
            e.printStackTrace();
        }
        TextArea instructions = new TextArea(howToPlayStr);
        instructions.setPrefColumnCount(40);
        instructions.setPrefRowCount(6);
        instructions.setEditable(false);
        instructions.setWrapText(true);
        Alert dialog = new Alert(Alert.AlertType.INFORMATION);
        dialog.setTitle("Tilt - How to Play");
        dialog.setHeaderText("Instructions");
        dialog.getDialogPane().setContent((Node)instructions);
        dialog.showAndWait();
    }

    public void endGame() {
        String header = "unspecified game end header";
        String message = "unspecified game end message";
        if (this.game.gameState() == GameState.WIN) {
            header = "You win!";
            message = "You solved the level in " + this.game.getNumMoves() + " moves.";
        } else if (this.game.gameState() == GameState.LOSE) {
            header = "You lose...";
            message = "You lost in " + this.game.getNumMoves() + " moves.";
        }
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Game Over");
        alert.setHeaderText(header);
        alert.setContentText(message);
        alert.showAndWait();
        this.disableArrows();
    }

    public PieceLocation[] readLevel(String filename) {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filename);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader in = new BufferedReader(inputStreamReader);
        ArrayList<PieceLocation> pieceLocations = new ArrayList<PieceLocation>();
        try {
            String line;
            int row = 0;
            while ((line = in.readLine()) != null) {
                int column = 0;
                while (column < 5) {
                    block9: {
                        Space spaceType;
                        switch (line.charAt(column)) {
                            case 'g': {
                                spaceType = Space.GREEN_SLIDER;
                                break;
                            }
                            case 'b': {
                                spaceType = Space.BLUE_SLIDER;
                                break;
                            }
                            case '#': {
                                spaceType = Space.BLOCKER;
                                break;
                            }
                            default: {
                                break block9;
                            }
                        }
                        pieceLocations.add(new PieceLocation(spaceType, row, column));
                    }
                    ++column;
                }
                ++row;
            }
        }
        catch (IOException e) {
            System.out.println("Error trying to read level text file...");
            e.printStackTrace();
        }
        return pieceLocations.toArray(new PieceLocation[0]);
    }

    public static void main(String[] args) {
        TiltApplication.launch((String[])args);
    }
}

