/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.tilt;

import java.util.ArrayList;
import tech.octopusdragon.proj.tilt.FromTo;
import tech.octopusdragon.proj.tilt.PieceLocation;
import tech.octopusdragon.proj.tilt.Space;

public class Grid {
    public static final int ROWS = 5;
    public static final int COLUMNS = 5;
    private Space[][] grid = new Space[5][5];
    private int numBlueSliders;

    public Grid() {
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 5) {
                this.grid[i][j] = i == 2 && j == 2 ? Space.HOLE : Space.EMPTY;
                ++j;
            }
            ++i;
        }
        this.numBlueSliders = 0;
    }

    public Grid(PieceLocation ... pieces) {
        this();
        PieceLocation[] pieceLocationArray = pieces;
        int n = pieces.length;
        int n2 = 0;
        while (n2 < n) {
            PieceLocation piece = pieceLocationArray[n2];
            this.grid[piece.getRow()][piece.getColumn()] = piece.getType();
            if (piece.getType() == Space.BLUE_SLIDER) {
                ++this.numBlueSliders;
            }
            ++n2;
        }
    }

    public FromTo[] tiltUp() {
        ArrayList<FromTo> moves = new ArrayList<FromTo>();
        int j = 0;
        while (j < 5) {
            int i = 1;
            while (i < 5) {
                if (this.grid[i][j] == Space.BLUE_SLIDER || this.grid[i][j] == Space.GREEN_SLIDER) {
                    FromTo movement = new FromTo();
                    moves.add(movement);
                    movement.setFromRow(i);
                    movement.setFromColumn(j);
                    int k = i;
                    while (k >= 1) {
                        if (this.grid[k - 1][j] == Space.HOLE) {
                            this.grid[k][j] = Space.EMPTY;
                            movement.setToRow(k - 1);
                            movement.setToColumn(j);
                            break;
                        }
                        if (this.grid[k - 1][j] != Space.EMPTY) {
                            movement.setToRow(k);
                            movement.setToColumn(j);
                            break;
                        }
                        this.grid[k - 1][j] = this.grid[k][j];
                        this.grid[k][j] = Space.EMPTY;
                        movement.setToRow(k - 1);
                        movement.setToColumn(j);
                        --k;
                    }
                }
                ++i;
            }
            ++j;
        }
        return moves.toArray(new FromTo[0]);
    }

    public FromTo[] tiltDown() {
        ArrayList<FromTo> moves = new ArrayList<FromTo>();
        int j = 0;
        while (j < 5) {
            int i = 3;
            while (i >= 0) {
                if (this.grid[i][j] == Space.BLUE_SLIDER || this.grid[i][j] == Space.GREEN_SLIDER) {
                    FromTo movement = new FromTo();
                    moves.add(movement);
                    movement.setFromRow(i);
                    movement.setFromColumn(j);
                    int k = i;
                    while (k < 4) {
                        if (this.grid[k + 1][j] == Space.HOLE) {
                            this.grid[k][j] = Space.EMPTY;
                            movement.setToRow(k + 1);
                            movement.setToColumn(j);
                            break;
                        }
                        if (this.grid[k + 1][j] != Space.EMPTY) {
                            movement.setToRow(k);
                            movement.setToColumn(j);
                            break;
                        }
                        this.grid[k + 1][j] = this.grid[k][j];
                        this.grid[k][j] = Space.EMPTY;
                        movement.setToRow(k + 1);
                        movement.setToColumn(j);
                        ++k;
                    }
                }
                --i;
            }
            ++j;
        }
        return moves.toArray(new FromTo[0]);
    }

    public FromTo[] tiltLeft() {
        ArrayList<FromTo> moves = new ArrayList<FromTo>();
        int i = 0;
        while (i < 5) {
            int j = 1;
            while (j < 5) {
                if (this.grid[i][j] == Space.BLUE_SLIDER || this.grid[i][j] == Space.GREEN_SLIDER) {
                    FromTo movement = new FromTo();
                    moves.add(movement);
                    movement.setFromRow(i);
                    movement.setFromColumn(j);
                    int k = j;
                    while (k >= 1) {
                        if (this.grid[i][k - 1] == Space.HOLE) {
                            this.grid[i][k] = Space.EMPTY;
                            movement.setToRow(i);
                            movement.setToColumn(k - 1);
                            break;
                        }
                        if (this.grid[i][k - 1] != Space.EMPTY) {
                            movement.setToRow(i);
                            movement.setToColumn(k);
                            break;
                        }
                        this.grid[i][k - 1] = this.grid[i][k];
                        this.grid[i][k] = Space.EMPTY;
                        movement.setToRow(i);
                        movement.setToColumn(k - 1);
                        --k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return moves.toArray(new FromTo[0]);
    }

    public FromTo[] tiltRight() {
        ArrayList<FromTo> moves = new ArrayList<FromTo>();
        int i = 0;
        while (i < 5) {
            int j = 3;
            while (j >= 0) {
                if (this.grid[i][j] == Space.BLUE_SLIDER || this.grid[i][j] == Space.GREEN_SLIDER) {
                    FromTo movement = new FromTo();
                    moves.add(movement);
                    movement.setFromRow(i);
                    movement.setFromColumn(j);
                    int k = j;
                    while (k < 4) {
                        if (this.grid[i][k + 1] == Space.HOLE) {
                            this.grid[i][k] = Space.EMPTY;
                            movement.setToRow(i);
                            movement.setToColumn(k + 1);
                            break;
                        }
                        if (this.grid[i][k + 1] != Space.EMPTY) {
                            movement.setToRow(i);
                            movement.setToColumn(k);
                            break;
                        }
                        this.grid[i][k + 1] = this.grid[i][k];
                        this.grid[i][k] = Space.EMPTY;
                        movement.setToRow(i);
                        movement.setToColumn(k + 1);
                        ++k;
                    }
                }
                --j;
            }
            ++i;
        }
        return moves.toArray(new FromTo[0]);
    }

    public Space getSpace(int row, int column) {
        return this.grid[row][column];
    }

    public boolean hasGreenSlider() {
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 5) {
                if (this.grid[i][j] == Space.GREEN_SLIDER) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean sunkBlueSlider() {
        int numBlueSlidersLeft = 0;
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 5) {
                if (this.grid[i][j] == Space.BLUE_SLIDER) {
                    ++numBlueSlidersLeft;
                }
                ++j;
            }
            ++i;
        }
        return numBlueSlidersLeft < this.numBlueSliders;
    }

    public Grid copy() {
        Grid copy = new Grid();
        copy.grid = new Space[5][5];
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 5) {
                copy.grid[i][j] = this.grid[i][j];
                ++j;
            }
            ++i;
        }
        copy.numBlueSliders = this.numBlueSliders;
        return copy;
    }

    public boolean equals(Object otherObject) {
        if (otherObject.getClass() != Grid.class) {
            return false;
        }
        Grid other = (Grid)otherObject;
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 5) {
                if (other.grid[i][j] != this.grid[i][j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

