/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.tilt;

import java.util.Stack;
import tech.octopusdragon.proj.tilt.Direction;
import tech.octopusdragon.proj.tilt.FromTo;
import tech.octopusdragon.proj.tilt.GameState;
import tech.octopusdragon.proj.tilt.Grid;
import tech.octopusdragon.proj.tilt.PieceLocation;
import tech.octopusdragon.proj.tilt.Space;

public class Game {
    private Grid grid;
    private Stack<Grid> gameStates;
    private int numMoves;

    public Game() {
        this.grid = new Grid();
        this.gameStates = new Stack();
        this.numMoves = 0;
    }

    public Game(PieceLocation ... pieces) {
        this.grid = new Grid(pieces);
        this.gameStates = new Stack();
        this.numMoves = 0;
    }

    public FromTo[] tilt(Direction direction) {
        this.gameStates.push(this.grid.copy());
        FromTo[] fromTo = null;
        switch (direction) {
            case UP: {
                fromTo = this.grid.tiltUp();
                break;
            }
            case RIGHT: {
                fromTo = this.grid.tiltRight();
                break;
            }
            case DOWN: {
                fromTo = this.grid.tiltDown();
                break;
            }
            case LEFT: {
                fromTo = this.grid.tiltLeft();
            }
        }
        if (this.grid.equals(this.gameStates.peek())) {
            this.gameStates.pop();
        } else {
            ++this.numMoves;
        }
        return fromTo;
    }

    public void undo() {
        if (this.gameStates.isEmpty()) {
            return;
        }
        this.grid = this.gameStates.pop();
        ++this.numMoves;
    }

    public Space getSpace(int row, int column) {
        return this.grid.getSpace(row, column);
    }

    public int getNumMoves() {
        return this.numMoves;
    }

    public GameState gameState() {
        if (this.grid.sunkBlueSlider()) {
            return GameState.LOSE;
        }
        if (!this.grid.hasGreenSlider()) {
            return GameState.WIN;
        }
        return GameState.PLAYING;
    }

    public boolean isOver() {
        return this.gameState() != GameState.PLAYING;
    }
}

