/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.randomsentencegenerator.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Scanner;
import tech.octopusdragon.randomsentencegenerator.enums.AdverbType;
import tech.octopusdragon.randomsentencegenerator.enums.ConjunctionType;
import tech.octopusdragon.randomsentencegenerator.enums.VerbType;
import tech.octopusdragon.randomsentencegenerator.util.OrderedProperties;

public class Util {
    public static final String WORD_DIR = "resources/words";
    public static final String PROPERTIES_PATH = "resources/defaultProperties.properties";
    private static Properties defaultProperties;
    private static Properties properties;
    private static Random rand;
    private static double randNum;
    public static String[][] nouns;
    public static String[][] pronouns;
    public static Map<VerbType, String[][]> verbs;
    public static String[] adjectives;
    public static Map<AdverbType, String[]> adverbs;
    public static String[] prepositions;
    public static Map<ConjunctionType, String[]> conjunctions;
    public static String[] interjections;

    static {
        rand = new Random();
        defaultProperties = new OrderedProperties();
        Util.loadDefaultProperties();
        properties = new OrderedProperties(defaultProperties);
        Util.readWords();
    }

    private static void readWords() {
        nouns = Util.readCSV("resources/words/nouns.txt");
        pronouns = new String[][]{{"I", "we", "he", "she", "it", "they", "you"}, {"me", "us", "him", "her", "it", "them", "you"}, {"my", "our", "his", "her", "its", "their", "your"}};
        verbs = new HashMap<VerbType, String[][]>();
        verbs.put(VerbType.INTRANSITIVE, Util.readCSV("resources/words/verbs-intransitive.txt"));
        verbs.put(VerbType.TRANSITIVE, Util.readCSV("resources/words/verbs-transitive.txt"));
        verbs.put(VerbType.DITRANSITIVE, Util.readCSV("resources/words/verbs-ditransitive.txt"));
        verbs.put(VerbType.NOUN_LINKING, Util.readCSV("resources/words/verbs-pnLinking.txt"));
        verbs.put(VerbType.ADJECTIVE_LINKING, Util.readCSV("resources/words/verbs-paLinking.txt"));
        verbs.put(VerbType.BE, new String[][]{{"am", "is", "are", "was", "were", "be", "being", "been"}});
        adjectives = Util.readFile("resources/words/adjectives.txt");
        adverbs = new HashMap<AdverbType, String[]>();
        adverbs.put(AdverbType.MANNER, Util.readFile("resources/words/adverbs-manner.txt"));
        adverbs.put(AdverbType.TIME, Util.readFile("resources/words/adverbs-time.txt"));
        adverbs.put(AdverbType.PLACE, Util.readFile("resources/words/adverbs-place.txt"));
        adverbs.put(AdverbType.FREQUENCY, Util.readFile("resources/words/adverbs-frequency.txt"));
        adverbs.put(AdverbType.DEGREE, Util.readFile("resources/words/adverbs-degree.txt"));
        prepositions = new String[]{"aboard", "about", "above", "across", "after", "against", "along", "among", "around", "as", "at", "before", "behind", "below", "beneath", "beside", "between", "beyond", "but", "by", "despite", "down", "during", "except", "for", "from", "in", "inside", "into", "like", "near", "of", "off", "on", "out", "outside", "over", "past", "since", "through", "throughout", "to", "toward", "under", "underneath", "until", "up", "upon", "with", "within", "without"};
        conjunctions = new HashMap<ConjunctionType, String[]>();
        conjunctions.put(ConjunctionType.COORDINATING, new String[]{"and", "or", "but"});
        conjunctions.put(ConjunctionType.SUBORDINATING, Util.readFile("resources/words/conjunctions-subordinating.txt"));
        interjections = Util.readFile("resources/words/interjections.txt");
    }

    private static String[] readFile(String filename) {
        ArrayList<String> items = new ArrayList<String>();
        InputStream inputStream = Util.class.getClassLoader().getResourceAsStream(filename);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader in = new BufferedReader(inputStreamReader);
        Scanner inputFile = new Scanner(in);
        while (inputFile.hasNext()) {
            String line = inputFile.nextLine().split(",")[0];
            if (line.isEmpty() || line.startsWith("//")) continue;
            items.add(line);
        }
        inputFile.close();
        return items.toArray(new String[items.size()]);
    }

    private static String[][] readCSV(String filename) {
        ArrayList<String[]> items;
        block6: {
            items = new ArrayList<String[]>();
            InputStream inputStream = Util.class.getClassLoader().getResourceAsStream(filename);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader in = new BufferedReader(inputStreamReader);
            Scanner inputFile = new Scanner(in);
            try {
                try {
                    while (inputFile.hasNext()) {
                        String line = inputFile.nextLine();
                        if (line.isEmpty() || line.startsWith("//")) continue;
                        String[] tokens = line.split(",");
                        items.add(tokens);
                        if (tokens.length == ((String[])items.get(0)).length) continue;
                        throw new IllegalArgumentException();
                    }
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Incorrect number of tokens on line " + (items.size() + 1) + " of " + filename);
                    e.printStackTrace();
                    System.exit(1);
                    inputFile.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                inputFile.close();
                throw throwable;
            }
            inputFile.close();
        }
        return (String[][])items.toArray((T[])new String[0][0]);
    }

    private static void loadDefaultProperties() {
        try {
            InputStream inputStream = Util.class.getClassLoader().getResourceAsStream(PROPERTIES_PATH);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader in = new BufferedReader(inputStreamReader);
            defaultProperties.load(in);
            in.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR: Default properties file not found: resources/defaultProperties.properties");
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("Error occured when reading default properties: resources/defaultProperties.properties");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static <T> T randElement(T[] arr) {
        return arr[rand.nextInt(arr.length)];
    }

    public static boolean randChance(String propertyName) {
        String value = properties.getProperty(propertyName);
        double probability = Double.parseDouble(value);
        randNum = rand.nextDouble();
        boolean shouldOccur = randNum < probability;
        randNum -= probability;
        return shouldOccur;
    }

    public static boolean randChanceContinued(String propertyName) {
        String value = properties.getProperty(propertyName);
        double probability = Double.parseDouble(value);
        boolean shouldOccur = randNum < probability;
        randNum -= probability;
        return shouldOccur;
    }
}

