/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.randomsentencegenerator.gui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javafx.application.Application;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import tech.octopusdragon.randomsentencegenerator.components.Sentence;
import tech.octopusdragon.randomsentencegenerator.gui.PreferencesWindow;

public class RandomSentenceGeneratorApplication
extends Application {
    private final double WIDTH = 720.0;
    private final double HEIGHT = 200.0;
    private final double PADDING = 20.0;
    private final double BUTTON_SIZE = 16.0;
    private static final String ICON_PATH = "resources/images/icon.png";
    private final String TITLE = "Random Sentence Generator";
    private final String PROMPT = "Click the button to generate a sentence.";
    private final String GENERATE_BUTTON_TEXT = "Generate";
    private final String FONT_TEXT = "Font";
    private final String RANDOM_FONT_TEXT = "Random";
    private final String SIZE_TEXT = "Size";
    private final String COLOR_TEXT = "Color";
    private final String RANDOM_COLOR_TEXT = "Random";
    private final String SETTINGS_TEXT = "Settings";
    private final String PREFERENCES_TEXT = "Preferences";
    protected LinkedHashMap<String, String> fonts;
    private final String DEFAULT_FONT = "Arial";
    private final String GUI_FONT = "Arial";
    private LinkedHashMap<String, Double> sizes;
    private double SMALL_SIZE = 16.0;
    private double MEDIUM_SIZE = 28.0;
    private double LARGE_SIZE = 54.0;
    private final double DEFAULT_SIZE = this.SMALL_SIZE;
    private LinkedHashMap<String, String> colors;
    private Label sentenceLabel;
    private Button generateButton;
    private MenuBar menuBar;
    private BooleanProperty randomFont;
    private BooleanProperty randomColor;
    private String curFont;
    private double curSize;

    public void init() {
        this.randomFont = new SimpleBooleanProperty();
        this.randomColor = new SimpleBooleanProperty();
        this.buildFonts();
        this.buildSizes();
        this.buildColors();
        this.curFont = "Arial";
        this.curSize = this.DEFAULT_SIZE;
    }

    public void start(Stage primaryStage) {
        BorderPane root = new BorderPane();
        this.menuBar = new MenuBar();
        Menu fontMenu = new Menu("Font");
        fontMenu.setStyle(String.format("-fx-font-family: \"%s\";", "Arial"));
        ToggleGroup fontToggleGroup = new ToggleGroup();
        for (Map.Entry<String, String> font : this.fonts.entrySet()) {
            RadioMenuItem item = new RadioMenuItem(font.getKey());
            item.setStyle(String.format("-fx-font-family: \"%s\";", font.getValue()));
            item.setOnAction((EventHandler)new ChangeFontHandler(font.getValue()));
            item.setToggleGroup(fontToggleGroup);
            fontMenu.getItems().add((Object)item);
        }
        RadioMenuItem randomFontMenuItem = new RadioMenuItem("Random");
        randomFontMenuItem.setStyle(String.format("-fx-font-family: \"%s\";", "Arial"));
        randomFontMenuItem.setOnAction((EventHandler)new ChangeFontHandler());
        randomFontMenuItem.setToggleGroup(fontToggleGroup);
        randomFontMenuItem.setSelected(true);
        this.randomFont.bind((ObservableValue)randomFontMenuItem.selectedProperty());
        fontMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), randomFontMenuItem});
        Menu sizeMenu = new Menu("Size");
        sizeMenu.setStyle(String.format("-fx-font-family: \"%s\";", "Arial"));
        ToggleGroup sizeToggleGroup = new ToggleGroup();
        for (Map.Entry<String, Double> size : this.sizes.entrySet()) {
            RadioMenuItem item = new RadioMenuItem(size.getKey());
            item.setStyle(String.format("-fx-font-family: \"%s\";", "Arial"));
            item.setOnAction((EventHandler)new ChangeSizeHandler(size.getValue()));
            item.setToggleGroup(sizeToggleGroup);
            if (size.getValue() == this.DEFAULT_SIZE) {
                item.setSelected(true);
            }
            sizeMenu.getItems().add((Object)item);
        }
        Menu colorMenu = new Menu("Color");
        colorMenu.setStyle(String.format("-fx-font-family: \"%s\";", "Arial"));
        ToggleGroup colorToggleGroup = new ToggleGroup();
        for (Map.Entry<String, String> color : this.colors.entrySet()) {
            RadioMenuItem item = new RadioMenuItem(color.getKey());
            item.setStyle(String.valueOf(String.format("-fx-font-family: \"%s\";", "Arial")) + String.format("-fx-text-fill: %s;", color.getValue()));
            item.setOnAction((EventHandler)new ChangeColorHandler(color.getValue()));
            item.setToggleGroup(colorToggleGroup);
            colorMenu.getItems().add((Object)item);
        }
        RadioMenuItem randomColorMenuItem = new RadioMenuItem("Random");
        randomColorMenuItem.setStyle(String.format("-fx-font-family: \"%s\";", "Arial"));
        randomColorMenuItem.setOnAction((EventHandler)new ChangeColorHandler());
        randomColorMenuItem.setToggleGroup(colorToggleGroup);
        randomColorMenuItem.setSelected(true);
        this.randomColor.bind((ObservableValue)randomColorMenuItem.selectedProperty());
        colorMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), randomColorMenuItem});
        Menu settingsMenu = new Menu("Settings");
        settingsMenu.setStyle(String.format("-fx-font-family: \"%s\";", "Arial"));
        MenuItem preferencesMenuItem = new MenuItem("Preferences");
        preferencesMenuItem.setStyle(String.format("-fx-font-family: \"%s\";", "Arial"));
        preferencesMenuItem.setOnAction((EventHandler)new PreferencesMenuHandler());
        settingsMenu.getItems().addAll((Object[])new MenuItem[]{preferencesMenuItem});
        this.menuBar.getMenus().addAll((Object[])new Menu[]{fontMenu, sizeMenu, colorMenu, settingsMenu});
        root.setTop((Node)this.menuBar);
        this.sentenceLabel = new Label("Click the button to generate a sentence.");
        this.sentenceLabel.setFont(new Font("Arial", this.DEFAULT_SIZE));
        this.sentenceLabel.setStyle(String.format("-fx-text-fill: #000000;", new Object[0]));
        this.sentenceLabel.setWrapText(true);
        this.sentenceLabel.setTextAlignment(TextAlignment.CENTER);
        root.setCenter((Node)this.sentenceLabel);
        this.generateButton = new Button("Generate");
        this.generateButton.setFont(new Font("Arial", 16.0));
        this.generateButton.setOnAction((EventHandler)new GenerateButtonHandler());
        BorderPane.setAlignment((Node)this.generateButton, (Pos)Pos.CENTER);
        BorderPane.setMargin((Node)this.generateButton, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
        root.setBottom((Node)this.generateButton);
        Scene scene = new Scene((Parent)root, 720.0, 200.0);
        primaryStage.setTitle("Random Sentence Generator");
        primaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(ICON_PATH)));
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    public void changeFont(String font) {
        this.sentenceLabel.setFont(new Font(font, this.curSize));
        this.curFont = font;
    }

    public void changeSize(double size) {
        this.sentenceLabel.setFont(new Font(this.curFont, size));
        this.curSize = size;
    }

    public void changeColor(String color) {
        this.sentenceLabel.setStyle(String.format("-fx-text-fill: %s;", color));
    }

    public void buildFonts() {
        this.fonts = new LinkedHashMap();
        this.fonts.put("Arial", "Arial");
        this.fonts.put("Calibri", "Calibri");
        this.fonts.put("Times New Roman", "Times New Roman");
        this.fonts.put("Helvetica", "Helvetica");
        this.fonts.put("Arial Rounded", "Arial Rounded MT Bold");
        this.fonts.put("Century Gothic", "Century Gothic");
        this.fonts.put("Gill Sans", "Gill Sans MT");
        this.fonts.put("Comic Sans", "Comic Sans MS");
        this.fonts.put("Lucida Sans", "Lucida Sans");
        this.fonts.put("Lucida Sans Typewriter", "Lucida Sans Typewriter");
        this.fonts.put("Lucida Handwriting", "Lucida Handwriting");
        this.fonts.put("Garamond", "Garamond");
        this.fonts.put("Tahoma", "Tahoma");
        this.fonts.put("Papyrus", "Papyrus");
    }

    public void buildColors() {
        this.colors = new LinkedHashMap();
        this.colors.put("Black", "#000000");
        this.colors.put("Red", "#990000");
        this.colors.put("Orange", "#996600");
        this.colors.put("Yellow", "#999900");
        this.colors.put("Green", "#009900");
        this.colors.put("Blue", "#000099");
        this.colors.put("Violet", "#990099");
    }

    public void buildSizes() {
        this.sizes = new LinkedHashMap();
        this.sizes.put("Small", this.SMALL_SIZE);
        this.sizes.put("Medium", this.MEDIUM_SIZE);
        this.sizes.put("Large", this.LARGE_SIZE);
    }

    public String generateSentence() {
        return new Sentence().toString();
    }

    public static void main(String[] args) {
        RandomSentenceGeneratorApplication.launch((String[])args);
    }

    public class ChangeColorHandler
    implements EventHandler<ActionEvent> {
        private String color;
        private boolean random;

        public ChangeColorHandler() {
            this.random = true;
        }

        public ChangeColorHandler(String color) {
            this.color = color;
        }

        public void handle(ActionEvent event) {
            Random rand = new Random();
            if (this.random) {
                ArrayList colorList = new ArrayList(RandomSentenceGeneratorApplication.this.colors.values());
                RandomSentenceGeneratorApplication.this.changeFont((String)colorList.get(rand.nextInt(colorList.size())));
            } else {
                RandomSentenceGeneratorApplication.this.changeColor(this.color);
            }
        }
    }

    public class ChangeFontHandler
    implements EventHandler<ActionEvent> {
        private String font;
        private boolean random;

        public ChangeFontHandler() {
            this.random = true;
        }

        public ChangeFontHandler(String font) {
            this.font = font;
        }

        public void handle(ActionEvent event) {
            Random rand = new Random();
            if (this.random) {
                ArrayList<String> fontList = new ArrayList<String>(RandomSentenceGeneratorApplication.this.fonts.values());
                RandomSentenceGeneratorApplication.this.changeFont((String)fontList.get(rand.nextInt(fontList.size())));
            } else {
                RandomSentenceGeneratorApplication.this.changeFont(this.font);
            }
        }
    }

    public class ChangeSizeHandler
    implements EventHandler<ActionEvent> {
        private double size;

        public ChangeSizeHandler(double size) {
            this.size = size;
        }

        public void handle(ActionEvent event) {
            RandomSentenceGeneratorApplication.this.changeSize(this.size);
        }
    }

    public class GenerateButtonHandler
    implements EventHandler<ActionEvent> {
        public void handle(ActionEvent event) {
            Random rand = new Random();
            if (RandomSentenceGeneratorApplication.this.randomFont.get()) {
                ArrayList<String> fontList = new ArrayList<String>(RandomSentenceGeneratorApplication.this.fonts.values());
                RandomSentenceGeneratorApplication.this.changeFont((String)fontList.get(rand.nextInt(fontList.size())));
            }
            if (RandomSentenceGeneratorApplication.this.randomColor.get()) {
                ArrayList colorList = new ArrayList(RandomSentenceGeneratorApplication.this.colors.values());
                RandomSentenceGeneratorApplication.this.changeColor((String)colorList.get(rand.nextInt(colorList.size())));
            }
            RandomSentenceGeneratorApplication.this.sentenceLabel.setText(RandomSentenceGeneratorApplication.this.generateSentence());
        }
    }

    public class PreferencesMenuHandler
    implements EventHandler<ActionEvent> {
        public void handle(ActionEvent event) {
            new PreferencesWindow().show();
        }
    }
}

