/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.randomsentencegenerator.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import tech.octopusdragon.randomsentencegenerator.util.Util;

public class PreferencesWindow
extends Stage {
    private static final double WIDTH = 500.0;
    private static final double HEIGHT = 500.0;
    private static final double PADDING = 10.0;
    private static final double SPACING = 10.0;
    GridPane entryBox;
    List<EntryGraphic> entries;
    HBox buttonBox;
    Button applyButton;
    Button applyCloseButton;
    Button defaultButton;
    Button closeButton;

    public PreferencesWindow() {
        BorderPane root = new BorderPane();
        this.entryBox = new GridPane();
        this.entryBox.setPadding(new Insets(10.0));
        this.entryBox.setHgap(10.0);
        this.entryBox.setVgap(10.0);
        this.entries = new ArrayList<EntryGraphic>();
        int entryIndex = 0;
        for (Object key : Util.getDefaultProperties().keySet()) {
            String skey = (String)key;
            EntryGraphic newEntryGraphic = new EntryGraphic(skey);
            this.entries.add(newEntryGraphic);
            this.entryBox.add((Node)newEntryGraphic.getKeyLabel(), 0, entryIndex);
            this.entryBox.add((Node)newEntryGraphic.getValueTextField(), 1, entryIndex);
            ++entryIndex;
        }
        ScrollPane entryPane = new ScrollPane((Node)this.entryBox);
        root.setCenter((Node)entryPane);
        this.applyButton = new Button("Apply");
        this.applyButton.setOnAction(event -> this.apply());
        this.applyCloseButton = new Button("Apply and Close");
        this.applyCloseButton.setOnAction(event -> {
            this.apply();
            this.close();
        });
        this.defaultButton = new Button("Restore Defaults");
        this.defaultButton.setOnAction(event -> this.defaults());
        this.closeButton = new Button("Close");
        this.closeButton.setOnAction(event -> this.close());
        HBox buttonBox = new HBox(new Node[]{this.applyButton, this.applyCloseButton, this.defaultButton, this.closeButton});
        buttonBox.setAlignment(Pos.CENTER_RIGHT);
        buttonBox.setPadding(new Insets(10.0));
        buttonBox.setSpacing(10.0);
        root.setBottom((Node)buttonBox);
        Scene scene = new Scene((Parent)root, 500.0, 500.0);
        this.setScene(scene);
        this.setTitle("Preferences");
        this.show();
    }

    protected void apply() {
        Properties properties = Util.getProperties();
        for (EntryGraphic entry : this.entries) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
    }

    protected void defaults() {
        Properties defaultProps = Util.getDefaultProperties();
        for (EntryGraphic entry : this.entries) {
            String defaultValue = defaultProps.getProperty(entry.getKey());
            entry.getValueTextField().setText(defaultValue);
        }
    }

    private class EntryGraphic {
        private String key;
        private Label keyLabel;
        private TextField valueTextField;

        public EntryGraphic(String key) {
            this.key = key;
            this.keyLabel = new Label(this.formattedKey());
            this.valueTextField = new TextField(Util.getProperties().getProperty(key));
        }

        public String formattedKey() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.key.substring(0, 1).toUpperCase());
            int i = 1;
            while (i < this.key.length()) {
                char ch = this.key.charAt(i);
                if (Character.isUpperCase(ch)) {
                    sb.append(" ");
                }
                sb.append(ch);
                ++i;
            }
            return sb.toString();
        }

        public String getKey() {
            return this.key.toString();
        }

        public String getValue() {
            return this.valueTextField.getText();
        }

        public Label getKeyLabel() {
            return this.keyLabel;
        }

        public TextField getValueTextField() {
            return this.valueTextField;
        }
    }
}

