/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.randomsentencegenerator.components.phrases;

import java.util.ArrayList;
import java.util.Random;
import tech.octopusdragon.randomsentencegenerator.components.partsofspeech.Adjective;
import tech.octopusdragon.randomsentencegenerator.components.partsofspeech.Adverb;
import tech.octopusdragon.randomsentencegenerator.components.partsofspeech.Verb;
import tech.octopusdragon.randomsentencegenerator.components.phrases.AdjectivePhrase;
import tech.octopusdragon.randomsentencegenerator.components.phrases.AdverbPhrase;
import tech.octopusdragon.randomsentencegenerator.components.phrases.NounPhrase;
import tech.octopusdragon.randomsentencegenerator.components.phrases.PrepositionalPhrase;
import tech.octopusdragon.randomsentencegenerator.enums.Aspect;
import tech.octopusdragon.randomsentencegenerator.enums.Case;
import tech.octopusdragon.randomsentencegenerator.enums.Number;
import tech.octopusdragon.randomsentencegenerator.enums.Person;
import tech.octopusdragon.randomsentencegenerator.enums.Tense;
import tech.octopusdragon.randomsentencegenerator.enums.VerbType;
import tech.octopusdragon.randomsentencegenerator.util.Util;

public class VerbPhrase {
    private ArrayList<Object> verbPhrase = new ArrayList();
    private int mainVerbIndex;
    private int finiteVerbIndex;
    private Tense tense;
    private Aspect aspect;
    private int pattern;
    private Number number;
    private Person person;

    public void constructVerbPhrase(int pattern, Number number, Person person, Tense tense, Aspect aspect) {
        this.tense = tense;
        this.aspect = aspect;
        this.pattern = pattern;
        this.number = number;
        this.person = person;
        this.mainVerbIndex = -1;
        this.finiteVerbIndex = -1;
        this.generateSentencePattern();
        this.mainVerbIndex = 0;
        this.conjugateVerb();
        this.addAdverbialPhrase();
    }

    public VerbPhrase(int pattern, Number number, Person person, Tense tense, Aspect aspect) {
        this.constructVerbPhrase(pattern, number, person, tense, aspect);
    }

    public VerbPhrase(int pattern, Number number, Person person) {
        Tense tense = Util.randChance("pastTense") ? Tense.PAST : (Util.randChanceContinued("futureTense") ? Tense.FUTURE : Tense.PRESENT);
        Aspect aspect = Util.randChance("perfectAspect") ? Aspect.PERFECT : (Util.randChanceContinued("continuousAspect") ? Aspect.CONTINUOUS : (Util.randChanceContinued("perfectContinuousAspect") ? Aspect.PERFECT_CONTINUOUS : Aspect.SIMPLE));
        this.constructVerbPhrase(pattern, number, person, tense, aspect);
    }

    public ArrayList<Object> getVerbPhrase() {
        return this.verbPhrase;
    }

    public Tense getTense() {
        return this.tense;
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public int getFiniteVerbIndex() {
        if (this.finiteVerbIndex == -1) {
            return this.mainVerbIndex;
        }
        return this.finiteVerbIndex;
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.verbPhrase.size() - 1) {
            str = String.valueOf(str) + this.verbPhrase.get(i) + " ";
            ++i;
        }
        str = String.valueOf(str) + this.verbPhrase.get(i);
        return str;
    }

    public void generateSentencePattern() {
        switch (this.pattern) {
            case 1: {
                this.verbPhrase.add(new Verb(VerbType.INTRANSITIVE, this.number, this.person, this.tense, this.aspect));
                break;
            }
            case 2: {
                this.verbPhrase.add(new Verb(VerbType.TRANSITIVE, this.number, this.person, this.tense, this.aspect));
                this.verbPhrase.add(new NounPhrase(Case.OBJECT));
                break;
            }
            case 3: {
                this.verbPhrase.add(new Verb(VerbType.DITRANSITIVE, this.number, this.person, this.tense, this.aspect));
                this.verbPhrase.add(new NounPhrase(Case.OBJECT));
                this.verbPhrase.add(new NounPhrase(Case.OBJECT));
                break;
            }
            case 4: {
                if (Util.randChance("pnBeVerb")) {
                    this.verbPhrase.add(new Verb(VerbType.BE, this.number, this.person, this.tense, this.aspect));
                } else {
                    this.verbPhrase.add(new Verb(VerbType.NOUN_LINKING, this.number, this.person, this.tense, this.aspect));
                }
                this.verbPhrase.add(new NounPhrase(Case.OBJECT));
                break;
            }
            default: {
                if (Util.randChance("paBeVerb")) {
                    this.verbPhrase.add(new Verb(VerbType.BE, this.number, this.person, this.tense, this.aspect));
                } else {
                    this.verbPhrase.add(new Verb(VerbType.ADJECTIVE_LINKING, this.number, this.person, this.tense, this.aspect));
                }
                if (Util.randChance("adjectivePhrase")) {
                    this.verbPhrase.add(new AdjectivePhrase());
                } else {
                    this.verbPhrase.add(new Adjective());
                }
                if (!Util.randChance("compoundAdjective")) break;
                this.verbPhrase.add("and");
                if (Util.randChance("adjectivePhrase")) {
                    this.verbPhrase.add(new AdjectivePhrase());
                    break;
                }
                this.verbPhrase.add(new Adjective());
            }
        }
    }

    public void conjugateVerb() {
        if (this.aspect.equals((Object)Aspect.SIMPLE) && this.tense.equals((Object)Tense.FUTURE)) {
            this.verbPhrase.add(0, "will");
            this.finiteVerbIndex = 0;
            ++this.mainVerbIndex;
        } else if (this.aspect.equals((Object)Aspect.PERFECT)) {
            if (this.tense.equals((Object)Tense.PRESENT)) {
                if (this.number.equals((Object)Number.SINGULAR) && !this.person.equals((Object)Person.FIRST)) {
                    this.verbPhrase.add(0, "has");
                    this.finiteVerbIndex = 0;
                    ++this.mainVerbIndex;
                } else {
                    this.verbPhrase.add(0, "have");
                    this.finiteVerbIndex = 0;
                    ++this.mainVerbIndex;
                }
            } else if (this.tense.equals((Object)Tense.PAST)) {
                this.verbPhrase.add(0, "had");
                this.finiteVerbIndex = 0;
                ++this.mainVerbIndex;
            } else {
                this.verbPhrase.add(0, "have");
                this.verbPhrase.add(0, "will");
                this.finiteVerbIndex = 0;
                this.mainVerbIndex += 2;
            }
        } else if (this.aspect.equals((Object)Aspect.CONTINUOUS)) {
            if (this.tense.equals((Object)Tense.PRESENT)) {
                if (this.number.equals((Object)Number.SINGULAR) && this.person.equals((Object)Person.FIRST)) {
                    this.verbPhrase.add(0, "am");
                    this.finiteVerbIndex = 0;
                    ++this.mainVerbIndex;
                } else if (this.number.equals((Object)Number.SINGULAR)) {
                    this.verbPhrase.add(0, "is");
                    this.finiteVerbIndex = 0;
                    ++this.mainVerbIndex;
                } else {
                    this.verbPhrase.add(0, "are");
                    this.finiteVerbIndex = 0;
                    ++this.mainVerbIndex;
                }
            } else if (this.tense.equals((Object)Tense.PAST)) {
                if (this.number.equals((Object)Number.SINGULAR)) {
                    this.verbPhrase.add(0, "was");
                    this.finiteVerbIndex = 0;
                    ++this.mainVerbIndex;
                } else {
                    this.verbPhrase.add(0, "were");
                    this.finiteVerbIndex = 0;
                    ++this.mainVerbIndex;
                }
            } else {
                this.verbPhrase.add(0, "be");
                this.verbPhrase.add(0, "will");
                this.finiteVerbIndex = 0;
                this.mainVerbIndex += 2;
            }
        } else if (this.aspect.equals((Object)Aspect.PERFECT_CONTINUOUS)) {
            if (this.tense.equals((Object)Tense.PRESENT)) {
                if (this.number.equals((Object)Number.SINGULAR) && !this.person.equals((Object)Person.FIRST)) {
                    this.verbPhrase.add(0, "been");
                    this.verbPhrase.add(0, "has");
                    this.finiteVerbIndex = 0;
                    this.mainVerbIndex += 2;
                } else {
                    this.verbPhrase.add(0, "been");
                    this.verbPhrase.add(0, "have");
                    this.finiteVerbIndex = 0;
                    this.mainVerbIndex += 2;
                }
            } else if (this.tense.equals((Object)Tense.PAST)) {
                this.verbPhrase.add(0, "been");
                this.verbPhrase.add(0, "had");
                this.finiteVerbIndex = 0;
                this.mainVerbIndex += 2;
            } else {
                this.verbPhrase.add(0, "been");
                this.verbPhrase.add(0, "will have");
                this.finiteVerbIndex = 0;
                this.mainVerbIndex += 2;
            }
        }
    }

    public void addAdverbialPhrase() {
        Random rand = new Random();
        boolean tryAnotherAdverb = true;
        boolean tryAnotherPrepPhrase = true;
        boolean addAdverb = false;
        while (tryAnotherAdverb || tryAnotherPrepPhrase) {
            int pos;
            if (tryAnotherAdverb && tryAnotherPrepPhrase) {
                if (rand.nextBoolean()) {
                    addAdverb = true;
                } else if (tryAnotherAdverb) {
                    addAdverb = true;
                }
            }
            if (addAdverb) {
                if (Util.randChance("adverb")) {
                    if (this.finiteVerbIndex == -1) {
                        switch (rand.nextInt(3)) {
                            case 0: {
                                pos = 0;
                                ++this.mainVerbIndex;
                                break;
                            }
                            case 1: {
                                pos = this.verbPhrase.size();
                                break;
                            }
                            default: {
                                pos = this.mainVerbIndex++;
                                break;
                            }
                        }
                    } else {
                        switch (rand.nextInt(4)) {
                            case 0: {
                                pos = 0;
                                ++this.mainVerbIndex;
                                ++this.finiteVerbIndex;
                                break;
                            }
                            case 1: {
                                pos = this.verbPhrase.size();
                                break;
                            }
                            case 2: {
                                pos = this.mainVerbIndex++;
                                break;
                            }
                            default: {
                                pos = this.finiteVerbIndex + 1;
                                ++this.mainVerbIndex;
                            }
                        }
                    }
                    if (Util.randChance("adverbPhrase")) {
                        this.verbPhrase.add(pos, new AdverbPhrase());
                    } else {
                        this.verbPhrase.add(pos, new Adverb());
                    }
                } else {
                    tryAnotherAdverb = false;
                }
            } else if (Util.randChance("prepositionalPhrase")) {
                switch (rand.nextInt(2)) {
                    case 0: {
                        pos = 0;
                        ++this.mainVerbIndex;
                        if (this.finiteVerbIndex == -1) break;
                        ++this.finiteVerbIndex;
                        break;
                    }
                    default: {
                        pos = this.verbPhrase.size();
                    }
                }
                this.verbPhrase.add(pos, new PrepositionalPhrase());
            } else {
                tryAnotherPrepPhrase = false;
            }
            addAdverb = false;
        }
    }
}

