/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.randomsentencegenerator.components;

import java.util.ArrayList;
import java.util.Random;
import tech.octopusdragon.randomsentencegenerator.components.Clause;
import tech.octopusdragon.randomsentencegenerator.components.partsofspeech.Conjunction;
import tech.octopusdragon.randomsentencegenerator.components.partsofspeech.Interjection;
import tech.octopusdragon.randomsentencegenerator.enums.ConjunctionType;
import tech.octopusdragon.randomsentencegenerator.util.Util;

public class Sentence {
    ArrayList<Object> sentence = new ArrayList();

    public void constructSentence() {
        this.sentence.add(new Clause());
        if (Util.randChance("compoundSentence")) {
            this.sentence.add(",");
            this.sentence.add(new Conjunction(ConjunctionType.COORDINATING));
            this.sentence.add(new Clause());
        } else if (Util.randChanceContinued("complexSentence")) {
            if (new Random().nextBoolean()) {
                this.sentence.add(new Conjunction(ConjunctionType.SUBORDINATING));
                this.sentence.add(new Clause());
            } else {
                this.sentence.add(0, ",");
                this.sentence.add(0, new Clause());
                this.sentence.add(0, new Conjunction(ConjunctionType.SUBORDINATING));
            }
        }
        if (Util.randChance("interjection")) {
            this.sentence.add(0, new Interjection());
        }
    }

    public Sentence() {
        this.constructSentence();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        boolean capitalizeNext = true;
        int i = 0;
        while (i < this.sentence.size()) {
            if (capitalizeNext) {
                str.append(this.sentence.get(i).toString().substring(0, 1).toUpperCase());
                str.append(this.sentence.get(i).toString().substring(1));
                capitalizeNext = false;
            } else {
                str.append(this.sentence.get(i).toString());
            }
            if (this.sentence.get(i).toString().charAt(this.sentence.get(i).toString().length() - 1) == '.' || this.sentence.get(i).toString().charAt(this.sentence.get(i).toString().length() - 1) == '!' || this.sentence.get(i).toString().charAt(this.sentence.get(i).toString().length() - 1) == '?') {
                capitalizeNext = true;
            }
            if (i == this.sentence.size() - 1) {
                str.append(".");
            } else if (this.sentence.get(i + 1).toString().charAt(this.sentence.get(i + 1).toString().length() - 1) != ',') {
                str.append(" ");
            }
            ++i;
        }
        return str.toString();
    }
}

