/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.randomsentencegenerator.components;

import java.util.ArrayList;
import java.util.Random;
import tech.octopusdragon.randomsentencegenerator.components.partsofspeech.Conjunction;
import tech.octopusdragon.randomsentencegenerator.components.phrases.NounPhrase;
import tech.octopusdragon.randomsentencegenerator.components.phrases.VerbPhrase;
import tech.octopusdragon.randomsentencegenerator.enums.Case;
import tech.octopusdragon.randomsentencegenerator.enums.ConjunctionType;
import tech.octopusdragon.randomsentencegenerator.util.Util;

public class Clause {
    private int subjectIndex;
    ArrayList<Object> clause = new ArrayList();

    public void constructClause(int pattern) {
        Random rand = new Random();
        NounPhrase subject = new NounPhrase(Case.SUBJECT);
        VerbPhrase predicate = new VerbPhrase(pattern, subject.getNumber(), subject.getPerson());
        for (Object object : predicate.getVerbPhrase()) {
            this.clause.add(object);
        }
        this.clause.add(predicate.getFiniteVerbIndex(), subject);
        this.subjectIndex = predicate.getFiniteVerbIndex();
        if (Util.randChance("compoundVerb")) {
            this.clause.add(new Conjunction(ConjunctionType.COORDINATING));
            this.clause.add(new VerbPhrase(rand.nextInt(4) + 1, subject.getNumber(), subject.getPerson()));
        }
        int i = 0;
        while (i < this.clause.size()) {
            if (i < this.subjectIndex) {
                this.clause.add(i + 1, ",");
                ++i;
                ++this.subjectIndex;
            }
            ++i;
        }
    }

    public Clause(int pattern) {
        this.constructClause(pattern);
    }

    public Clause() {
        int pattern = Util.randChance("pattern1") ? 1 : (Util.randChanceContinued("pattern2") ? 2 : (Util.randChanceContinued("pattern3") ? 3 : (Util.randChanceContinued("pattern4") ? 4 : 5)));
        this.constructClause(pattern);
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.clause.size() - 1) {
            str = this.clause.get(i + 1).toString().equals(",") ? String.valueOf(str) + this.clause.get(i) : String.valueOf(str) + this.clause.get(i) + " ";
            ++i;
        }
        str = String.valueOf(str) + this.clause.get(i);
        return str;
    }
}

