/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.pokemontypegame.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import tech.octopusdragon.pokemontypegame.Pokemon;
import tech.octopusdragon.pokemontypegame.gui.BackgroundGradient;
import tech.octopusdragon.pokemontypegame.gui.GameMode;

public class Userdata
implements Serializable {
    private static final long serialVersionUID = -6762807013732896858L;
    private static final String USERDATA_FOLDERNAME = "userdata";
    private static final String USERDATA_FILENAME = "pokemon_type_game_userdata.ser";
    private static final String WIDTH_KEY = "width";
    private static final double DEFAULT_WIDTH_VALUE = 500.0;
    private static final String HEIGHT_KEY = "height";
    private static final double DEFAULT_HEIGHT_VALUE = 750.0;
    private static final String MAXIMIZED_KEY = "maximized";
    private static final boolean DEFAULT_MAXIMIZED_VALUE = false;
    private static final String MUTED_KEY = "muted";
    private static final boolean DEFAULT_MUTED_VALUE = false;
    private static final String BACKGROUND_GRADIENT_KEY = "backgroundGradient";
    private static final BackgroundGradient DEFAULT_BACKGROUND_GRADIENT_VALUE = BackgroundGradient.ORANGE;
    private static final String EASY_HIGHEST_STREAK_KEY = "easyHighestStreak";
    private static final String MEDIUM_HIGHEST_STREAK_KEY = "mediumHighestStreak";
    private static final String HARD_HIGHEST_STREAK_KEY = "hardHighestStreak";
    private static final int DEFAULT_HIGHEST_STREAK_VALUE = 0;
    private static final String MEDIUM_GEN_ENABLED_KEY = "medium-gen-%d-enabled";
    private static final boolean DEFAULT_MEDIUM_GEN_ENABLED_VALUE = true;
    private static final String MEDIUM_MEGA_ENABLED_KEY = "medium-mega-enabled";
    private static final boolean DEFAULT_MEDIUM_MEGA_ENABLED_VALUE = false;
    private static final String MEDIUM_REGIONAL_ENABLED_KEY = "medium-regional-enabled";
    private static final boolean DEFAULT_MEDIUM_REGIONAL_ENABLED_VALUE = true;
    private Properties userdata = new Properties();

    public static Userdata load() {
        Userdata object = null;
        try {
            FileInputStream fileIn = new FileInputStream("userdata/pokemon_type_game_userdata.ser");
            ObjectInputStream objectIn = new ObjectInputStream(fileIn);
            object = (Userdata)objectIn.readObject();
            objectIn.close();
        }
        catch (IOException | ClassNotFoundException e) {
            object = new Userdata();
        }
        return object;
    }

    public void save() {
        File folder = new File(USERDATA_FOLDERNAME);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            FileOutputStream fileOut = new FileOutputStream("userdata/pokemon_type_game_userdata.ser");
            ObjectOutputStream objectOut = new ObjectOutputStream(fileOut);
            objectOut.writeObject(this);
            objectOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String readProperty(String key, String defaultValue) {
        String value = this.userdata.getProperty(key);
        if (value == null) {
            this.writeProperty(key, defaultValue);
            return defaultValue;
        }
        return this.userdata.getProperty(key);
    }

    private void writeProperty(String key, String value) {
        this.userdata.setProperty(key, value);
    }

    public double readWidth() {
        return Double.parseDouble(this.readProperty(WIDTH_KEY, Double.toString(500.0)));
    }

    public void writeWidth(double value) {
        this.writeProperty(WIDTH_KEY, Double.toString(value));
    }

    public double readHeight() {
        return Double.parseDouble(this.readProperty(HEIGHT_KEY, Double.toString(750.0)));
    }

    public void writeHeight(double value) {
        this.writeProperty(HEIGHT_KEY, Double.toString(value));
    }

    public boolean readMaximized() {
        return Boolean.parseBoolean(this.readProperty(MAXIMIZED_KEY, Boolean.toString(false)));
    }

    public void writeMaximized(boolean value) {
        this.writeProperty(MAXIMIZED_KEY, Boolean.toString(value));
    }

    public boolean readMuted() {
        return Boolean.parseBoolean(this.readProperty(MUTED_KEY, Boolean.toString(false)));
    }

    public void writeMuted(boolean value) {
        this.writeProperty(MUTED_KEY, Boolean.toString(value));
    }

    public BackgroundGradient readBackgroundGradient() {
        return BackgroundGradient.valueOf(this.readProperty(BACKGROUND_GRADIENT_KEY, DEFAULT_BACKGROUND_GRADIENT_VALUE.toString()));
    }

    public void writeBackgroundGradient(BackgroundGradient value) {
        this.writeProperty(BACKGROUND_GRADIENT_KEY, value.toString());
    }

    public int readHighestStreak(GameMode gameMode) {
        int highestStreak = 0;
        switch (gameMode) {
            case EASY: {
                highestStreak = this.readEasyHighestStreak();
                break;
            }
            case MEDIUM: {
                highestStreak = this.readMediumHighestStreak();
                break;
            }
            case HARD: {
                highestStreak = this.readHardHighestStreak();
            }
        }
        return highestStreak;
    }

    public void writeHighestStreak(GameMode gameMode, int value) {
        switch (gameMode) {
            case EASY: {
                this.writeEasyHighestStreak(value);
                break;
            }
            case MEDIUM: {
                this.writeMediumHighestStreak(value);
                break;
            }
            case HARD: {
                this.writeHardHighestStreak(value);
            }
        }
    }

    private int readEasyHighestStreak() {
        return Integer.parseInt(this.readProperty(EASY_HIGHEST_STREAK_KEY, Integer.toString(0)));
    }

    private void writeEasyHighestStreak(int value) {
        this.writeProperty(EASY_HIGHEST_STREAK_KEY, Integer.toString(value));
    }

    private int readMediumHighestStreak() {
        return Integer.parseInt(this.readProperty(MEDIUM_HIGHEST_STREAK_KEY, Integer.toString(0)));
    }

    private void writeMediumHighestStreak(int value) {
        this.writeProperty(MEDIUM_HIGHEST_STREAK_KEY, Integer.toString(value));
    }

    private int readHardHighestStreak() {
        return Integer.parseInt(this.readProperty(HARD_HIGHEST_STREAK_KEY, Integer.toString(0)));
    }

    private void writeHardHighestStreak(int value) {
        this.writeProperty(HARD_HIGHEST_STREAK_KEY, Integer.toString(value));
    }

    public boolean readMediumGenEnabled(int generation) throws IllegalArgumentException {
        if (generation <= 0 || generation > Pokemon.getHighestGeneration()) {
            throw new IllegalArgumentException(String.format("Must be a number between %d and %d inclusive", 1, Pokemon.getHighestGeneration()));
        }
        return Boolean.parseBoolean(this.readProperty(String.format(MEDIUM_GEN_ENABLED_KEY, generation), Boolean.toString(true)));
    }

    public void writeMediumGenEnabled(int generation, boolean value) throws IllegalArgumentException {
        if (generation <= 0 || generation > Pokemon.getHighestGeneration()) {
            throw new IllegalArgumentException(String.format("Must be a number between %d and %d inclusive", 1, Pokemon.getHighestGeneration()));
        }
        this.writeProperty(String.format(MEDIUM_GEN_ENABLED_KEY, generation), Boolean.toString(value));
    }

    public boolean readMediumMegaEnabled() {
        return Boolean.parseBoolean(this.readProperty(MEDIUM_MEGA_ENABLED_KEY, Boolean.toString(false)));
    }

    public void writeMediumMegaEnabled(boolean value) {
        this.writeProperty(MEDIUM_MEGA_ENABLED_KEY, Boolean.toString(value));
    }

    public boolean readMediumRegionalEnabled() {
        return Boolean.parseBoolean(this.readProperty(MEDIUM_REGIONAL_ENABLED_KEY, Boolean.toString(true)));
    }

    public void writeMediumRegionalEnabled(boolean value) {
        this.writeProperty(MEDIUM_REGIONAL_ENABLED_KEY, Boolean.toString(value));
    }
}

