/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.pokemontypegame.gui;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import tech.octopusdragon.pokemontypegame.Type;

public class TypeButton
extends Group {
    private static final double FRAME_BUTTON_RATIO = 0.8;
    private Type type;
    private boolean disabled = false;
    private DoubleProperty fitWidthProperty = new SimpleDoubleProperty();
    private DoubleProperty fitHeightProperty = new SimpleDoubleProperty();
    private ImageView typeImageView;
    private InnerShadow shadow;
    private Circle outerFrame = new Circle();
    private InnerShadow outerFrameShadow;
    private Circle innerFrame;
    private InnerShadow innerFrameShadow;

    public TypeButton() {
        this.outerFrame.setFill((Paint)Color.GRAY);
        this.getChildren().add((Object)this.outerFrame);
        this.outerFrameShadow = new InnerShadow();
        this.outerFrameShadow.setColor(new Color(0.0, 0.0, 0.0, 0.33));
        this.outerFrame.setEffect((Effect)this.outerFrameShadow);
        this.innerFrame = new Circle();
        this.innerFrame.setFill((Paint)Color.GRAY);
        this.getChildren().add((Object)this.innerFrame);
        this.innerFrameShadow = new InnerShadow();
        this.innerFrameShadow.setColor(new Color(0.0, 0.0, 0.0, 0.33));
        this.innerFrame.setEffect((Effect)this.innerFrameShadow);
        this.typeImageView = new ImageView();
        this.typeImageView.setPreserveRatio(true);
        this.getChildren().add((Object)this.typeImageView);
        this.shadow = new InnerShadow();
        this.shadow.setColor(new Color(0.0, 0.0, 0.0, 0.33));
        this.typeImageView.setEffect((Effect)this.shadow);
        this.fitWidthProperty().addListener((observable, oldValue, newValue) -> this.resize());
        this.fitHeightProperty().addListener((observable, oldValue, newValue) -> this.resize());
        this.setOnMouseEntered(event -> {
            if (!this.disabled) {
                this.getScene().setCursor(Cursor.HAND);
            }
        });
        this.setOnMouseExited(event -> {
            if (!this.disabled) {
                this.getScene().setCursor(Cursor.DEFAULT);
            }
        });
    }

    public Type getType() {
        return this.type;
    }

    public void enable() {
        this.disabled = false;
    }

    public void disable() {
        this.disabled = true;
    }

    public void changeType(Type type) {
        this.type = type;
        this.typeImageView.setImage(new Image("resources/img/type/" + type.getImageFilename()));
    }

    public double getFitWidth() {
        return this.fitWidthProperty.get();
    }

    public void setFitWidth(double value) {
        this.fitWidthProperty.set(value);
    }

    public DoubleProperty fitWidthProperty() {
        return this.fitWidthProperty;
    }

    public double getFitHeight() {
        return this.fitHeightProperty.get();
    }

    public void setFitHeight(double value) {
        this.fitHeightProperty.set(value);
    }

    public DoubleProperty fitHeightProperty() {
        return this.fitHeightProperty;
    }

    private void resize() {
        double size = this.fitWidthProperty.get() < this.fitHeightProperty.get() ? this.fitWidthProperty.get() : this.fitHeightProperty.get();
        this.outerFrame.setRadius(size / 2.0);
        this.outerFrameShadow.setOffsetX(size / 6.0);
        this.outerFrameShadow.setOffsetY(-size / 6.0);
        this.outerFrameShadow.setRadius(size / 4.0);
        this.innerFrame.setRadius((size + size * 0.8) / 2.0 / 2.0);
        this.innerFrameShadow.setOffsetX(-size / 6.0);
        this.innerFrameShadow.setOffsetY(size / 6.0);
        this.innerFrameShadow.setRadius(size / 4.0);
        this.typeImageView.setX(-size * 0.8 / 2.0);
        this.typeImageView.setY(-size * 0.8 / 2.0);
        this.typeImageView.setFitWidth(size * 0.8);
        this.typeImageView.setFitHeight(size * 0.8);
        this.shadow.setOffsetX(size / 6.0);
        this.shadow.setOffsetY(-size / 6.0);
        this.shadow.setRadius(size / 4.0);
        this.setOnMousePressed(event -> {
            if (!this.disabled) {
                this.shadow.setOffsetX(-size / 6.0);
                this.shadow.setOffsetY(size / 6.0);
            }
        });
        this.setOnMouseReleased(event -> {
            if (!this.disabled) {
                this.shadow.setOffsetX(size / 6.0);
                this.shadow.setOffsetY(-size / 6.0);
            }
        });
    }
}

