/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.pokemontypegame.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.Stack;
import javafx.application.Application;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.stage.Stage;
import tech.octopusdragon.pokemontypegame.Game;
import tech.octopusdragon.pokemontypegame.Pokemon;
import tech.octopusdragon.pokemontypegame.PokemonGame;
import tech.octopusdragon.pokemontypegame.Type;
import tech.octopusdragon.pokemontypegame.TypeGame;
import tech.octopusdragon.pokemontypegame.gui.BackgroundGradient;
import tech.octopusdragon.pokemontypegame.gui.GameMode;
import tech.octopusdragon.pokemontypegame.gui.Userdata;

public class PokemonTypeGameApplication
extends Application {
    public static final double GUI_PREF_WIDTH = 800.0;
    public static final double MENU_MAX_HEIGHT = 550.0;
    public static final double MIN_WIDTH = 475.0;
    public static final double MIN_HEIGHT = 615.0;
    public static final double OPTION_BUTTON_SIZE = 45.0;
    public static final double POKEMON_TYPE_ICON_SIZE = 27.5;
    public static final String TYPE_IMAGES_DIR = "resources/img/type/";
    public static final String POKEMON_IMAGES_DIR = "resources/img/pkmn/";
    public static final String HELP_IMAGE_PATH = "resources/img/help.png";
    public static final String FAST_FORWARD_IMAGE_PATH = "resources/img/fast_forward.png";
    public static final String MUTE_IMAGE_PATH = "resources/img/mute.png";
    public static final String UNMUTE_IMAGE_PATH = "resources/img/unmute.png";
    public static final String ICON_PATH = "resources/img/icon.png";
    public static final String MENU_FXML_PATH = "Menu.fxml";
    public static final String GAME_SCREEN_FXML_PATH = "GameScreen.fxml";
    public static final String INSTRUCTIONS_FXML_PATH = "Instructions.fxml";
    private static final String SONG_DIR = "resources/audio/music/";
    private static final String PRESS_BUTTON_SOUND_DIR = "resources/audio/press_button.mp3";
    public static final String SONG_LIST_PATH = "resources/song_list.txt";
    public static final String HOW_TO_PLAY_PATH = "resources/how_to_play.txt";
    private static final String CSS_PATH = "resources/styles.css";
    public static final PseudoClass GEN_DISABLED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"gen-disabled");
    private static final int HARD_MODE_INTERVAL = 5;
    public static Game game;
    public static GameMode gameMode;
    public static Userdata userdata;
    private static MediaPlayer musicPlayer;
    private static MediaPlayer soundPlayer;
    private static Stack<String> shuffleList;
    public static BooleanProperty mutedProperty;
    public static ObjectProperty<BackgroundGradient> backgroundGradientProperty;
    public static BooleanProperty[] mediumIncludeGenProperty;
    public static BooleanProperty mediumIncludeMegaProperty;
    public static BooleanProperty mediumIncludeRegionalProperty;
    private static Stage stage;
    private static Scene scene;
    private static Parent root;

    public void init() {
        userdata = Userdata.load();
    }

    public void start(Stage primaryStage) {
        stage = primaryStage;
        mutedProperty = new SimpleBooleanProperty(userdata.readMuted());
        backgroundGradientProperty = new SimpleObjectProperty((Object)userdata.readBackgroundGradient());
        backgroundGradientProperty.addListener((observable, oldValue, newValue) -> PokemonTypeGameApplication.changeBackgroundGradient(newValue));
        PokemonTypeGameApplication.newShuffleList();
        PokemonTypeGameApplication.nextSong();
        soundPlayer = new MediaPlayer(new Media(((Object)((Object)this)).getClass().getClassLoader().getResource(PRESS_BUTTON_SOUND_DIR).toExternalForm()));
        soundPlayer.muteProperty().bind((ObservableValue)mutedProperty);
        soundPlayer.setOnEndOfMedia(() -> soundPlayer.stop());
        mediumIncludeGenProperty = new BooleanProperty[Pokemon.getHighestGeneration()];
        int i = 0;
        while (i < mediumIncludeGenProperty.length) {
            int gen = i + 1;
            PokemonTypeGameApplication.mediumIncludeGenProperty[i] = new SimpleBooleanProperty(userdata.readMediumGenEnabled(gen));
            mediumIncludeGenProperty[i].addListener((observable, oldValue, newValue) -> userdata.writeMediumGenEnabled(gen, (boolean)newValue));
            ++i;
        }
        mediumIncludeMegaProperty = new SimpleBooleanProperty(userdata.readMediumMegaEnabled());
        mediumIncludeMegaProperty.addListener((observable, oldValue, newValue) -> userdata.writeMediumMegaEnabled((boolean)newValue));
        mediumIncludeRegionalProperty = new SimpleBooleanProperty(userdata.readMediumRegionalEnabled());
        mediumIncludeRegionalProperty.addListener((observable, oldValue, newValue) -> userdata.writeMediumRegionalEnabled((boolean)newValue));
        primaryStage.setTitle("Pok\u00e9mon Type Game");
        primaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(ICON_PATH)));
        primaryStage.setWidth(userdata.readWidth());
        primaryStage.widthProperty().addListener((observable, oldValue, newValue) -> {
            if (!primaryStage.isMaximized()) {
                userdata.writeWidth(newValue.doubleValue());
            }
        });
        primaryStage.setHeight(userdata.readHeight());
        primaryStage.heightProperty().addListener((observable, oldValue, newValue) -> {
            if (!primaryStage.isMaximized()) {
                userdata.writeHeight(newValue.doubleValue());
            }
        });
        primaryStage.setMaximized(userdata.readMaximized());
        primaryStage.maximizedProperty().addListener((observable, oldValue, newValue) -> userdata.writeMaximized((boolean)newValue));
        PokemonTypeGameApplication.switchToScene(MENU_FXML_PATH);
        scene.getStylesheets().add((Object)PokemonTypeGameApplication.class.getClassLoader().getResource(CSS_PATH).toExternalForm());
        stage.setScene(scene);
        primaryStage.show();
        PokemonTypeGameApplication.setStageMinSize(primaryStage, 475.0, 615.0);
    }

    public void stop() {
        userdata.save();
    }

    public static void nextSong() {
        if (musicPlayer != null) {
            musicPlayer.stop();
        }
        if (shuffleList.isEmpty()) {
            PokemonTypeGameApplication.newShuffleList();
        }
        String filename = shuffleList.peek();
        Media song = null;
        try {
            song = new Media(PokemonTypeGameApplication.class.getClassLoader().getResource(shuffleList.pop()).toExternalForm());
        }
        catch (Exception e) {
            System.out.println(filename);
            e.printStackTrace();
        }
        musicPlayer = new MediaPlayer(song);
        musicPlayer.setOnEndOfMedia(() -> PokemonTypeGameApplication.nextSong());
        musicPlayer.muteProperty().bind((ObservableValue)mutedProperty);
        musicPlayer.play();
    }

    private static void newShuffleList() {
        shuffleList = new Stack();
        InputStream inputStream = PokemonTypeGameApplication.class.getClassLoader().getResourceAsStream(SONG_LIST_PATH);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader in = new BufferedReader(inputStreamReader);
        Scanner inputFile = new Scanner(in);
        while (inputFile.hasNext()) {
            String line = inputFile.nextLine();
            shuffleList.add(SONG_DIR + line);
        }
        inputFile.close();
        Collections.shuffle(shuffleList);
    }

    public static void toggleMute() {
        mutedProperty.set(!mutedProperty.get());
        userdata.writeMuted(mutedProperty.get());
    }

    public static void playSound() {
        soundPlayer.play();
    }

    public static void switchToScene(String fxmlPath) {
        try {
            root = (Parent)FXMLLoader.load((URL)PokemonTypeGameApplication.class.getResource(fxmlPath));
            if (scene == null) {
                scene = new Scene(root);
            } else {
                scene.setRoot(root);
            }
            PokemonTypeGameApplication.changeBackgroundGradient((BackgroundGradient)((Object)backgroundGradientProperty.get()));
        }
        catch (IOException e) {
            System.out.println("Unable to load FXML and set the scene.");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void rotateBackgroundGradient() {
        List<BackgroundGradient> values = Arrays.asList(BackgroundGradient.values());
        int curGradientIndex = values.indexOf(backgroundGradientProperty.get());
        int nextGradientIndex = curGradientIndex == values.size() - 1 ? 0 : curGradientIndex + 1;
        backgroundGradientProperty.set((Object)values.get(nextGradientIndex));
        userdata.writeBackgroundGradient((BackgroundGradient)((Object)backgroundGradientProperty.get()));
    }

    private static void changeBackgroundGradient(BackgroundGradient gradient) {
        root.setStyle(String.format("-fx-background-color: linear-gradient(%s);", gradient.getGradient()));
    }

    public static void newEasyGame() {
        game = new TypeGame();
        gameMode = GameMode.EASY;
    }

    public static void newMediumGame() {
        game = new PokemonGame();
        gameMode = GameMode.MEDIUM;
        PokemonTypeGameApplication.nextRound();
    }

    public static void newHardGame() {
        game = new PokemonGame();
        gameMode = GameMode.HARD;
        PokemonTypeGameApplication.nextRound();
    }

    public static void makeGuess(Type guess) {
        game.makeGuess(guess);
        if (game.getStreak() > userdata.readHighestStreak(gameMode)) {
            userdata.writeHighestStreak(gameMode, game.getStreak());
        }
    }

    public static void nextRound() {
        switch (gameMode) {
            case EASY: {
                game.nextRound();
                break;
            }
            case MEDIUM: {
                ArrayList<Integer> generationsToIncludeList = new ArrayList<Integer>();
                int i = 0;
                while (i < mediumIncludeGenProperty.length) {
                    if (mediumIncludeGenProperty[i].get()) {
                        generationsToIncludeList.add(i + 1);
                    }
                    ++i;
                }
                int[] generationsToInclude = new int[generationsToIncludeList.size()];
                int i2 = 0;
                while (i2 < generationsToInclude.length) {
                    generationsToInclude[i2] = (Integer)generationsToIncludeList.get(i2);
                    ++i2;
                }
                ((PokemonGame)game).nextRound(mediumIncludeMegaProperty.get(), mediumIncludeRegionalProperty.get(), generationsToInclude);
                break;
            }
            case HARD: {
                if (game.getStreak() / 5 + 1 > Pokemon.getHighestGeneration()) {
                    game.nextRound();
                    break;
                }
                ((PokemonGame)game).nextRound(false, true, game.getStreak() / 5 + 1);
            }
        }
    }

    public static void toggleIncludeGen(int generation) {
        mediumIncludeGenProperty[generation].set(!mediumIncludeGenProperty[generation].get());
    }

    public static void toggleIncludeMega() {
        mediumIncludeMegaProperty.set(!mediumIncludeMegaProperty.get());
    }

    public static void toggleIncludeRegional() {
        mediumIncludeRegionalProperty.set(!mediumIncludeRegionalProperty.get());
    }

    public static String defendingImagePath() {
        String path = "";
        if (game.getClass().equals(TypeGame.class)) {
            path = TYPE_IMAGES_DIR + game.getDefendingImageFilename();
        } else if (game.getClass().equals(PokemonGame.class)) {
            path = POKEMON_IMAGES_DIR + game.getDefendingImageFilename();
        }
        return path;
    }

    public static String attackingTypeImagePath(int index) {
        return TYPE_IMAGES_DIR + game.getAttackingType(index).getImageFilename();
    }

    private static void setStageMinSize(Stage stage, double width, double height) {
        double leftInsets = stage.getScene().getX();
        double topInsets = stage.getScene().getY();
        double rightInsets = stage.getScene().getWindow().getWidth() - stage.getScene().getWidth() - stage.getScene().getX();
        double bottomInsets = stage.getScene().getWindow().getHeight() - stage.getScene().getHeight() - stage.getScene().getY();
        stage.setMinWidth(width + leftInsets + rightInsets);
        stage.setMinHeight(height + topInsets + bottomInsets);
    }

    public static void main(String[] args) {
        PokemonTypeGameApplication.launch((String[])args);
    }
}

