/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.pokemontypegame.gui;

import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import tech.octopusdragon.pokemontypegame.gui.PokemonTypeGameApplication;

public class MenuController {
    @FXML
    public ImageView helpButton;
    @FXML
    public HBox buttonHbox;
    @FXML
    public VBox menuVbox;

    @FXML
    public void initialize() {
        this.helpButton.setImage(new Image("resources/img/help.png"));
        this.helpButton.setFitWidth(45.0);
        Platform.runLater(() -> {
            ReadOnlyDoubleProperty sceneWidthProperty = this.menuVbox.getScene().widthProperty();
            ReadOnlyDoubleProperty sceneHeightProperty = this.menuVbox.getScene().heightProperty();
            this.menuVbox.spacingProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                double sceneHeight = sceneHeightProperty.get();
                double newSpacing = sceneHeight > 550.0 ? 110.0 : sceneHeight / 5.0;
                return newSpacing;
            }, (Observable[])new Observable[]{sceneHeightProperty}));
            this.buttonHbox.spacingProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                double sceneWidth = sceneWidthProperty.get();
                double newSpacing = sceneWidth > 800.0 ? 800.0 / (double)(this.buttonHbox.getChildren().size() * 2) : sceneWidth / (double)(this.buttonHbox.getChildren().size() * 2);
                return newSpacing;
            }, (Observable[])new Observable[]{sceneWidthProperty}));
        });
    }

    public void switchToInstructionsScene(MouseEvent e) {
        PokemonTypeGameApplication.switchToScene("Instructions.fxml");
    }

    public void switchToEasyGameScene(ActionEvent e) {
        PokemonTypeGameApplication.playSound();
        PokemonTypeGameApplication.newEasyGame();
        PokemonTypeGameApplication.switchToScene("GameScreen.fxml");
    }

    public void switchToMediumGameScene(ActionEvent e) {
        PokemonTypeGameApplication.playSound();
        PokemonTypeGameApplication.newMediumGame();
        PokemonTypeGameApplication.switchToScene("GameScreen.fxml");
    }

    public void switchToHardGameScene(ActionEvent e) {
        PokemonTypeGameApplication.playSound();
        PokemonTypeGameApplication.newHardGame();
        PokemonTypeGameApplication.switchToScene("GameScreen.fxml");
    }
}

