/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.pokemontypegame.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import tech.octopusdragon.pokemontypegame.gui.BackgroundGradient;
import tech.octopusdragon.pokemontypegame.gui.PokemonTypeGameApplication;

public class InstructionsController {
    @FXML
    public ScrollPane bodyScrollPane;
    @FXML
    public Label bodyLabel;

    @FXML
    public void initialize() {
        this.bodyScrollPane.setMaxWidth(800.0);
        Platform.runLater(() -> {
            this.bodyScrollPane.applyCss();
            this.updateColors();
            PokemonTypeGameApplication.backgroundGradientProperty.addListener((observable, oldValue, newValue) -> this.updateColors());
        });
        try {
            String line;
            InputStream fstream = InstructionsController.class.getClassLoader().getResourceAsStream("resources/how_to_play.txt");
            BufferedReader inputFile = new BufferedReader(new InputStreamReader(fstream, "UTF-8"));
            StringBuilder howToPlay = new StringBuilder();
            while ((line = inputFile.readLine()) != null) {
                howToPlay.append(String.valueOf(line) + "\n\n");
            }
            howToPlay.deleteCharAt(howToPlay.length() - 1);
            fstream.close();
            this.bodyLabel.setText(howToPlay.toString());
        }
        catch (IOException e) {
            System.out.println("Error reading how to play file.");
            e.printStackTrace();
        }
    }

    public void switchToMenuScene(ActionEvent e) {
        PokemonTypeGameApplication.switchToScene("Menu.fxml");
    }

    public void updateColors() {
        this.bodyScrollPane.lookup(".thumb").setStyle(String.format("-fx-background-color: %s;", ((BackgroundGradient)((Object)PokemonTypeGameApplication.backgroundGradientProperty.get())).getMainColor()));
        this.bodyScrollPane.lookup(".track-background").setStyle(String.format("-fx-background-color: %s;", ((BackgroundGradient)((Object)PokemonTypeGameApplication.backgroundGradientProperty.get())).getSecondaryColor()));
        this.bodyScrollPane.lookup(".increment-button").setStyle(String.format("-fx-background-color: %s;", ((BackgroundGradient)((Object)PokemonTypeGameApplication.backgroundGradientProperty.get())).getMainColor()));
        this.bodyScrollPane.lookup(".increment-arrow").setStyle(String.format("-fx-background-color: %s;", ((BackgroundGradient)((Object)PokemonTypeGameApplication.backgroundGradientProperty.get())).getSecondaryColor()));
        this.bodyScrollPane.lookup(".decrement-button").setStyle(String.format("-fx-background-color: %s;", ((BackgroundGradient)((Object)PokemonTypeGameApplication.backgroundGradientProperty.get())).getMainColor()));
        this.bodyScrollPane.lookup(".decrement-arrow").setStyle(String.format("-fx-background-color: %s;", ((BackgroundGradient)((Object)PokemonTypeGameApplication.backgroundGradientProperty.get())).getSecondaryColor()));
    }
}

