/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.pokemontypegame.gui;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import tech.octopusdragon.pokemontypegame.GameState;
import tech.octopusdragon.pokemontypegame.PokemonGame;
import tech.octopusdragon.pokemontypegame.Type;
import tech.octopusdragon.pokemontypegame.TypeGame;
import tech.octopusdragon.pokemontypegame.gui.GameMode;
import tech.octopusdragon.pokemontypegame.gui.PokemonTypeGameApplication;
import tech.octopusdragon.pokemontypegame.gui.TypeButton;

public class GameScreenController {
    Label[] attackingTypeLabels;
    Pane[] attackingTypeWrapperPanes;
    TypeButton[] attackingTypeButtons;
    boolean mediumOptionsCondensed;
    @FXML
    public VBox optionsBox;
    @FXML
    public Label streakLabel;
    @FXML
    public GridPane mainContent;
    @FXML
    public GridPane mediumOptionsTopGridPane;
    @FXML
    public GridPane mediumOptionsBottomGridPane;
    public List<Button> genButtonList;
    @FXML
    public Button gen1Button;
    @FXML
    public Button gen2Button;
    @FXML
    public Button gen3Button;
    @FXML
    public Button gen4Button;
    @FXML
    public Button gen5Button;
    @FXML
    public Button gen6Button;
    @FXML
    public Button gen7Button;
    @FXML
    public CheckBox megaCheckBox;
    @FXML
    public CheckBox regionalCheckBox;
    @FXML
    public TitledPane defendingSide;
    @FXML
    public HBox defendingInfoBox;
    @FXML
    public Label defendingLabel;
    @FXML
    public ImageView defendingPokemonType1ImageView;
    @FXML
    public ImageView defendingPokemonType2ImageView;
    @FXML
    public Pane defendingWrapperPane;
    @FXML
    public ImageView defendingImageView;
    @FXML
    public TitledPane attackingSide;
    @FXML
    public HBox attackingSideBox;
    @FXML
    public VBox attackingType1;
    @FXML
    public Label attackingType1Label;
    @FXML
    public Pane attackingType1WrapperPane;
    public TypeButton attackingType1Button;
    @FXML
    public VBox attackingType2;
    @FXML
    public Label attackingType2Label;
    @FXML
    public Pane attackingType2WrapperPane;
    public TypeButton attackingType2Button;
    @FXML
    public VBox attackingType3;
    @FXML
    public Label attackingType3Label;
    @FXML
    public Pane attackingType3WrapperPane;
    public TypeButton attackingType3Button;
    @FXML
    public VBox attackingType4;
    @FXML
    public Label attackingType4Label;
    @FXML
    public Pane attackingType4WrapperPane;
    public TypeButton attackingType4Button;
    @FXML
    public Label messageLabel;
    @FXML
    public HBox nextButtonWrapperPane;
    @FXML
    public Button nextButton;

    @FXML
    public void initialize() {
        this.buildScene();
        this.updateScene();
        this.mediumOptionsTopGridPane.setMaxWidth(1200.0);
        this.mediumOptionsBottomGridPane.setMaxWidth(1200.0);
        Platform.runLater(() -> {
            ReadOnlyDoubleProperty sceneWidthProperty = this.defendingSide.getScene().widthProperty();
            ReadOnlyDoubleProperty sceneHeightProperty = this.defendingSide.getScene().heightProperty();
            if (PokemonTypeGameApplication.gameMode == GameMode.MEDIUM) {
                this.condenseMediumOptions(sceneWidthProperty.get());
                sceneWidthProperty.addListener((observable, oldValue, newValue) -> this.condenseMediumOptions(newValue.intValue()));
            }
            this.optionsBox.spacingProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                double sceneHeight = sceneHeightProperty.get();
                double newFitHeight = sceneHeight / 100.0;
                return newFitHeight;
            }, (Observable[])new Observable[]{sceneHeightProperty}));
        });
        this.genButtonList = new ArrayList<Button>();
        this.genButtonList.add(this.gen1Button);
        this.genButtonList.add(this.gen2Button);
        this.genButtonList.add(this.gen3Button);
        this.genButtonList.add(this.gen4Button);
        this.genButtonList.add(this.gen5Button);
        this.genButtonList.add(this.gen6Button);
        this.genButtonList.add(this.gen7Button);
        Platform.runLater(() -> {
            int i = 0;
            while (i < this.genButtonList.size()) {
                Button genButton = this.genButtonList.get(i);
                PokemonTypeGameApplication.mediumIncludeGenProperty[i].addListener((observable, oldValue, newValue) -> {
                    if (newValue.booleanValue()) {
                        genButton.pseudoClassStateChanged(PokemonTypeGameApplication.GEN_DISABLED_PSEUDO_CLASS, false);
                    } else {
                        genButton.pseudoClassStateChanged(PokemonTypeGameApplication.GEN_DISABLED_PSEUDO_CLASS, true);
                    }
                });
                ++i;
            }
            i = 0;
            while (i < this.genButtonList.size()) {
                if (PokemonTypeGameApplication.mediumIncludeGenProperty[i].get()) {
                    this.genButtonList.get(i).pseudoClassStateChanged(PokemonTypeGameApplication.GEN_DISABLED_PSEUDO_CLASS, false);
                } else {
                    this.genButtonList.get(i).pseudoClassStateChanged(PokemonTypeGameApplication.GEN_DISABLED_PSEUDO_CLASS, true);
                }
                ++i;
            }
            this.megaCheckBox.setSelected(PokemonTypeGameApplication.mediumIncludeMegaProperty.get());
            this.regionalCheckBox.setSelected(PokemonTypeGameApplication.mediumIncludeRegionalProperty.get());
        });
        ChangeListener<Object> listener = new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                GameScreenController.this.refreshLayout();
            }
        };
        Platform.runLater(() -> this.lambda$5((ChangeListener)listener));
        this.defendingImageView.fitHeightProperty().bind((ObservableValue)this.defendingWrapperPane.heightProperty());
        this.attackingSideBox.spacingProperty().bind((ObservableValue)this.attackingSideBox.heightProperty().divide(8));
        int i = 0;
        while (i < this.attackingTypeButtons.length) {
            Pane attackingTypePane = this.attackingTypeWrapperPanes[i];
            this.attackingTypeButtons[i].setFitWidth(Double.MAX_VALUE);
            this.attackingSide.heightProperty().addListener((obs, oldVal, newVa) -> {
                attackingTypePane.layout();
                attackingTypePane.autosize();
            });
            ++i;
        }
        Platform.runLater(() -> {
            int i = 0;
            while (i < this.attackingTypeButtons.length) {
                this.attackingTypeButtons[i].fitHeightProperty().bind((ObservableValue)this.attackingTypeWrapperPanes[i].heightProperty());
                this.attackingTypeButtons[i].layoutXProperty().bind((ObservableValue)this.attackingTypeButtons[i].fitHeightProperty().divide(2));
                this.attackingTypeButtons[i].layoutYProperty().bind((ObservableValue)this.attackingTypeButtons[i].fitHeightProperty().divide(2));
                ++i;
            }
        });
        this.nextButton.prefHeightProperty().bind((ObservableValue)this.nextButtonWrapperPane.heightProperty());
        this.nextButton.prefWidthProperty().bind((ObservableValue)this.nextButtonWrapperPane.heightProperty().multiply(1.5));
        Platform.runLater(() -> this.nextButton.setStyle(String.format("-fx-font-size: %fpx", this.nextButton.getHeight() / 2.0)));
    }

    public void refreshLayout() {
        Platform.runLater(() -> {
            this.defendingWrapperPane.layout();
            this.defendingWrapperPane.autosize();
            int i = 0;
            while (i < this.attackingTypeButtons.length) {
                this.attackingTypeWrapperPanes[i].layout();
                this.attackingTypeWrapperPanes[i].autosize();
                ++i;
            }
            this.nextButton.setStyle(String.format("-fx-font-size: %fpx", this.nextButton.getHeight() / 2.0));
        });
    }

    public void switchToMenuScene(ActionEvent e) {
        PokemonTypeGameApplication.switchToScene("Menu.fxml");
    }

    public void makeGuess(Type guess) {
        PokemonTypeGameApplication.makeGuess(guess);
        if (PokemonTypeGameApplication.game.getState() == GameState.CORRECT_GUESS) {
            this.messageLabel.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"correct"), true);
        } else if (PokemonTypeGameApplication.game.getState() == GameState.INCORRECT_GUESS) {
            this.messageLabel.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"incorrect"), true);
        }
        TypeButton[] typeButtonArray = this.attackingTypeButtons;
        int n = this.attackingTypeButtons.length;
        int n2 = 0;
        while (n2 < n) {
            TypeButton attackingTypeButton = typeButtonArray[n2];
            attackingTypeButton.setDisable(true);
            ++n2;
        }
        this.nextButton.setDisable(false);
        this.updateScene();
    }

    public void nextRound(ActionEvent e) {
        if (PokemonTypeGameApplication.gameMode.equals((Object)GameMode.MEDIUM) && !this.atLeastOneGenerationSelected()) {
            this.messageLabel.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"correct"), false);
            this.messageLabel.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"incorrect"), true);
            this.messageLabel.setText("Please select at least one region to include.");
            return;
        }
        PokemonTypeGameApplication.nextRound();
        if (PokemonTypeGameApplication.game.getState() == GameState.HAS_NOT_MADE_GUESS) {
            this.messageLabel.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"correct"), false);
            this.messageLabel.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"incorrect"), false);
        }
        TypeButton[] typeButtonArray = this.attackingTypeButtons;
        int n = this.attackingTypeButtons.length;
        int n2 = 0;
        while (n2 < n) {
            TypeButton attackingTypeButton = typeButtonArray[n2];
            attackingTypeButton.setDisable(false);
            ++n2;
        }
        this.nextButton.setDisable(true);
        this.updateScene();
    }

    public void toggleIncludeGen(ActionEvent e) {
        int generation = this.genButtonList.indexOf((Button)e.getSource());
        if (PokemonTypeGameApplication.mediumIncludeGenProperty[generation].get() && !this.atLeastTwoGenerationsSelected()) {
            return;
        }
        PokemonTypeGameApplication.toggleIncludeGen(generation);
    }

    public void toggleIncludeMega(ActionEvent e) {
        PokemonTypeGameApplication.toggleIncludeMega();
    }

    public void toggleIncludeRegional() {
        PokemonTypeGameApplication.toggleIncludeRegional();
    }

    public boolean atLeastOneGenerationSelected() {
        boolean atLeastOneSelected = false;
        BooleanProperty[] booleanPropertyArray = PokemonTypeGameApplication.mediumIncludeGenProperty;
        int n = PokemonTypeGameApplication.mediumIncludeGenProperty.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanProperty genSelectedProperty = booleanPropertyArray[n2];
            if (genSelectedProperty.get()) {
                atLeastOneSelected = true;
                break;
            }
            ++n2;
        }
        return atLeastOneSelected;
    }

    public boolean atLeastTwoGenerationsSelected() {
        int numSelected = 0;
        BooleanProperty[] booleanPropertyArray = PokemonTypeGameApplication.mediumIncludeGenProperty;
        int n = PokemonTypeGameApplication.mediumIncludeGenProperty.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanProperty genSelectedProperty = booleanPropertyArray[n2];
            if (genSelectedProperty.get()) {
                ++numSelected;
            }
            ++n2;
        }
        return numSelected >= 2;
    }

    private void buildScene() {
        switch (PokemonTypeGameApplication.gameMode) {
            case EASY: 
            case HARD: {
                this.optionsBox.getChildren().remove((Object)this.mediumOptionsTopGridPane);
                this.optionsBox.getChildren().remove((Object)this.mediumOptionsBottomGridPane);
                break;
            }
        }
        this.defendingPokemonType1ImageView.setFitWidth(27.5);
        this.defendingPokemonType2ImageView.setFitWidth(27.5);
        switch (PokemonTypeGameApplication.gameMode) {
            case EASY: 
            case HARD: {
                this.defendingInfoBox.getChildren().removeAll((Object[])new Node[]{this.defendingPokemonType1ImageView, this.defendingPokemonType2ImageView});
                break;
            }
        }
        this.attackingType1Button = new TypeButton();
        this.attackingType1Button.setOnMouseClicked(new TypeButtonClickHandler());
        this.attackingType1WrapperPane.getChildren().add((Object)this.attackingType1Button);
        this.attackingType2Button = new TypeButton();
        this.attackingType2Button.setOnMouseClicked(new TypeButtonClickHandler());
        this.attackingType2WrapperPane.getChildren().add((Object)this.attackingType2Button);
        this.attackingType3Button = new TypeButton();
        this.attackingType3Button.setOnMouseClicked(new TypeButtonClickHandler());
        this.attackingType3WrapperPane.getChildren().add((Object)this.attackingType3Button);
        this.attackingType4Button = new TypeButton();
        this.attackingType4Button.setOnMouseClicked(new TypeButtonClickHandler());
        this.attackingType4WrapperPane.getChildren().add((Object)this.attackingType4Button);
        this.attackingTypeLabels = new Label[]{this.attackingType1Label, this.attackingType2Label, this.attackingType3Label, this.attackingType4Label};
        this.attackingTypeWrapperPanes = new Pane[]{this.attackingType1WrapperPane, this.attackingType2WrapperPane, this.attackingType3WrapperPane, this.attackingType4WrapperPane};
        this.attackingTypeButtons = new TypeButton[]{this.attackingType1Button, this.attackingType2Button, this.attackingType3Button, this.attackingType4Button};
        if (PokemonTypeGameApplication.game.getClass().equals(TypeGame.class)) {
            this.attackingType4.getChildren().clear();
            this.attackingSideBox.getChildren().remove((Object)this.attackingType4);
        }
        switch (PokemonTypeGameApplication.gameMode) {
            case EASY: {
                ((RowConstraints)this.mainContent.getRowConstraints().get(0)).setPercentHeight(((RowConstraints)this.mainContent.getRowConstraints().get(0)).getPercentHeight() - 5.0);
                ((RowConstraints)this.mainContent.getRowConstraints().get(2)).setPercentHeight(((RowConstraints)this.mainContent.getRowConstraints().get(2)).getPercentHeight() + 5.0);
                break;
            }
            case MEDIUM: 
            case HARD: {
                this.attackingType1.getChildren().remove((Object)this.attackingType1Label);
                this.attackingType2.getChildren().remove((Object)this.attackingType2Label);
                this.attackingType3.getChildren().remove((Object)this.attackingType3Label);
                this.attackingType4.getChildren().remove((Object)this.attackingType4Label);
            }
        }
        this.attackingSide.setMaxHeight(8.0 * ((RowConstraints)this.mainContent.getRowConstraints().get(2)).getPercentHeight());
        if (PokemonTypeGameApplication.game.getClass().equals(TypeGame.class)) {
            this.defendingSide.setText("Opponent Pok\u00e9mon's Type");
        } else if (PokemonTypeGameApplication.game.getClass().equals(PokemonGame.class)) {
            this.defendingSide.setText("Opponent Pok\u00e9mon");
        }
        this.attackingSide.setText("Your Pok\u00e9mon's Attacks' Types");
        this.nextButton.setDisable(true);
    }

    private void updateScene() {
        this.streakLabel.setText(String.format("%d\t%d", PokemonTypeGameApplication.game.getStreak(), PokemonTypeGameApplication.userdata.readHighestStreak(PokemonTypeGameApplication.gameMode)));
        this.defendingLabel.setText(PokemonTypeGameApplication.game.getDefendingName().toUpperCase());
        switch (PokemonTypeGameApplication.gameMode) {
            case EASY: 
            case HARD: {
                break;
            }
            case MEDIUM: {
                Type[] defendingPokemonTypes = ((PokemonGame)PokemonTypeGameApplication.game).getDefendingPokemon().getTypes();
                this.defendingPokemonType1ImageView.setImage(new Image(this.getClass().getClassLoader().getResourceAsStream("resources/img/type/" + defendingPokemonTypes[0].getImageFilename())));
                if (defendingPokemonTypes.length == 2) {
                    this.defendingPokemonType2ImageView.setImage(new Image(this.getClass().getClassLoader().getResourceAsStream("resources/img/type/" + defendingPokemonTypes[1].getImageFilename())));
                    if (this.defendingInfoBox.getChildren().contains((Object)this.defendingPokemonType2ImageView)) break;
                    this.defendingInfoBox.getChildren().add((Object)this.defendingPokemonType2ImageView);
                    break;
                }
                if (!this.defendingInfoBox.getChildren().contains((Object)this.defendingPokemonType2ImageView)) break;
                this.defendingInfoBox.getChildren().remove((Object)this.defendingPokemonType2ImageView);
            }
        }
        this.defendingImageView.setImage(new Image(this.getClass().getClassLoader().getResourceAsStream(PokemonTypeGameApplication.defendingImagePath())));
        this.messageLabel.setText(PokemonTypeGameApplication.game.message());
        switch (PokemonTypeGameApplication.gameMode) {
            case EASY: {
                int i = 0;
                while (i < PokemonTypeGameApplication.game.numChoices()) {
                    this.attackingTypeLabels[i].setText(PokemonTypeGameApplication.game.getAttackingType(i).getName().toUpperCase());
                    ++i;
                }
            }
            case MEDIUM: 
            case HARD: {
                int i = 0;
                while (i < PokemonTypeGameApplication.game.numChoices()) {
                    this.attackingTypeButtons[i].changeType(PokemonTypeGameApplication.game.getAttackingType(i));
                    ++i;
                }
                break;
            }
        }
    }

    private void condenseMediumOptions(double sceneWidth) {
        if (this.mediumOptionsCondensed && sceneWidth >= 800.0) {
            this.mediumOptionsTopGridPane.getChildren().removeAll((Object[])new Node[]{this.gen6Button, this.gen7Button, this.megaCheckBox, this.regionalCheckBox});
            if (this.optionsBox.getChildren().contains((Object)this.mediumOptionsBottomGridPane)) {
                this.optionsBox.getChildren().remove((Object)this.mediumOptionsBottomGridPane);
            }
            this.mediumOptionsTopGridPane.add((Node)this.gen6Button, 5, 0);
            this.mediumOptionsTopGridPane.add((Node)this.gen7Button, 6, 0);
            this.mediumOptionsTopGridPane.add((Node)this.megaCheckBox, 7, 0);
            this.mediumOptionsTopGridPane.add((Node)this.regionalCheckBox, 8, 0);
            this.mediumOptionsCondensed = false;
        } else if (!this.mediumOptionsCondensed && sceneWidth < 800.0) {
            this.mediumOptionsBottomGridPane.getChildren().removeAll((Object[])new Node[]{this.gen6Button, this.gen7Button, this.megaCheckBox, this.regionalCheckBox});
            if (!this.optionsBox.getChildren().contains((Object)this.mediumOptionsBottomGridPane)) {
                this.optionsBox.getChildren().add((Object)this.mediumOptionsBottomGridPane);
            }
            this.mediumOptionsBottomGridPane.add((Node)this.gen6Button, 0, 0);
            this.mediumOptionsBottomGridPane.add((Node)this.gen7Button, 1, 0);
            this.mediumOptionsBottomGridPane.add((Node)this.megaCheckBox, 2, 0);
            this.mediumOptionsBottomGridPane.add((Node)this.regionalCheckBox, 3, 0);
            this.mediumOptionsCondensed = true;
        }
    }

    private /* synthetic */ void lambda$5(ChangeListener changeListener) {
        this.defendingImageView.fitWidthProperty().bind((ObservableValue)this.defendingImageView.getScene().widthProperty());
        ((Stage)this.defendingImageView.getScene().getWindow()).widthProperty().addListener(changeListener);
        ((Stage)this.defendingImageView.getScene().getWindow()).heightProperty().addListener(changeListener);
        this.mainContent.layoutBoundsProperty().addListener(changeListener);
    }

    public class TypeButtonClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (PokemonTypeGameApplication.game.getState() == GameState.HAS_NOT_MADE_GUESS) {
                GameScreenController.this.makeGuess(((TypeButton)((Object)event.getSource())).getType());
                ((Node)event.getSource()).getScene().setCursor(Cursor.DEFAULT);
            }
        }
    }
}

