/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.pokemontypegame;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import tech.octopusdragon.pokemontypegame.Game;
import tech.octopusdragon.pokemontypegame.GameState;
import tech.octopusdragon.pokemontypegame.Type;

public class TypeGame
implements Game {
    public static final int NUM_CHOICES = 3;
    private Type defendingType;
    private Type[] attackingTypes = new Type[3];
    private Type guess;
    private GameState state;
    private int streak = 0;

    @Override
    public int numChoices() {
        return 3;
    }

    public TypeGame() {
        this.nextRound();
    }

    @Override
    public void nextRound() {
        this.generateDefendingType();
        this.generateAttackingTypes();
        this.guess = null;
        this.state = GameState.HAS_NOT_MADE_GUESS;
    }

    @Override
    public boolean makeGuess(Type guess) {
        boolean correct = false;
        if (this.defendingType.getWeaknesses().contains((Object)guess)) {
            correct = true;
        }
        this.guess = guess;
        this.state = correct ? GameState.CORRECT_GUESS : GameState.INCORRECT_GUESS;
        this.streak = correct ? ++this.streak : 0;
        return correct;
    }

    @Override
    public String getDefendingName() {
        return this.defendingType.getName();
    }

    @Override
    public String getDefendingImageFilename() {
        return this.defendingType.getImageFilename();
    }

    private void generateDefendingType() {
        Random rand = new Random();
        this.defendingType = Type.values()[rand.nextInt(Type.values().length)];
    }

    private void generateAttackingTypes() {
        Random rand = new Random();
        ArrayList<Type> attackingTypesList = new ArrayList<Type>();
        Type correctAnswer = this.defendingType.getWeaknesses().get(rand.nextInt(this.defendingType.getWeaknesses().size()));
        attackingTypesList.add(correctAnswer);
        ArrayList<Type> incorrectAsnwers = new ArrayList<Type>(Arrays.asList(Type.values()));
        for (Type weakness : this.defendingType.getWeaknesses()) {
            incorrectAsnwers.remove((Object)weakness);
        }
        int i = 1;
        while (i < 3) {
            attackingTypesList.add((Type)((Object)incorrectAsnwers.remove(rand.nextInt(incorrectAsnwers.size()))));
            ++i;
        }
        Collections.shuffle(attackingTypesList);
        i = 0;
        while (i < 3) {
            this.attackingTypes[i] = (Type)((Object)attackingTypesList.get(i));
            ++i;
        }
    }

    public Type getDefendingType() {
        return this.defendingType;
    }

    @Override
    public Type[] getAttackingTypes() {
        return (Type[])this.attackingTypes.clone();
    }

    @Override
    public Type getAttackingType(int index) {
        return this.attackingTypes[index];
    }

    @Override
    public GameState getState() {
        return this.state;
    }

    @Override
    public int getStreak() {
        return this.streak;
    }

    @Override
    public String message() {
        StringBuilder sb = new StringBuilder();
        if (this.state == GameState.HAS_NOT_MADE_GUESS) {
            sb.append("Select the type that is supereffective against the opponent's Pok\u00e9mon.");
        } else if (this.state == GameState.CORRECT_GUESS) {
            sb.append(String.format("Correct! %s is weak to %s.", new Object[]{this.defendingType, this.guess}));
            List<Type> otherWeaknesses = this.defendingType.getWeaknesses();
            otherWeaknesses.remove((Object)this.guess);
            if (otherWeaknesses.size() > 0) {
                sb.append(String.format(" %s is also weak to ", new Object[]{this.defendingType}));
                int i = 0;
                while (i < otherWeaknesses.size() - 1) {
                    sb.append((Object)otherWeaknesses.get(i));
                    if (otherWeaknesses.size() > 2) {
                        sb.append(",");
                    }
                    sb.append(" ");
                    ++i;
                }
                if (otherWeaknesses.size() > 1) {
                    sb.append("and ");
                }
                sb.append(String.format("%s.", new Object[]{otherWeaknesses.get(otherWeaknesses.size() - 1)}));
            }
        } else if (this.state == GameState.INCORRECT_GUESS) {
            sb.append(String.format("Incorrect. %s is weak to ", new Object[]{this.defendingType}));
            List<Type> weaknesses = this.defendingType.getWeaknesses();
            int i = 0;
            while (i < weaknesses.size() - 1) {
                sb.append((Object)weaknesses.get(i));
                if (weaknesses.size() > 2) {
                    sb.append(",");
                }
                sb.append(" ");
                ++i;
            }
            if (weaknesses.size() > 1) {
                sb.append("and ");
            }
            sb.append(String.format("%s.", new Object[]{weaknesses.get(weaknesses.size() - 1)}));
        }
        return sb.toString();
    }
}

