/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.pokemontypegame;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum Type {
    NORMAL,
    FIRE,
    WATER,
    GRASS,
    ELECTRIC,
    ICE,
    FIGHTING,
    POISON,
    GROUND,
    FLYING,
    PSYCHIC,
    BUG,
    ROCK,
    GHOST,
    DRAGON,
    DARK,
    STEEL,
    FAIRY;

    private Type[] weaknesses;
    private Type[] resistances;
    private Type[] immunities;

    static {
        Type.NORMAL.weaknesses = new Type[]{FIGHTING};
        Type.NORMAL.resistances = new Type[0];
        Type.NORMAL.immunities = new Type[]{GHOST};
        Type.FIRE.weaknesses = new Type[]{WATER, GROUND, ROCK};
        Type.FIRE.resistances = new Type[]{FIRE, GRASS, ICE, BUG, STEEL, FAIRY};
        Type.FIRE.immunities = new Type[0];
        Type.WATER.weaknesses = new Type[]{GRASS, ELECTRIC};
        Type.WATER.resistances = new Type[]{FIRE, WATER, ICE, STEEL};
        Type.WATER.immunities = new Type[0];
        Type.GRASS.weaknesses = new Type[]{FIRE, ICE, POISON, FLYING, BUG};
        Type.GRASS.resistances = new Type[]{WATER, GRASS, ELECTRIC, GROUND};
        Type.GRASS.immunities = new Type[0];
        Type.ELECTRIC.weaknesses = new Type[]{GROUND};
        Type.ELECTRIC.resistances = new Type[]{ELECTRIC, FLYING, STEEL};
        Type.ELECTRIC.immunities = new Type[0];
        Type.ICE.weaknesses = new Type[]{FIRE, FIGHTING, ROCK, STEEL};
        Type.ICE.resistances = new Type[]{ICE};
        Type.ICE.immunities = new Type[0];
        Type.FIGHTING.weaknesses = new Type[]{FLYING, PSYCHIC, FAIRY};
        Type.FIGHTING.resistances = new Type[]{BUG, ROCK, DARK};
        Type.FIGHTING.immunities = new Type[0];
        Type.POISON.weaknesses = new Type[]{GROUND, PSYCHIC};
        Type.POISON.resistances = new Type[]{GRASS, FIGHTING, POISON, BUG, FAIRY};
        Type.POISON.immunities = new Type[0];
        Type.GROUND.weaknesses = new Type[]{WATER, GRASS, ICE};
        Type.GROUND.resistances = new Type[]{POISON, ROCK};
        Type.GROUND.immunities = new Type[]{ELECTRIC};
        Type.FLYING.weaknesses = new Type[]{ELECTRIC, ICE, ROCK};
        Type.FLYING.resistances = new Type[]{GRASS, FIGHTING, BUG};
        Type.FLYING.immunities = new Type[]{GROUND};
        Type.PSYCHIC.weaknesses = new Type[]{BUG, GHOST, DARK};
        Type.PSYCHIC.resistances = new Type[]{FIGHTING, PSYCHIC};
        Type.PSYCHIC.immunities = new Type[0];
        Type.BUG.weaknesses = new Type[]{FIRE, FLYING, ROCK};
        Type.BUG.resistances = new Type[]{GRASS, FIGHTING, GROUND};
        Type.BUG.immunities = new Type[0];
        Type.ROCK.weaknesses = new Type[]{WATER, GRASS, FIGHTING, GROUND, STEEL};
        Type.ROCK.resistances = new Type[]{NORMAL, FIRE, POISON, FIGHTING};
        Type.ROCK.immunities = new Type[0];
        Type.GHOST.weaknesses = new Type[]{GHOST, DARK};
        Type.GHOST.resistances = new Type[]{POISON, BUG};
        Type.GHOST.immunities = new Type[]{NORMAL, FIGHTING};
        Type.DRAGON.weaknesses = new Type[]{ICE, DRAGON, FAIRY};
        Type.DRAGON.resistances = new Type[]{FIRE, WATER, GRASS, ELECTRIC};
        Type.DRAGON.immunities = new Type[0];
        Type.DARK.weaknesses = new Type[]{FIGHTING, BUG, FAIRY};
        Type.DARK.resistances = new Type[]{GHOST, DARK};
        Type.DARK.immunities = new Type[]{PSYCHIC};
        Type.STEEL.weaknesses = new Type[]{FIRE, FIGHTING, GROUND};
        Type.STEEL.resistances = new Type[]{NORMAL, GRASS, ICE, FLYING, PSYCHIC, BUG, ROCK, DRAGON, STEEL, FAIRY};
        Type.STEEL.immunities = new Type[]{POISON};
        Type.FAIRY.weaknesses = new Type[]{POISON, STEEL};
        Type.FAIRY.resistances = new Type[]{FIGHTING, BUG, DARK};
        Type.FAIRY.immunities = new Type[]{DRAGON};
    }

    public String getName() {
        return String.valueOf(this.toString().substring(0, 1).toUpperCase()) + this.toString().substring(1).toLowerCase();
    }

    public String getImageFilename() {
        return String.valueOf(this.toString().toLowerCase()) + ".png";
    }

    public List<Type> getWeaknesses() {
        return new ArrayList<Type>(Arrays.asList(this.weaknesses));
    }

    public List<Type> getResistances() {
        return new ArrayList<Type>(Arrays.asList(this.resistances));
    }

    public List<Type> getImmunities() {
        return new ArrayList<Type>(Arrays.asList(this.immunities));
    }

    public List<Type> getNormals() {
        ArrayList<Type> normalDamageTypes = new ArrayList<Type>();
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            normalDamageTypes.add(type);
            ++n2;
        }
        for (Type weakness : this.getWeaknesses()) {
            normalDamageTypes.remove((Object)weakness);
        }
        for (Type resistance : this.getResistances()) {
            normalDamageTypes.remove((Object)resistance);
        }
        for (Type immunity : this.getImmunities()) {
            normalDamageTypes.remove((Object)immunity);
        }
        return normalDamageTypes;
    }
}

