/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.pokemontypegame;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import tech.octopusdragon.pokemontypegame.DamageTier;
import tech.octopusdragon.pokemontypegame.Game;
import tech.octopusdragon.pokemontypegame.GameState;
import tech.octopusdragon.pokemontypegame.Pokemon;
import tech.octopusdragon.pokemontypegame.Type;

public class PokemonGame
implements Game {
    public static final int NUM_CHOICES = 4;
    public static Map<Integer, List<Pokemon>> allPokemon;
    private Pokemon defendingPokemon;
    private Type[] attackingTypes;
    private Type guess;
    private Type answer;
    private GameState state;
    private int streak;

    @Override
    public int numChoices() {
        return 4;
    }

    public PokemonGame() {
        allPokemon = new HashMap<Integer, List<Pokemon>>();
        for (Pokemon pokemon : Pokemon.getAll()) {
            if (allPokemon.get(pokemon.getNumber()) == null) {
                allPokemon.put(pokemon.getNumber(), new ArrayList());
            }
            allPokemon.get(pokemon.getNumber()).add(pokemon);
        }
        this.attackingTypes = new Type[4];
        this.streak = 0;
        this.nextRound();
    }

    @Override
    public void nextRound() {
        this.generateDefendingPokemon();
        this.generateAttackingTypes();
        this.guess = null;
        this.state = GameState.HAS_NOT_MADE_GUESS;
    }

    public void nextRound(boolean includeMega, boolean includeRegional, int ... generations) {
        this.generateDefendingPokemon(includeMega, includeRegional, generations);
        this.generateAttackingTypes();
        this.guess = null;
        this.state = GameState.HAS_NOT_MADE_GUESS;
    }

    @Override
    public String getDefendingName() {
        return this.defendingPokemon.getName();
    }

    @Override
    public String getDefendingImageFilename() {
        return this.defendingPokemon.getImageFilename();
    }

    @Override
    public boolean makeGuess(Type guess) {
        this.guess = guess;
        boolean correct = guess == this.answer;
        this.guess = guess;
        this.state = correct ? GameState.CORRECT_GUESS : GameState.INCORRECT_GUESS;
        this.streak = correct ? ++this.streak : 0;
        return correct;
    }

    private void generateDefendingPokemon() {
        Random rand = new Random();
        List<Pokemon> forms = allPokemon.get(rand.nextInt(allPokemon.size()));
        this.defendingPokemon = forms.get(rand.nextInt(forms.size()));
    }

    private void generateDefendingPokemon(boolean includeMega, boolean includeRegional, int ... generations) {
        ArrayList<Integer> generationsList = new ArrayList<Integer>();
        int[] nArray = generations;
        int n = generations.length;
        int n2 = 0;
        while (n2 < n) {
            int generation = nArray[n2];
            generationsList.add(generation);
            ++n2;
        }
        HashMap curPokemon = new HashMap();
        for (Pokemon pokemon : Pokemon.getAll()) {
            if (pokemon.getIsMega() && !includeMega || pokemon.getIsRegional() && !includeRegional || !generationsList.contains(pokemon.getGeneration())) continue;
            if (curPokemon.get(pokemon.getNumber()) == null) {
                curPokemon.put(pokemon.getNumber(), new ArrayList());
            }
            ((List)curPokemon.get(pokemon.getNumber())).add(pokemon);
        }
        ArrayList curPokemonList = new ArrayList(curPokemon.values());
        Random rand = new Random();
        List forms = (List)curPokemonList.get(rand.nextInt(curPokemon.size()));
        this.defendingPokemon = (Pokemon)forms.get(rand.nextInt(forms.size()));
    }

    private void generateAttackingTypes() {
        Random rand = new Random();
        ArrayList<Type> attackingTypesList = new ArrayList<Type>();
        ArrayList<Type> typeChoices = new ArrayList<Type>(Arrays.asList(Type.values()));
        int i = 0;
        while (i < 4) {
            attackingTypesList.add((Type)((Object)typeChoices.remove(rand.nextInt(typeChoices.size()))));
            ++i;
        }
        while (this.multipleTypesInHighestTier(attackingTypesList)) {
            int index = this.randomHighestTierIndex(attackingTypesList);
            attackingTypesList.set(index, (Type)((Object)typeChoices.remove(rand.nextInt(typeChoices.size()))));
        }
        this.answer = (Type)((Object)attackingTypesList.get(this.randomHighestTierIndex(attackingTypesList)));
        Collections.shuffle(attackingTypesList);
        i = 0;
        while (i < 4) {
            this.attackingTypes[i] = (Type)((Object)attackingTypesList.get(i));
            ++i;
        }
    }

    private boolean multipleTypesInHighestTier(List<Type> typeList) {
        DamageTier highestTier = this.defendingPokemon.getDamageTier(typeList.get(0));
        boolean multipleHighest = false;
        int i = 1;
        while (i < 4) {
            if (this.defendingPokemon.getDamageTier(typeList.get(i)).compareTo(highestTier) == 0) {
                multipleHighest = true;
            } else if (this.defendingPokemon.getDamageTier(typeList.get(i)).compareTo(highestTier) > 0) {
                highestTier = this.defendingPokemon.getDamageTier(typeList.get(i));
                multipleHighest = false;
            }
            ++i;
        }
        return multipleHighest;
    }

    private int randomHighestTierIndex(List<Type> typeList) {
        DamageTier highestTier = this.defendingPokemon.getDamageTier(typeList.get(0));
        ArrayList<Integer> highestTierIndexes = new ArrayList<Integer>();
        highestTierIndexes.add(0);
        int i = 1;
        while (i < 4) {
            if (this.defendingPokemon.getDamageTier(typeList.get(i)).compareTo(highestTier) == 0) {
                highestTierIndexes.add(i);
            } else if (this.defendingPokemon.getDamageTier(typeList.get(i)).compareTo(highestTier) > 0) {
                highestTier = this.defendingPokemon.getDamageTier(typeList.get(i));
                highestTierIndexes.clear();
                highestTierIndexes.add(i);
            }
            ++i;
        }
        Random rand = new Random();
        return (Integer)highestTierIndexes.get(rand.nextInt(highestTierIndexes.size()));
    }

    public Pokemon getDefendingPokemon() {
        return this.defendingPokemon;
    }

    @Override
    public Type[] getAttackingTypes() {
        return (Type[])this.attackingTypes.clone();
    }

    @Override
    public Type getAttackingType(int index) {
        return this.attackingTypes[index];
    }

    @Override
    public GameState getState() {
        return this.state;
    }

    @Override
    public int getStreak() {
        return this.streak;
    }

    @Override
    public String message() {
        StringBuilder sb = new StringBuilder();
        String guessDamage = "";
        switch (this.defendingPokemon.getDamageTier(this.guess)) {
            case NO_DAMAGE: {
                guessDamage = "0x";
                break;
            }
            case QUARTER_DAMAGE: {
                guessDamage = "\u00bcx";
                break;
            }
            case HALF_DAMAGE: {
                guessDamage = "\u00bdx";
                break;
            }
            case NORMAL_DAMAGE: {
                guessDamage = "1x";
                break;
            }
            case DOUBLE_DAMAGE: {
                guessDamage = "2x";
                break;
            }
            case QUADRUPLE_DAMAGE: {
                guessDamage = "4x";
            }
        }
        String answerDamage = "";
        switch (this.defendingPokemon.getDamageTier(this.answer)) {
            case NO_DAMAGE: {
                answerDamage = "0x";
                break;
            }
            case QUARTER_DAMAGE: {
                answerDamage = "\u00bcx";
                break;
            }
            case HALF_DAMAGE: {
                answerDamage = "\u00bdx";
                break;
            }
            case NORMAL_DAMAGE: {
                answerDamage = "1x";
                break;
            }
            case DOUBLE_DAMAGE: {
                answerDamage = "2x";
                break;
            }
            case QUADRUPLE_DAMAGE: {
                answerDamage = "4x";
            }
        }
        if (this.state == GameState.HAS_NOT_MADE_GUESS) {
            sb.append("Select the type that is the most effective against the opponent's Pok\u00e9mon.");
        } else if (this.state == GameState.CORRECT_GUESS) {
            sb.append(String.format("Correct! Of the given types, %s is the most effective, dealing %s damage to %s.", new Object[]{this.answer, answerDamage, this.defendingPokemon}));
        } else if (this.state == GameState.INCORRECT_GUESS) {
            sb.append("Incorrect. As ");
            switch (Character.toUpperCase(this.defendingPokemon.getTypes()[0].toString().charAt(0))) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': {
                    sb.append("an");
                    break;
                }
                default: {
                    sb.append("a");
                }
            }
            sb.append(" ");
            if (this.defendingPokemon.getTypes().length == 2) {
                sb.append(String.format("%s/%s", new Object[]{this.defendingPokemon.getTypes()[0], this.defendingPokemon.getTypes()[1]}));
            } else {
                sb.append((Object)this.defendingPokemon.getTypes()[0]);
            }
            sb.append(" type, ");
            sb.append(String.format("%s deals %s damage to %s. The correct answer, %s, deals %s damage.", new Object[]{this.guess, guessDamage, this.defendingPokemon, this.answer, answerDamage}));
        }
        return sb.toString();
    }
}

