/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.pokemontypegame;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import tech.octopusdragon.pokemontypegame.DamageTier;
import tech.octopusdragon.pokemontypegame.Type;

public class Pokemon {
    private static final String POKEMON_LIST_PATH = "resources/pokemon.csv";
    private static Map<Integer, List<Pokemon>> pokemon = Pokemon.readPokemonList();
    private Type[] types;
    private int number;
    private String name;
    private int generation;
    private boolean isMega;
    private boolean isRegional;
    private String imageFilename;

    private Pokemon(int number, String name, Type ... types) {
        this.number = number;
        this.name = name;
        this.types = types;
    }

    private Pokemon(String line) {
        String[] tokens = line.split(",");
        int i = 0;
        while (i < tokens.length) {
            tokens[i] = tokens[i].trim();
            ++i;
        }
        if (tokens.length != 8) {
            throw new IllegalArgumentException("Incorrect number of tokens");
        }
        this.number = Integer.parseInt(tokens[0]);
        this.name = tokens[4];
        int numTypes = tokens[6].isEmpty() ? 1 : 2;
        this.types = new Type[numTypes];
        int i2 = 0;
        while (i2 < this.types.length) {
            this.types[i2] = Type.valueOf(tokens[5 + i2].toUpperCase());
            ++i2;
        }
        this.generation = Integer.parseInt(tokens[7]);
        this.isMega = !tokens[2].isEmpty();
        this.isRegional = !tokens[3].isEmpty();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%03d", this.number));
        if (!tokens[2].isEmpty()) {
            sb.append("-Mega");
        }
        if (!tokens[3].isEmpty()) {
            sb.append("-Alola");
        }
        if (!tokens[1].isEmpty()) {
            sb.append("-" + tokens[1]);
        }
        sb.append(".png");
        this.imageFilename = sb.toString();
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public int getGeneration() {
        return this.generation;
    }

    public boolean getIsMega() {
        return this.isMega;
    }

    public boolean getIsRegional() {
        return this.isRegional;
    }

    public Type[] getTypes() {
        return (Type[])this.types.clone();
    }

    public String getImageFilename() {
        return this.imageFilename;
    }

    public List<Type> get4xWeaknesses() {
        ArrayList<Type> quadWeaknesses = new ArrayList<Type>();
        if (this.types.length == 1) {
            return quadWeaknesses;
        }
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (this.types[0].getWeaknesses().contains((Object)type) && this.types[1].getWeaknesses().contains((Object)type)) {
                quadWeaknesses.add(type);
            }
            ++n2;
        }
        return quadWeaknesses;
    }

    public List<Type> get2xWeaknesses() {
        ArrayList<Type> doubWeaknesses = new ArrayList<Type>();
        if (this.types.length == 1) {
            return this.types[0].getWeaknesses();
        }
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (this.types[0].getWeaknesses().contains((Object)type) && this.types[1].getNormals().contains((Object)type) || this.types[0].getNormals().contains((Object)type) && this.types[1].getWeaknesses().contains((Object)type)) {
                doubWeaknesses.add(type);
            }
            ++n2;
        }
        return doubWeaknesses;
    }

    public List<Type> get2xResistances() {
        ArrayList<Type> doubResistances = new ArrayList<Type>();
        if (this.types.length == 1) {
            return this.types[0].getResistances();
        }
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (this.types[0].getResistances().contains((Object)type) && this.types[1].getNormals().contains((Object)type) || this.types[0].getNormals().contains((Object)type) && this.types[1].getResistances().contains((Object)type)) {
                doubResistances.add(type);
            }
            ++n2;
        }
        return doubResistances;
    }

    public List<Type> get4xResistances() {
        ArrayList<Type> quadResistances = new ArrayList<Type>();
        if (this.types.length == 1) {
            return quadResistances;
        }
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (this.types[0].getResistances().contains((Object)type) && this.types[1].getResistances().contains((Object)type)) {
                quadResistances.add(type);
            }
            ++n2;
        }
        return quadResistances;
    }

    public List<Type> getImmunities() {
        ArrayList<Type> immunities = new ArrayList<Type>();
        Type[] typeArray = this.types;
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            for (Type immunity : type.getImmunities()) {
                if (immunities.contains((Object)immunity)) continue;
                immunities.add(immunity);
            }
            ++n2;
        }
        return immunities;
    }

    public DamageTier getDamageTier(Type type) {
        if (this.get4xWeaknesses().contains((Object)type)) {
            return DamageTier.QUADRUPLE_DAMAGE;
        }
        if (this.get2xWeaknesses().contains((Object)type)) {
            return DamageTier.DOUBLE_DAMAGE;
        }
        if (this.get2xResistances().contains((Object)type)) {
            return DamageTier.HALF_DAMAGE;
        }
        if (this.get4xResistances().contains((Object)type)) {
            return DamageTier.QUARTER_DAMAGE;
        }
        if (this.getImmunities().contains((Object)type)) {
            return DamageTier.NO_DAMAGE;
        }
        return DamageTier.NORMAL_DAMAGE;
    }

    public static Pokemon get(int number) {
        Random rand = new Random();
        List<Pokemon> forms = pokemon.get(number);
        return forms.get(rand.nextInt(forms.size()));
    }

    public static List<Pokemon> getAll() {
        ArrayList<Pokemon> pokemonList = new ArrayList<Pokemon>();
        for (List<Pokemon> formsList : pokemon.values()) {
            for (Pokemon form : formsList) {
                pokemonList.add(form);
            }
        }
        return pokemonList;
    }

    public static int getHighestGeneration() {
        int highestGeneration = 0;
        for (Pokemon pokemon : Pokemon.getAll()) {
            if (pokemon.getGeneration() <= highestGeneration) continue;
            highestGeneration = pokemon.getGeneration();
        }
        return highestGeneration;
    }

    private static Map<Integer, List<Pokemon>> readPokemonList() {
        HashMap<Integer, List<Pokemon>> pokemonMap = new HashMap<Integer, List<Pokemon>>();
        BufferedReader inputStream = new BufferedReader(new InputStreamReader(Pokemon.class.getClassLoader().getResourceAsStream(POKEMON_LIST_PATH)));
        String line = null;
        int lineNum = 0;
        try {
            inputStream.readLine();
            ++lineNum;
            line = inputStream.readLine();
            while (line != null) {
                Pokemon newPokemon = new Pokemon(line);
                if (pokemonMap.get(newPokemon.getNumber()) == null) {
                    pokemonMap.put(newPokemon.getNumber(), new ArrayList());
                }
                ((List)pokemonMap.get(newPokemon.getNumber())).add(newPokemon);
                line = inputStream.readLine();
                ++lineNum;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Error on line " + lineNum);
            System.out.println(line);
            e.printStackTrace();
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pokemonMap;
    }

    public String toString() {
        return this.name;
    }
}

