/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.IOUtils;

public class Util {
    public static final String[] MUSIC_FILE_EXTENTIONS = new String[]{".mp3", ".m4a"};
    public static final String[] PLAYLIST_FILE_EXTENTIONS = new String[]{".m3u", ".m3u8"};
    public static final String[] GENRE_ARRAY = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "BritPop", "Negerpunk", "Polsk Punk", "Beat", "Christian Gangsta Rap", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "J-Pop", "Synthpop"};

    public static byte[] getImage(String imagePath) {
        InputStream is = Util.class.getClassLoader().getResourceAsStream(imagePath);
        byte[] byteArray = null;
        try {
            byteArray = IOUtils.toByteArray(is);
        }
        catch (IOException e) {
            System.out.println("Error: problem reading folder image");
            e.printStackTrace();
            System.exit(1);
        }
        return byteArray;
    }

    public static String parseGenre(String genreString) {
        String newGenreString;
        try {
            int genreNum = Integer.parseInt(genreString.replace("(", "").replace(")", ""));
            newGenreString = GENRE_ARRAY[genreNum];
        }
        catch (NumberFormatException e) {
            return genreString;
        }
        return newGenreString;
    }

    public static String getFileExtension(File file) {
        return Util.getFileExtension(file.getName());
    }

    public static String getFileExtension(String path) {
        int lastIndexOf = path.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return path.substring(lastIndexOf);
    }

    public static <T> void shuffleList(List<T> list) {
        Random random = new Random();
        int n = list.size();
        int i = n - 1;
        while (i >= 1) {
            int j = random.nextInt(i + 1);
            T temp = list.get(j);
            list.set(j, list.get(i));
            list.set(i, temp);
            --i;
        }
    }
}

