/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.windows;

import java.io.File;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.DirectoryChooser;

public class LibraryLocationDialog
extends Dialog<String> {
    private final GridPane grid;
    private final Label label;
    private final Button browseButton;
    private final TextField textField;

    public LibraryLocationDialog(String rootFolderPath) {
        DialogPane dialogPane = this.getDialogPane();
        this.textField = new TextField();
        this.textField.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)this.textField, (Boolean)true);
        this.label = new Label();
        this.label.setPrefWidth(-1.0);
        this.label.textProperty().bind((ObservableValue)dialogPane.contentTextProperty());
        this.browseButton = new Button("Browse...");
        this.browseButton.setOnAction(event -> {
            String libraryLocation = this.browseLibraryLocation(rootFolderPath);
            this.textField.setText(libraryLocation == null ? null : libraryLocation);
        });
        this.grid = new GridPane();
        this.grid.setHgap(10.0);
        this.grid.setPrefWidth(400.0);
        this.grid.setMaxWidth(Double.MAX_VALUE);
        this.grid.setAlignment(Pos.CENTER_LEFT);
        this.grid.add((Node)this.label, 0, 0);
        this.grid.add((Node)this.textField, 1, 0);
        this.grid.add((Node)this.browseButton, 2, 0);
        this.getDialogPane().setContent((Node)this.grid);
        this.setTitle("Music Library Location");
        dialogPane.setContentText("Directory:");
        dialogPane.setHeaderText("Choose the location of your music library");
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Platform.runLater(() -> this.browseButton.requestFocus());
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? this.textField.getText() : null;
        });
    }

    public String browseLibraryLocation(String rootFolderPath) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle("Choose music library folder");
        directoryChooser.setInitialDirectory(new File(rootFolderPath));
        File selectedDirectory = directoryChooser.showDialog(this.getOwner());
        if (selectedDirectory == null) {
            return null;
        }
        return selectedDirectory.getPath();
    }
}

