/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.tools;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import javafx.scene.image.Image;
import tech.octopusdragon.musicplayer.Album;
import tech.octopusdragon.musicplayer.AlbumCollection;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.RootDirectories;
import tech.octopusdragon.musicplayer.Song;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.util.Util;

public class Userdata {
    private static final String USERDATA_DIRECTORY = "userdata/music_player_userdata";
    private static final String ALBUM_COLLECTION_DIRECTORY = "userdata/Album Collections";
    private static final String ALBUM_COLLECTION_EXTENTION = ".alco";
    private static final int WAIT_INTERVAL = 500;
    private static final String MUSIC_LIBRARY_FILENAME = "music_library.ser";
    private static final String PROPERTIES_FILENAME = "userdata.ser";
    private static final String LAST_DIRECTORY_FILENAME = "last_directory.ser";
    private static RootDirectories musicLibrary = Userdata.loadMusicLibrary();
    private static Properties properties = Userdata.loadProperties();
    private static Directory lastDirectory = Userdata.loadLastDirectory();
    private static Map<Album, Image> coverArtCache = new HashMap<Album, Image>();
    private static boolean wait;

    static {
        if (musicLibrary != null) {
            new Thread(() -> {
                for (Album album : musicLibrary.getAlbums()) {
                    if (album.getCoverArtData() == null) continue;
                    coverArtCache.put(album, new Image((InputStream)new ByteArrayInputStream(album.getCoverArtData())));
                }
            }).start();
        }
    }

    private static RootDirectories loadMusicLibrary() {
        RootDirectories object;
        block2: {
            object = null;
            try {
                FileInputStream fileIn = new FileInputStream("userdata/music_player_userdata/music_library.ser");
                ObjectInputStream objectIn = new ObjectInputStream(fileIn);
                object = (RootDirectories)objectIn.readObject();
                objectIn.close();
            }
            catch (IOException | ClassNotFoundException e) {
                if (e instanceof FileNotFoundException) break block2;
                e.printStackTrace();
            }
        }
        return object;
    }

    private static Properties loadProperties() {
        Properties object;
        try {
            FileInputStream fileIn = new FileInputStream("userdata/music_player_userdata/userdata.ser");
            ObjectInputStream objectIn = new ObjectInputStream(fileIn);
            object = (Properties)objectIn.readObject();
            objectIn.close();
        }
        catch (IOException | ClassNotFoundException e) {
            if (!(e instanceof FileNotFoundException)) {
                e.printStackTrace();
            }
            object = new Properties();
        }
        return object;
    }

    private static Directory loadLastDirectory() {
        Directory object;
        block5: {
            object = null;
            try {
                FileInputStream fileIn = new FileInputStream("userdata/music_player_userdata/last_directory.ser");
                ObjectInputStream objectIn = new ObjectInputStream(fileIn);
                object = (Directory)objectIn.readObject();
                objectIn.close();
            }
            catch (IOException | ClassNotFoundException e) {
                if (e instanceof FileNotFoundException) break block5;
                e.printStackTrace();
            }
        }
        if (musicLibrary != null) {
            Directory[] allDirectories;
            Directory[] directoryArray = allDirectories = musicLibrary.getAllDirectories();
            int n = allDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                Directory directory = directoryArray[n2];
                if (directory.equals(object)) {
                    object = directory;
                    break;
                }
                ++n2;
            }
        }
        return object;
    }

    public static void saveMusicLibrary(boolean bypassWait) {
        if (wait && !bypassWait) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                File folder = new File(Userdata.USERDATA_DIRECTORY);
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                try {
                    FileOutputStream fileOut = new FileOutputStream("userdata/music_player_userdata/music_library.ser");
                    ObjectOutputStream objectOut = new ObjectOutputStream(fileOut);
                    objectOut.writeObject(musicLibrary);
                    objectOut.close();
                }
                catch (IOException e) {
                    System.out.println("Error trying to save userdata");
                    e.printStackTrace();
                }
            }
        }.start();
        wait = true;
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                wait = false;
            }
        }, 500L);
    }

    public static void saveProperties(boolean bypassWait) {
        if (wait && !bypassWait) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                File folder = new File(Userdata.USERDATA_DIRECTORY);
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                try {
                    FileOutputStream fileOut = new FileOutputStream("userdata/music_player_userdata/userdata.ser");
                    ObjectOutputStream objectOut = new ObjectOutputStream(fileOut);
                    objectOut.writeObject(properties);
                    objectOut.close();
                }
                catch (IOException e) {
                    System.out.println("Error trying to save userdata");
                    e.printStackTrace();
                }
            }
        }.start();
        wait = true;
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                wait = false;
            }
        }, 500L);
    }

    public static void saveLastDirectory(boolean bypassWait) {
        if (wait && !bypassWait) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                File folder = new File(Userdata.USERDATA_DIRECTORY);
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                try {
                    FileOutputStream fileOut = new FileOutputStream("userdata/music_player_userdata/last_directory.ser");
                    ObjectOutputStream objectOut = new ObjectOutputStream(fileOut);
                    objectOut.writeObject(lastDirectory);
                    objectOut.close();
                }
                catch (IOException e) {
                    System.out.println("Error trying to save userdata");
                    e.printStackTrace();
                }
            }
        }.start();
        wait = true;
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                wait = false;
            }
        }, 500L);
    }

    public static List<AlbumCollection> loadAllAlbumCollections() {
        File[] files;
        ArrayList<AlbumCollection> albumCollectionList = new ArrayList<AlbumCollection>();
        File albumCollectionDirectory = new File(ALBUM_COLLECTION_DIRECTORY);
        if (!albumCollectionDirectory.exists()) {
            return albumCollectionList;
        }
        File[] fileArray = files = albumCollectionDirectory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (Util.getFileExtension(file).equals(ALBUM_COLLECTION_EXTENTION)) {
                AlbumCollection newAlbumCollection = Userdata.loadAlbumCollection(file);
                albumCollectionList.add(newAlbumCollection);
            }
            ++n2;
        }
        return albumCollectionList;
    }

    private static AlbumCollection loadAlbumCollection(File file) {
        String albumCollectionName = file.getName().replace(Util.getFileExtension(file), "");
        AlbumCollection albumCollection = new AlbumCollection(albumCollectionName, musicLibrary.getAlbumCollectionDirectory());
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            System.out.println("Problem reading album collection file");
            e.printStackTrace();
        }
        Scanner inputFile = new Scanner((InputStream)is, "UTF-8");
        while (inputFile.hasNext()) {
            String line = inputFile.nextLine();
            if (line.startsWith("#")) continue;
            if (line.startsWith("file:///")) {
                line = line.substring(8);
            }
            try {
                line = URLDecoder.decode(line, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("ERROR URL decoding line: " + line);
                e.printStackTrace();
            }
            Song song = new Song(line);
            for (Directory directory : musicLibrary.getAlbumDirectory().getDirectories()) {
                Album album = (Album)directory;
                if (!album.getSongs().contains(song)) continue;
                Album albumCopy = new Album(album);
                albumCopy.setParent(albumCollection);
                if (albumCollection.getDirectories().contains(album)) continue;
                albumCollection.addDirectory(albumCopy);
            }
        }
        inputFile.close();
        return albumCollection;
    }

    public static void saveAllAlbumCollections() {
        File folder = new File(ALBUM_COLLECTION_DIRECTORY);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        for (Directory albumCollection : musicLibrary.getAlbumCollectionDirectory().getDirectories()) {
            Userdata.saveAlbumCollection((AlbumCollection)albumCollection);
        }
    }

    public static void saveAlbumCollection(AlbumCollection albumCollection) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream("userdata/Album Collections/" + albumCollection.getName() + ALBUM_COLLECTION_EXTENTION);
        }
        catch (FileNotFoundException e) {
            System.out.println("Problem opening album collection file");
            e.printStackTrace();
        }
        OutputStreamWriter osWriter = null;
        try {
            osWriter = new OutputStreamWriter((OutputStream)os, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Problem opening album collection file for UTF-8");
            e.printStackTrace();
        }
        PrintWriter outputFile = new PrintWriter(osWriter);
        for (Directory album : albumCollection.getDirectories()) {
            outputFile.println(album.getSongs().get(0).getPath());
        }
        outputFile.close();
    }

    public static void deleteAlbumCollection(AlbumCollection albumCollection) {
        musicLibrary.getAlbumCollectionDirectory().getDirectories().remove(albumCollection);
        File albumCollectionFile = new File("userdata/Album Collections/" + albumCollection.getName() + ALBUM_COLLECTION_EXTENTION);
        albumCollectionFile.delete();
        Userdata.saveAllAlbumCollections();
    }

    public static void renameAlbumCollection(AlbumCollection albumCollection, String name) {
        String oldName = albumCollection.getName();
        String newName = name;
        File albumCollectionFile = new File("userdata/Album Collections/" + albumCollection.getName() + ALBUM_COLLECTION_EXTENTION);
        boolean succeeded = albumCollectionFile.renameTo(new File(albumCollectionFile.getPath().replace(oldName, newName)));
        if (!succeeded) {
            return;
        }
        albumCollection.setName(name);
        Userdata.saveAlbumCollection(albumCollection);
    }

    public static String readProperty(String key) {
        return properties.getProperty(key);
    }

    public static String readProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static void writeProperty(String key, String value) {
        properties.setProperty(key, value);
        Userdata.saveProperties(false);
    }

    public static void scanMusicLibrary(String directoryPath) {
        musicLibrary = new RootDirectories();
        musicLibrary.pullData(directoryPath);
        MusicPlayerApplication.setUpdateMessage("Loading album cover art");
        for (Album album : musicLibrary.getAlbums()) {
            if (album.getCoverArtData() == null) continue;
            coverArtCache.put(album, new Image((InputStream)new ByteArrayInputStream(album.getCoverArtData())));
        }
        MusicPlayerApplication.setUpdateMessage(null);
        Userdata.saveMusicLibrary(false);
    }

    public static RootDirectories getRootDirectories() {
        return musicLibrary;
    }

    public static void setLastDirectory(Directory dir) {
        lastDirectory = dir;
        Userdata.saveLastDirectory(false);
    }

    public static Directory getLastDirectory() {
        return lastDirectory;
    }

    public static Image getCoverArt(Album album) {
        return coverArtCache.get(album);
    }

    public static boolean containsCoverArt(Album album) {
        return coverArtCache.containsKey(album);
    }
}

