/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.tools;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.SimpleObjectProperty;

public class OnSetProperty<T>
extends SimpleObjectProperty<T> {
    List<MutateListener<T>> mutateListeners = new ArrayList<MutateListener<T>>();

    public OnSetProperty() {
        this(null);
    }

    public OnSetProperty(T defaultValue) {
        super(defaultValue);
    }

    public void set(T newValue) {
        Object oldValue = this.get();
        super.set(newValue);
        for (MutateListener<Object> mutateListener : this.mutateListeners) {
            if (mutateListener == null) continue;
            mutateListener.mutated(oldValue, newValue);
        }
    }

    public void addMutateListener(MutateListener<T> mutateListener) {
        this.mutateListeners.add(mutateListener);
    }

    public void removeMutateListener(MutateListener<T> mutateListener) {
        this.mutateListeners.remove(mutateListener);
    }

    public static interface MutateListener<T> {
        public void mutated(T var1, T var2);
    }
}

