/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.scenes;

import java.io.IOException;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.layout.VBox;
import tech.octopusdragon.musicplayer.Album;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.application.components.AlbumInfoBox;
import tech.octopusdragon.musicplayer.application.components.TrackList;
import tech.octopusdragon.musicplayer.application.tools.NavigatorView;

public class TrackView
extends VBox {
    @FXML
    private AlbumInfoBox albumInfoBox;
    @FXML
    private TrackList trackList;

    public TrackView() {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("TrackView.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setOnMouseClicked(event -> this.trackList.getSelectionModel().clearSelection());
    }

    public void newDirectory(Directory dir) {
        this.showHideAlbumInfoBox();
        this.trackList.newDirectory(dir);
    }

    public void showHideAlbumInfoBox() {
        if (MusicPlayerApplication.getNavigatorView() != NavigatorView.TRACK) {
            return;
        }
        Directory curDirectory = (Directory)MusicPlayerApplication.getMusicPlayer().getCurDirectory().get();
        if (!this.getChildren().contains((Object)this.albumInfoBox) && curDirectory.getClass() == Album.class) {
            this.getChildren().add(0, (Object)this.albumInfoBox);
        } else if (this.getChildren().contains((Object)this.albumInfoBox) && curDirectory.getClass() != Album.class) {
            this.getChildren().remove((Object)this.albumInfoBox);
        }
    }
}

