/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.scenes;

import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.stage.Stage;
import javafx.util.Callback;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.application.components.SidebarCell;
import tech.octopusdragon.musicplayer.application.tools.Userdata;

public class SidebarController {
    private static final double DEFAULT_WIDTH = 235.0;
    private static final double MIN_WIDTH = 75.0;
    private static final double MAX_WIDTH_PROPORTION = 0.5;
    private ObservableList<Directory> rootDirectories;
    @FXML
    private ListView<Directory> sidebar;

    @FXML
    private void initialize() {
        this.rootDirectories = MusicPlayerApplication.getRootDirectories();
        this.sidebar.setCellFactory((Callback)new Callback<ListView<Directory>, ListCell<Directory>>(){

            public ListCell<Directory> call(ListView<Directory> lv) {
                return new SidebarCell();
            }
        });
        this.sidebar.setMaxWidth(Double.parseDouble(Userdata.readProperty("sidebar-width", String.valueOf(235.0))));
        this.sidebar.widthProperty().addListener((observable, oldValue, newValue) -> Userdata.writeProperty("sidebar-width", String.valueOf(newValue)));
        this.sidebar.setMinWidth(75.0);
        this.sidebar.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> obs, Scene oldVAl, Scene newVal) {
                if (newVal == null) {
                    return;
                }
                Platform.runLater(() -> {
                    Scene scene = SidebarController.this.sidebar.getScene();
                    Stage stage = (Stage)scene.getWindow();
                    SidebarController.this.sidebar.maxWidthProperty().bind((ObservableValue)scene.widthProperty().multiply(0.5));
                    double decorationWidth = stage.getWidth() - scene.getWidth();
                    double minWidth = stage.getMinWidth();
                    stage.minWidthProperty().bind((ObservableValue)Bindings.max((ObservableNumberValue)SidebarController.this.sidebar.widthProperty().multiply(2).add(decorationWidth), (double)minWidth));
                });
                SidebarController.this.sidebar.sceneProperty().removeListener((ChangeListener)this);
            }
        });
        this.sidebar.setOnMouseClicked(event -> {
            Directory newVal = (Directory)this.sidebar.getSelectionModel().getSelectedItem();
            if (newVal == null || newVal == MusicPlayerApplication.getMusicPlayer().getCurDirectory().get()) {
                return;
            }
            MusicPlayerApplication.newRootDirectory((Directory)this.sidebar.getSelectionModel().getSelectedItem());
        });
        MusicPlayerApplication.currentRootDirectoryProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal == null || newVal == this.sidebar.getSelectionModel().getSelectedItem()) {
                return;
            }
            this.sidebar.getSelectionModel().select(newVal);
        });
        this.sidebar.getSelectionModel().select((Object)MusicPlayerApplication.getCurrentRootDirectory());
        this.rootDirectories.addListener(c -> this.sidebar.setItems(this.rootDirectories));
        this.sidebar.setItems(this.rootDirectories);
    }
}

