/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.scenes;

import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ToggleGroup;
import javafx.util.Duration;
import tech.octopusdragon.musicplayer.MusicPlayer;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.application.tools.Balance;
import tech.octopusdragon.musicplayer.application.tools.Rate;
import tech.octopusdragon.musicplayer.application.tools.Theme;
import tech.octopusdragon.musicplayer.application.tools.UISize;
import tech.octopusdragon.musicplayer.application.tools.View;

public class MenuBarController {
    private static final double TIME_INTERVAL = 15.0;
    private static final double VOLUME_INTERVAL = 0.1;
    private MusicPlayer player;
    @FXML
    private CheckMenuItem shuffleMenuItem;
    @FXML
    private CheckMenuItem repeatMenuItem;
    @FXML
    private CheckMenuItem repeatSingleMenuItem;
    @FXML
    private CheckMenuItem muteMenuItem;
    @FXML
    private RadioMenuItem rateQuarterMenuItem;
    @FXML
    private RadioMenuItem rateHalfMenuItem;
    @FXML
    private RadioMenuItem rateNormalMenuItem;
    @FXML
    private RadioMenuItem rateDoubleMenuItem;
    @FXML
    private RadioMenuItem rateQuadrupleMenuItem;
    @FXML
    private RadioMenuItem balanceFullLeftMenuItem;
    @FXML
    private RadioMenuItem balanceHalfLeftMenuItem;
    @FXML
    private RadioMenuItem balanceCenterMenuItem;
    @FXML
    private RadioMenuItem balanceHalfRightMenuItem;
    @FXML
    private RadioMenuItem balanceFullRightMenuItem;
    @FXML
    private RadioMenuItem explorerMenuItem;
    @FXML
    private RadioMenuItem currentlyPlayingMenuItem;
    @FXML
    private Menu uiSizeMenu;
    @FXML
    private Menu themeMenu;

    @FXML
    private void initialize() {
        this.player = MusicPlayerApplication.getMusicPlayer();
        this.shuffleMenuItem.selectedProperty().bindBidirectional((Property)this.player.shuffleProperty());
        this.repeatMenuItem.selectedProperty().bindBidirectional((Property)this.player.repeatProperty());
        this.repeatSingleMenuItem.selectedProperty().bindBidirectional((Property)this.player.repeatSingleProperty());
        this.muteMenuItem.selectedProperty().bindBidirectional((Property)this.player.muteProperty());
        switch (MusicPlayerApplication.getRateEnum()) {
            case QUARTER: {
                this.rateQuarterMenuItem.setSelected(true);
                break;
            }
            case HALF: {
                this.rateHalfMenuItem.setSelected(true);
                break;
            }
            case NORMAL: {
                this.rateNormalMenuItem.setSelected(true);
                break;
            }
            case DOUBLE: {
                this.rateDoubleMenuItem.setSelected(true);
                break;
            }
            case QUADRUPLE: {
                this.rateQuadrupleMenuItem.setSelected(true);
            }
        }
        switch (MusicPlayerApplication.getBalanceEnum()) {
            case FULL_LEFT: {
                this.balanceFullLeftMenuItem.setSelected(true);
                break;
            }
            case HALF_LEFT: {
                this.balanceHalfLeftMenuItem.setSelected(true);
                break;
            }
            case CENTER: {
                this.balanceCenterMenuItem.setSelected(true);
                break;
            }
            case HALF_RIGHT: {
                this.balanceHalfRightMenuItem.setSelected(true);
                break;
            }
            case FULL_RIGHT: {
                this.balanceFullRightMenuItem.setSelected(true);
            }
        }
        ToggleGroup viewToggleGroup = new ToggleGroup();
        this.explorerMenuItem.setToggleGroup(viewToggleGroup);
        this.currentlyPlayingMenuItem.setToggleGroup(viewToggleGroup);
        switch (MusicPlayerApplication.getCurrentView()) {
            case EXPLORER: {
                this.explorerMenuItem.setSelected(true);
                break;
            }
            case CURRENTLY_PLAYING: {
                this.currentlyPlayingMenuItem.setSelected(true);
            }
        }
        ToggleGroup uiSizeGroup = new ToggleGroup();
        UISize[] uISizeArray = UISize.values();
        int n = uISizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            UISize uiSize = uISizeArray[n2];
            RadioMenuItem newUISizeMenuItem = new RadioMenuItem(uiSize.toString());
            newUISizeMenuItem.setToggleGroup(uiSizeGroup);
            if (MusicPlayerApplication.getCurUISize() == uiSize) {
                newUISizeMenuItem.setSelected(true);
            }
            newUISizeMenuItem.setOnAction(event -> this.setUISize((ActionEvent)event, uiSize));
            this.uiSizeMenu.getItems().add((Object)newUISizeMenuItem);
            ++n2;
        }
        ToggleGroup themeGroup = new ToggleGroup();
        Theme[] themeArray = Theme.values();
        int n3 = themeArray.length;
        n = 0;
        while (n < n3) {
            Theme theme = themeArray[n];
            RadioMenuItem newThemeMenuItem = new RadioMenuItem(theme.toString());
            newThemeMenuItem.setToggleGroup(themeGroup);
            if (MusicPlayerApplication.getCurTheme() == theme) {
                newThemeMenuItem.setSelected(true);
            }
            newThemeMenuItem.setOnAction(event -> this.setTheme((ActionEvent)event, theme));
            this.themeMenu.getItems().add((Object)newThemeMenuItem);
            ++n;
        }
    }

    @FXML
    private void exit(ActionEvent event) {
        Platform.exit();
    }

    @FXML
    private void selectRootFolder(ActionEvent event) {
        MusicPlayerApplication.selectRootFolder();
    }

    @FXML
    private void playPause(ActionEvent event) {
        this.player.togglePlay();
    }

    @FXML
    private void fastForward(ActionEvent event) {
        this.player.move(Duration.seconds((double)15.0).toMillis());
    }

    @FXML
    private void rewind(ActionEvent event) {
        this.player.move(-Duration.seconds((double)15.0).toMillis());
    }

    @FXML
    private void restart(ActionEvent event) {
        this.player.restartMedia();
    }

    @FXML
    private void stop(ActionEvent event) {
        this.player.stopMedia();
    }

    @FXML
    private void previous(ActionEvent event) {
        this.player.previous();
    }

    @FXML
    private void next(ActionEvent event) {
        this.player.next();
    }

    @FXML
    private void volumeUp(ActionEvent event) {
        this.player.changeVolume(Math.min(this.player.getVolume() + 0.1, 1.0));
    }

    @FXML
    private void volumeDown(ActionEvent event) {
        this.player.changeVolume(Math.max(this.player.getVolume() - 0.1, 0.0));
    }

    @FXML
    private void rateQuarter(ActionEvent event) {
        MusicPlayerApplication.setRateEnum(Rate.QUARTER);
    }

    @FXML
    private void rateHalf(ActionEvent event) {
        MusicPlayerApplication.setRateEnum(Rate.HALF);
    }

    @FXML
    private void rateNormal(ActionEvent event) {
        MusicPlayerApplication.setRateEnum(Rate.NORMAL);
    }

    @FXML
    private void rateDouble(ActionEvent event) {
        MusicPlayerApplication.setRateEnum(Rate.DOUBLE);
    }

    @FXML
    private void rateQuadruple(ActionEvent event) {
        MusicPlayerApplication.setRateEnum(Rate.QUADRUPLE);
    }

    @FXML
    private void balance100Left(ActionEvent event) {
        MusicPlayerApplication.setBalanceEnum(Balance.FULL_LEFT);
    }

    @FXML
    private void balance50Left(ActionEvent event) {
        MusicPlayerApplication.setBalanceEnum(Balance.HALF_LEFT);
    }

    @FXML
    private void balanceCenter(ActionEvent event) {
        MusicPlayerApplication.setBalanceEnum(Balance.CENTER);
    }

    @FXML
    private void balance50Right(ActionEvent event) {
        MusicPlayerApplication.setBalanceEnum(Balance.HALF_RIGHT);
    }

    @FXML
    private void balance100Right(ActionEvent event) {
        MusicPlayerApplication.setBalanceEnum(Balance.FULL_RIGHT);
    }

    @FXML
    private void switchToExplorerView(ActionEvent event) {
        MusicPlayerApplication.switchView(View.EXPLORER);
    }

    @FXML
    private void switchToCurrentlyPlayingView(ActionEvent event) {
        MusicPlayerApplication.switchView(View.CURRENTLY_PLAYING);
    }

    private void setTheme(ActionEvent event, Theme theme) {
        MusicPlayerApplication.setTheme(theme);
    }

    private void setUISize(ActionEvent event, UISize uiSize) {
        MusicPlayerApplication.setUISize(uiSize);
    }
}

