/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.scenes;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.DirectoryType;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.application.tools.Userdata;

public class HistoryBoxController {
    @FXML
    private Button backButton;
    @FXML
    private Button forwardButton;
    @FXML
    private ToolBar directoryBox;
    @FXML
    private TextField searchBar;

    @FXML
    private void initialize() {
        this.backButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (MusicPlayerApplication.getHistoryIndex() <= 0) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{MusicPlayerApplication.historyIndexProperty()}));
        this.forwardButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (MusicPlayerApplication.getHistoryIndex() == MusicPlayerApplication.getHistory().size() - 1) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{MusicPlayerApplication.historyIndexProperty()}));
        MusicPlayerApplication.historyIndexProperty().addListener(listener -> {
            if (MusicPlayerApplication.getHistoryIndex() < 0) {
                return;
            }
            if (MusicPlayerApplication.getHistoryIndex() < MusicPlayerApplication.getHistory().size()) {
                this.updateDirectoryBox((Directory)MusicPlayerApplication.getHistory().get(MusicPlayerApplication.getHistoryIndex()));
            }
        });
        this.searchBar.textProperty().addListener((obs, oldVal, newVal) -> {
            if (MusicPlayerApplication.getCurrentRootDirectory() == Userdata.getRootDirectories().getSongDirectory() || newVal.isEmpty()) {
                MusicPlayerApplication.search(newVal);
            } else {
                MusicPlayerApplication.searchAndGo(newVal);
            }
        });
        MusicPlayerApplication.currentRootDirectoryProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal == Userdata.getRootDirectories().getSongDirectory()) {
                return;
            }
            this.searchBar.setText("");
        });
    }

    @FXML
    private void back(ActionEvent event) {
        MusicPlayerApplication.back();
    }

    @FXML
    private void forward(ActionEvent event) {
        MusicPlayerApplication.forward();
    }

    private void updateDirectoryBox(Directory newDirectory) {
        this.directoryBox.getItems().clear();
        Directory curDirectory = newDirectory;
        while (curDirectory != null) {
            Button curDirButton = new Button(curDirectory.getName());
            curDirButton.setOnAction((EventHandler)new ChangeButtonHandler(curDirectory));
            this.directoryBox.getItems().add(0, (Object)curDirButton);
            curDirectory = curDirectory.getParent();
        }
    }

    private class ChangeButtonHandler
    implements EventHandler<ActionEvent> {
        private Directory dir;

        public ChangeButtonHandler(Directory dir) {
            this.dir = dir;
        }

        public void handle(ActionEvent event) {
            if (this.dir.getType() == DirectoryType.ALBUM_COLLECTION) {
                MusicPlayerApplication.goForwardToDirectory(this.dir);
            } else if (this.dir.hasDirectories()) {
                MusicPlayerApplication.goForwardToDirectory(this.dir);
            } else {
                MusicPlayerApplication.goForwardToTracks(this.dir);
            }
        }
    }
}

