/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.scenes;

import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.application.components.DirectoryGrid;

public class DirectoryView
extends VBox {
    @FXML
    private TableView<Directory> header;
    @FXML
    private DirectoryGrid directoryGrid;

    public DirectoryView() {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("DirectoryView.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.layoutBoundsProperty().addListener((obs, oldVal, newVal) -> {
            StackPane tvHeader = (StackPane)this.header.getChildrenUnmodifiable().get(0);
            Platform.runLater(() -> {
                double tvHeaderHeight = tvHeader.getHeight() - 1.0;
                this.header.setMinHeight(tvHeaderHeight);
                this.header.setPrefHeight(tvHeaderHeight);
                this.header.setMaxHeight(tvHeaderHeight);
            });
        });
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Directory, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Directory, String> p) {
                return new ReadOnlyObjectWrapper((Object)((Directory)p.getValue()).getName());
            }
        });
        this.header.getColumns().add((Object)nameColumn);
        this.header.setOnSort(e -> {
            this.directoryGrid.setComparator(this.header.getComparator());
            this.directoryGrid.sort();
        });
    }

    public void newDirectory(Directory dir) {
        this.directoryGrid.newDirectory(dir);
    }
}

