/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.scenes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.NumberBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Reflection;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import tech.octopusdragon.musicplayer.Song;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.util.Resource;

public class CurrentlyPlayingView
extends StackPane {
    private static final double COVER_ART_SIZE = 0.6;
    @FXML
    private ImageView coverArt;

    public CurrentlyPlayingView() {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("CurrentlyPlayingView.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.coverArt.imageProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            Song curSong = (Song)MusicPlayerApplication.getMusicPlayer().getCurSong().get();
            if (curSong == null) {
                return new Image(Resource.NOW_PLAYING_IMAGE.getResourceAsStream());
            }
            byte[] imageArray = ((Song)MusicPlayerApplication.getMusicPlayer().getCurSong().get()).coverArtData();
            if (imageArray != null) {
                return new Image((InputStream)new ByteArrayInputStream(imageArray));
            }
            return new Image(Resource.NOW_PLAYING_IMAGE.getResourceAsStream());
        }, (Observable[])new Observable[]{MusicPlayerApplication.getMusicPlayer().getCurSong()}));
        this.coverArt.fitHeightProperty().bind((ObservableValue)this.heightProperty().multiply(0.6));
        this.coverArt.fitWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.6));
        this.coverArt.visibleProperty().bind((ObservableValue)this.heightProperty().greaterThan(0.0).and((ObservableBooleanValue)this.widthProperty().greaterThan(0.0)));
        NumberBinding sizeBinding = Bindings.min((ObservableNumberValue)this.coverArt.fitHeightProperty(), (ObservableNumberValue)this.coverArt.fitWidthProperty());
        DropShadow shadow = new DropShadow();
        shadow.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.6));
        shadow.radiusProperty().bind((ObservableValue)sizeBinding.divide(8));
        shadow.setOffsetX(0.0);
        shadow.offsetYProperty().bind((ObservableValue)sizeBinding.divide(21));
        shadow.setBlurType(BlurType.GAUSSIAN);
        shadow.setSpread(0.14);
        Reflection reflection = new Reflection();
        reflection.topOffsetProperty().bind((ObservableValue)sizeBinding.negate().divide(4));
        reflection.setFraction(0.45);
        reflection.setTopOpacity(0.45);
        reflection.setBottomOpacity(0.0);
        reflection.setInput((Effect)shadow);
        this.coverArt.setEffect((Effect)reflection);
    }
}

