/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.scenes;

import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import tech.octopusdragon.musicplayer.MusicPlayer;
import tech.octopusdragon.musicplayer.Song;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.application.components.ManualToggleButton;
import tech.octopusdragon.musicplayer.application.tools.TimeDenominatorMode;
import tech.octopusdragon.musicplayer.application.tools.Userdata;

public class ControlBoxController {
    public final int TIME_BEFORE_PREVIOUS = 2000;
    private MusicPlayer player;
    private TimeDenominatorMode timeDenominatorMode;
    @FXML
    private GridPane controlBox;
    @FXML
    private HBox controlBoxTop;
    @FXML
    private VBox controlBoxLeft;
    @FXML
    private HBox controlBoxCenter;
    @FXML
    private HBox controlBoxRight;
    @FXML
    private Label curTimeLabel;
    @FXML
    private Slider progressBar;
    @FXML
    private Label denominatorLabel;
    @FXML
    private Label titleLabel;
    @FXML
    private Label artistLabel;
    @FXML
    private Label albumLabel;
    @FXML
    private ManualToggleButton shuffleButton;
    @FXML
    private ManualToggleButton repeatButton;
    @FXML
    private Button stopButton;
    @FXML
    private Button previousButton;
    @FXML
    private Button playButton;
    @FXML
    private Button nextButton;
    @FXML
    private Button muteButton;
    @FXML
    private Slider volumeSlider;
    @FXML
    private Label loadingSongLabel;
    @FXML
    private Button reloadButton;
    @FXML
    private Button folderButton;

    @FXML
    private void initialize() {
        this.player = MusicPlayerApplication.getMusicPlayer();
        this.timeDenominatorMode = TimeDenominatorMode.valueOf(Userdata.readProperty("time-denominator-mode", TimeDenominatorMode.DURATION.name()));
        this.volumeSlider.valueProperty().bindBidirectional((Property)this.player.volumeProperty());
        this.stopButton.disableProperty().bind((ObservableValue)this.player.loadedProperty().not());
        this.previousButton.disableProperty().bind((ObservableValue)this.player.loadedProperty().not());
        this.nextButton.disableProperty().bind((ObservableValue)this.player.loadedProperty().not());
        this.shuffleButton.selectedProperty().bind((ObservableValue)this.player.shuffleProperty());
        this.repeatButton.selectedProperty().bind((ObservableValue)this.player.repeatProperty().or((ObservableBooleanValue)this.player.repeatSingleProperty()));
        this.reloadButton.disableProperty().bind((ObservableValue)MusicPlayerApplication.reloadingProperty());
        this.playButton.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (this.player.isPlaying()) {
                return "\u23f8";
            }
            return "\u23f5";
        }, (Observable[])new Observable[]{this.player.playingProperty()}));
        this.muteButton.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (this.player.isMuted()) {
                return "\ud83d\udd07";
            }
            return "\ud83d\udd0a";
        }, (Observable[])new Observable[]{this.player.muteProperty()}));
        this.repeatButton.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (this.player.isOnRepeat()) {
                return "\ud83d\udd01";
            }
            if (this.player.isOnRepeatSingle()) {
                return "\ud83d\udd02";
            }
            return "\ud83d\udd01";
        }, (Observable[])new Observable[]{this.player.repeatProperty(), this.player.repeatSingleProperty()}));
        this.player.playerProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ControlBoxController.this.titleLabel.setText(null);
                        ControlBoxController.this.artistLabel.setText(null);
                        ControlBoxController.this.albumLabel.setText(null);
                        ControlBoxController.this.progressBar.setValue(0.0);
                        ControlBoxController.this.curTimeLabel.setVisible(false);
                        ControlBoxController.this.curTimeLabel.setText("00:00");
                        ControlBoxController.this.denominatorLabel.setVisible(false);
                        ControlBoxController.this.denominatorLabel.setText("00:00");
                    }
                });
            } else {
                newValue.setOnReady(new Runnable(){

                    @Override
                    public void run() {
                        ControlBoxController.this.displayInfo();
                        ControlBoxController.this.updateTime();
                        ControlBoxController.this.updateProgress();
                    }
                });
                newValue.currentTimeProperty().addListener((timeObservable, timeOldValue, timeNewValue) -> {
                    if (newValue.getStatus() == MediaPlayer.Status.PAUSED) {
                        return;
                    }
                    this.updateTime();
                    this.updateProgress();
                });
            }
        });
        this.player.loadedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ControlBoxController.this.titleLabel.setText(null);
                        ControlBoxController.this.artistLabel.setText(null);
                        ControlBoxController.this.albumLabel.setText(null);
                        ControlBoxController.this.progressBar.setValue(0.0);
                        ControlBoxController.this.curTimeLabel.setVisible(false);
                        ControlBoxController.this.curTimeLabel.setText("00:00");
                        ControlBoxController.this.denominatorLabel.setVisible(false);
                        ControlBoxController.this.denominatorLabel.setText("00:00");
                    }
                });
            }
        });
        MusicPlayerApplication.updateMessageProperty().addListener((obs, oldVal, newVal) -> Platform.runLater(() -> this.loadingSongLabel.setText(MusicPlayerApplication.updateMessageProperty().getValue())));
        this.curTimeLabel.setVisible(false);
        this.denominatorLabel.setVisible(false);
    }

    @FXML
    private void seekPressed(MouseEvent event) {
        if (!this.player.isLoaded()) {
            return;
        }
        if (this.player.isPlaying()) {
            this.player.getPlayer().pause();
        }
        this.player.seek(((Slider)event.getSource()).getValue() * this.player.getMedia().getDuration().toMillis());
        this.updateTime();
    }

    @FXML
    private void seekDragged(MouseEvent event) {
        if (!this.player.isLoaded()) {
            return;
        }
        this.player.seek(((Slider)event.getSource()).getValue() * this.player.getMedia().getDuration().toMillis());
        this.updateTime();
    }

    @FXML
    private void seekReleased(MouseEvent event) {
        if (!this.player.isLoaded()) {
            return;
        }
        if (((Slider)event.getSource()).getValue() == 1.0) {
            this.player.getPlayer().seek(this.player.getMedia().getDuration().add(Duration.millis((double)1.0).negate()));
        }
        if (this.player.isPlaying()) {
            this.player.getPlayer().play();
        }
    }

    @FXML
    private void toggleShuffle(ActionEvent event) {
        this.player.toggleShuffle();
    }

    @FXML
    private void rotateRepeat(ActionEvent event) {
        this.player.rotateRepeat();
    }

    @FXML
    private void stop(ActionEvent event) {
        this.player.stopMedia();
    }

    @FXML
    private void previous(ActionEvent event) {
        if (this.player.getPlayer().getCurrentTime().toMillis() < 2000.0) {
            this.player.previous();
        } else {
            this.player.restartMedia();
        }
    }

    @FXML
    private void playPause(ActionEvent event) {
        this.player.togglePlay();
    }

    @FXML
    private void next(ActionEvent event) {
        this.player.next();
    }

    @FXML
    private void toggleMute(ActionEvent event) {
        this.player.toggleMute();
    }

    @FXML
    private void reload(ActionEvent event) {
        MusicPlayerApplication.reload();
    }

    @FXML
    private void selectRootFolder(ActionEvent event) {
        MusicPlayerApplication.selectRootFolder();
    }

    @FXML
    private void toggleTimeDenominatorMode() {
        if (this.timeDenominatorMode == TimeDenominatorMode.DURATION) {
            this.timeDenominatorMode = TimeDenominatorMode.TIME_LEFT;
            this.updateTime();
        } else {
            this.timeDenominatorMode = TimeDenominatorMode.DURATION;
            this.displayInfo();
        }
        Userdata.writeProperty("time-denominator-mode", this.timeDenominatorMode.name());
    }

    private void displayInfo() {
        this.titleLabel.setText(((Song)this.player.getCurSong().getValue()).getTitle());
        this.artistLabel.setText(((Song)this.player.getCurSong().getValue()).getArtist());
        this.albumLabel.setText(((Song)this.player.getCurSong().getValue()).getAlbumStr());
        if (this.timeDenominatorMode == TimeDenominatorMode.DURATION) {
            double durationMins = this.player.getMedia().getDuration().toMinutes();
            double durationSecs = this.player.getMedia().getDuration().toSeconds() % 60.0;
            this.denominatorLabel.setText(String.format("%02d:%02d", (int)durationMins, (int)durationSecs));
        }
        this.updateTime();
    }

    private void updateTime() {
        double curTimeMins = this.player.getPlayer().getCurrentTime().toMinutes();
        double curTimeSecs = this.player.getPlayer().getCurrentTime().toSeconds() % 60.0;
        this.curTimeLabel.setText(String.format("%02d:%02d", (int)curTimeMins, (int)curTimeSecs));
        if (this.timeDenominatorMode == TimeDenominatorMode.TIME_LEFT) {
            double timeLeftMins = this.player.getMedia().getDuration().toMinutes() - this.player.getPlayer().getCurrentTime().toMinutes();
            double timeLeftSecs = (this.player.getMedia().getDuration().toSeconds() - this.player.getPlayer().getCurrentTime().toSeconds()) % 60.0;
            this.denominatorLabel.setText(String.format("-%02d:%02d", (int)timeLeftMins, (int)timeLeftSecs));
        }
        this.curTimeLabel.setVisible(true);
        this.denominatorLabel.setVisible(true);
    }

    private void updateProgress() {
        double curTimeMillis = this.player.getPlayer().getCurrentTime().toMillis();
        double durationMillis = this.player.getMedia().getDuration().toMillis();
        this.progressBar.setValue(curTimeMillis / durationMillis);
    }
}

