/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.components;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import tech.octopusdragon.musicplayer.Song;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.application.components.TrackRow;

public class TrackRowContextMenu
extends ContextMenu {
    public TrackRowContextMenu(TrackRow trackRow) {
        MenuItem playMenuItem = new MenuItem("Play");
        playMenuItem.setOnAction(event -> {
            if (trackRow.getTableView().getSelectionModel().getSelectedItems().size() == 1) {
                MusicPlayerApplication.getMusicPlayer().newMediaReload((Song)trackRow.getItem());
            } else {
                MusicPlayerApplication.getMusicPlayer().newMediaReload();
            }
            MusicPlayerApplication.getMusicPlayer().playMedia();
        });
        this.getItems().add((Object)playMenuItem);
        MenuItem openFileLocationMenuItem = new MenuItem("Open File Location");
        openFileLocationMenuItem.setOnAction(event -> {
            File songDir = new File(((Song)trackRow.getItem()).getPath()).getParentFile();
            try {
                Desktop.getDesktop().open(songDir);
            }
            catch (IOException e) {
                System.out.println("Error opening song file location");
                e.printStackTrace();
            }
        });
        this.getItems().add((Object)openFileLocationMenuItem);
    }
}

