/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.components;

import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableRow;
import javafx.scene.input.MouseEvent;
import tech.octopusdragon.musicplayer.Song;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.application.components.TrackList;
import tech.octopusdragon.musicplayer.application.components.TrackRowContextMenu;

public class TrackRow
extends TableRow<Song> {
    private ContextMenu contextMenu;

    public TrackRow() {
        this.getStyleClass().add((Object)"song-row");
        this.contextMenu = new TrackRowContextMenu(this);
        this.setOnMouseClicked(event -> this.getTableView().getSelectionModel().clearSelection());
    }

    protected void updateItem(Song item, boolean empty) {
        if (item == this.getItem()) {
            return;
        }
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setContextMenu(null);
            this.setOnMouseClicked(event -> this.getTableView().getSelectionModel().clearSelection());
        } else {
            this.setContextMenu(this.contextMenu);
            this.setOnMouseClicked(new ClickEventHandler());
        }
    }

    private class ClickEventHandler
    implements EventHandler<MouseEvent> {
        private ClickEventHandler() {
        }

        public void handle(MouseEvent event) {
            TrackList trackNavigator = (TrackList)((TrackRow)((Object)event.getSource())).getTableView();
            if (event.getClickCount() == 2) {
                MusicPlayerApplication.getMusicPlayer().newMediaReload(trackNavigator.songs.indexOf(trackNavigator.getSelectionModel().getSelectedItem()));
                MusicPlayerApplication.getMusicPlayer().playMedia();
                trackNavigator.getSelectionModel().clearSelection();
            }
            event.consume();
        }
    }
}

