/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.Song;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.application.components.TrackColumn;
import tech.octopusdragon.musicplayer.application.components.TrackRow;
import tech.octopusdragon.musicplayer.application.tools.Userdata;

public class TrackList
extends TableView<Song> {
    private Directory directory;
    SortedList<Song> songs;
    private List<TrackColumn<?>> tableColumns;
    private TrackColumn<Integer> discColumn;
    private TrackColumn<Integer> trackColumn;
    private TrackColumn<String> titleColumn;
    private TrackColumn<String> albumColumn;
    private TrackColumn<String> artistColumn;
    private TrackColumn<String> albumArtistColumn;
    private TrackColumn<String> genreColumn;
    private TrackColumn<Integer> yearColumn;
    private TrackColumn<String> durationColumn;
    private TrackColumn<String> filePathColumn;
    private TrackColumn<String> filenameColumn;

    public TrackList() {
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setId("track-list");
        this.setTableMenuButtonVisible(true);
        this.directory = null;
        this.songs = MusicPlayerApplication.getMusicPlayer().getSortedDirSongs();
        this.setRowFactory((Callback)new Callback<TableView<Song>, TableRow<Song>>(){

            public TableRow<Song> call(TableView<Song> p) {
                return new TrackRow();
            }
        });
        this.tableColumns = new ArrayList();
        this.discColumn = new TrackColumn("Disc #");
        this.discColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Song, Integer>, ObservableValue<Integer>>(){

            public ObservableValue<Integer> call(TableColumn.CellDataFeatures<Song, Integer> p) {
                return new ReadOnlyObjectWrapper((Object)((Song)p.getValue()).getDisc());
            }
        });
        this.tableColumns.add(this.discColumn);
        this.trackColumn = new TrackColumn("Track #");
        this.trackColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Song, Integer>, ObservableValue<Integer>>(){

            public ObservableValue<Integer> call(TableColumn.CellDataFeatures<Song, Integer> p) {
                return new ReadOnlyObjectWrapper((Object)((Song)p.getValue()).getTrack());
            }
        });
        this.tableColumns.add(this.trackColumn);
        this.titleColumn = new TrackColumn("Title");
        this.titleColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Song, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Song, String> p) {
                return new ReadOnlyObjectWrapper((Object)((Song)p.getValue()).getTitle());
            }
        });
        this.tableColumns.add(this.titleColumn);
        this.albumColumn = new TrackColumn("Album");
        this.albumColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Song, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Song, String> p) {
                return new ReadOnlyObjectWrapper((Object)((Song)p.getValue()).getAlbumStr());
            }
        });
        this.tableColumns.add(this.albumColumn);
        this.artistColumn = new TrackColumn("Artist");
        this.artistColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Song, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Song, String> p) {
                return new ReadOnlyObjectWrapper((Object)((Song)p.getValue()).getArtist());
            }
        });
        this.tableColumns.add(this.artistColumn);
        this.albumArtistColumn = new TrackColumn("Album Artist");
        this.albumArtistColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Song, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Song, String> p) {
                return new ReadOnlyObjectWrapper((Object)((Song)p.getValue()).getAlbumArtist());
            }
        });
        this.tableColumns.add(this.albumArtistColumn);
        this.genreColumn = new TrackColumn("Genre");
        this.genreColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Song, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Song, String> p) {
                return new ReadOnlyObjectWrapper((Object)((Song)p.getValue()).getGenre());
            }
        });
        this.tableColumns.add(this.genreColumn);
        this.yearColumn = new TrackColumn("Year");
        this.yearColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Song, Integer>, ObservableValue<Integer>>(){

            public ObservableValue<Integer> call(TableColumn.CellDataFeatures<Song, Integer> p) {
                return new ReadOnlyObjectWrapper((Object)((Song)p.getValue()).getYear());
            }
        });
        this.tableColumns.add(this.yearColumn);
        this.durationColumn = new TrackColumn("Duration");
        this.durationColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Song, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Song, String> p) {
                return new ReadOnlyObjectWrapper((Object)((Song)p.getValue()).getDuration());
            }
        });
        this.tableColumns.add(this.durationColumn);
        this.filenameColumn = new TrackColumn("Filename");
        this.filenameColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Song, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Song, String> p) {
                return new ReadOnlyObjectWrapper((Object)((Song)p.getValue()).getFilename());
            }
        });
        this.tableColumns.add(this.filenameColumn);
        this.filePathColumn = new TrackColumn("File Path");
        this.filePathColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Song, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Song, String> p) {
                return new ReadOnlyObjectWrapper((Object)((Song)p.getValue()).getPath());
            }
        });
        this.tableColumns.add(this.filePathColumn);
        this.getColumns().addAll(this.tableColumns);
        this.setItems((ObservableList)this.songs);
        this.songs.comparatorProperty().bind((ObservableValue)this.comparatorProperty());
        this.setOnMouseClicked(event -> this.getSelectionModel().clearSelection());
        MusicPlayerApplication.getMusicPlayer().setSelectedSongs((ObservableList<Song>)this.getSelectionModel().getSelectedItems());
        Platform.runLater(() -> {
            for (TrackColumn<?> songColumn : this.tableColumns) {
                songColumn.widthProperty().addListener((obs, oldVal, newVal) -> Userdata.writeProperty(TrackList.propertyKeyString(this.directory, songColumn, "Width"), String.valueOf(songColumn.getWidth())));
                songColumn.visibleProperty().addListener((obs, oldVal, newVal) -> Userdata.writeProperty(TrackList.propertyKeyString(this.directory, songColumn, "Visible"), String.valueOf(newVal)));
                this.getColumns().addListener(c -> Userdata.writeProperty(TrackList.propertyKeyString(this.directory, songColumn, "Index"), String.valueOf(this.getColumns().indexOf((Object)songColumn))));
            }
        });
    }

    public void newDirectory(Directory directory) {
        Directory oldDirectory = this.directory;
        Directory newDirectory = directory;
        if (oldDirectory == null) {
            this.directory = directory;
            this.readView();
        } else if (!oldDirectory.getClass().equals(newDirectory.getClass())) {
            this.directory = directory;
            this.readView();
        }
    }

    private void readView() {
        TrackColumn[] reorderedColumns = new TrackColumn[this.tableColumns.size()];
        for (TrackColumn<?> songColumn : this.tableColumns) {
            String visibleValue;
            String widthValue = Userdata.readProperty(TrackList.propertyKeyString(this.directory, songColumn, "Width"));
            if (widthValue != null) {
                songColumn.setPrefWidth(Double.parseDouble(widthValue));
            }
            if ((visibleValue = Userdata.readProperty(TrackList.propertyKeyString(this.directory, songColumn, "Visible"))) != null) {
                songColumn.setVisible(Boolean.parseBoolean(visibleValue));
            } else {
                this.setDefaultVisibility();
            }
            String indexValue = Userdata.readProperty(TrackList.propertyKeyString(this.directory, songColumn, "Index"));
            if (indexValue == null) continue;
            reorderedColumns[Integer.parseInt((String)indexValue)] = songColumn;
        }
        List<TrackColumn> reorderedColumnsList = Arrays.asList(reorderedColumns);
        this.getColumns().sort(Comparator.comparing(item -> reorderedColumnsList.indexOf(item)));
    }

    private void setDefaultVisibility() {
        for (TrackColumn<?> songColumn : this.tableColumns) {
            songColumn.setVisible(false);
        }
        switch (this.directory.getType()) {
            case ALBUM: {
                this.trackColumn.setVisible(true);
                this.titleColumn.setVisible(true);
                this.artistColumn.setVisible(true);
                this.durationColumn.setVisible(true);
                break;
            }
            default: {
                this.titleColumn.setVisible(true);
                this.artistColumn.setVisible(true);
                this.albumColumn.setVisible(true);
                this.durationColumn.setVisible(true);
            }
        }
    }

    private static String propertyKeyString(Directory directory, TrackColumn<?> column, String attribute) {
        String directoryTypeStr = directory.getType().toString();
        String columnStr = column.getText();
        columnStr = columnStr.replaceAll("#", "");
        columnStr = columnStr.trim();
        columnStr = columnStr.replaceAll(" ", "-");
        String propertyKeyStr = String.format("%s-%s-%s", directoryTypeStr, columnStr, attribute);
        propertyKeyStr = propertyKeyStr.toLowerCase();
        return propertyKeyStr;
    }
}

