/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.components;

import javafx.application.Platform;
import javafx.css.PseudoClass;
import javafx.scene.control.TableCell;
import tech.octopusdragon.musicplayer.Song;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;

public class TrackCell<T>
extends TableCell<Song, T> {
    public TrackCell() {
        this.getStyleClass().add((Object)"song-cell");
        MusicPlayerApplication.getMusicPlayer().getCurSong().addListener((observable, oldValue, newValue) -> this.updatePlaying());
    }

    protected void updateItem(T item, boolean empty) {
        if (item == this.getItem()) {
            return;
        }
        super.updateItem(item, empty);
        if (empty || item == null) {
            super.setText(null);
            super.setGraphic(null);
        } else {
            super.setText(item.toString());
            super.setGraphic(null);
        }
        Platform.runLater(() -> this.updatePlaying());
    }

    private void updatePlaying() {
        Song curSong = (Song)MusicPlayerApplication.getMusicPlayer().getCurSong().get();
        if (curSong != null && this.getIndex() >= 0 && this.getIndex() < this.getTableView().getItems().size() && curSong.equals(this.getTableRow().getItem())) {
            this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"playing"), true);
        } else {
            this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"playing"), false);
        }
    }
}

