/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.components;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.FlowPane;
import tech.octopusdragon.musicplayer.Album;
import tech.octopusdragon.musicplayer.AlbumCollection;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.application.components.DirectoryGrid;
import tech.octopusdragon.musicplayer.application.components.DirectoryNode;
import tech.octopusdragon.musicplayer.application.tools.Userdata;

public class DirectoryNodeContextMenu
extends ContextMenu {
    private DirectoryNode dirNode;
    private Directory dir;

    public DirectoryNodeContextMenu(DirectoryNode node, DirectoryGrid grid) {
        this.dirNode = node;
        this.dir = node.getDirectory();
        MenuItem openMenuItem = new MenuItem("Open");
        openMenuItem.setOnAction(event -> MusicPlayerApplication.goForward(this.dir));
        this.getItems().add((Object)openMenuItem);
        MenuItem playMenuItem = new MenuItem("Play");
        playMenuItem.setOnAction(event -> {
            MusicPlayerApplication.getMusicPlayer().newDirectories(true, grid.getSelectionModel().getItems());
            MusicPlayerApplication.getMusicPlayer().newMediaReload();
            MusicPlayerApplication.getMusicPlayer().playMedia();
        });
        this.getItems().add((Object)playMenuItem);
        if (this.dir.getParent() != null && this.dir.getParent() instanceof AlbumCollection) {
            MenuItem moveToTopAlbumCollectionAlbumItem = new MenuItem("Move to Top");
            moveToTopAlbumCollectionAlbumItem.setOnAction(event -> this.moveToTopAlbumCollectionAlbum((Album)this.dir));
            this.getItems().add((Object)moveToTopAlbumCollectionAlbumItem);
        }
        if (this.dir.getParent() != null && this.dir.getParent() instanceof AlbumCollection) {
            MenuItem moveUpAlbumCollectionAlbumItem = new MenuItem("Move Up");
            moveUpAlbumCollectionAlbumItem.setOnAction(event -> this.moveUpAlbumCollectionAlbum((Album)this.dir));
            this.getItems().add((Object)moveUpAlbumCollectionAlbumItem);
        }
        if (this.dir.getParent() != null && this.dir.getParent() instanceof AlbumCollection) {
            MenuItem moveDownAlbumCollectionAlbumItem = new MenuItem("Move Down");
            moveDownAlbumCollectionAlbumItem.setOnAction(event -> this.moveDownAlbumCollectionAlbum((Album)this.dir));
            this.getItems().add((Object)moveDownAlbumCollectionAlbumItem);
        }
        if (this.dir.getParent() != null && this.dir.getParent() instanceof AlbumCollection) {
            MenuItem moveToBottomAlbumCollectionAlbumItem = new MenuItem("Move to Bottom");
            moveToBottomAlbumCollectionAlbumItem.setOnAction(event -> this.moveToBottomAlbumCollectionAlbum((Album)this.dir));
            this.getItems().add((Object)moveToBottomAlbumCollectionAlbumItem);
        }
        if (this.dir.getParent() != null && this.dir.getParent() instanceof AlbumCollection) {
            MenuItem deleteAlbumCollectionAlbumItem = new MenuItem("Delete");
            deleteAlbumCollectionAlbumItem.setOnAction(event -> this.deleteAlbumCollectionAlbum((Album)this.dir));
            this.getItems().add((Object)deleteAlbumCollectionAlbumItem);
        }
        if (this.dir.getClass() == AlbumCollection.class) {
            MenuItem renameAlbumCollectionItem = new MenuItem("Rename");
            renameAlbumCollectionItem.setOnAction(event -> this.renameAlbumCollection((AlbumCollection)this.dir));
            this.getItems().add((Object)renameAlbumCollectionItem);
        }
        if (this.dir.getClass() == AlbumCollection.class) {
            MenuItem deleteAlbumCollectionItem = new MenuItem("Delete");
            deleteAlbumCollectionItem.setOnAction(event -> this.deleteAlbumCollection((AlbumCollection)this.dir));
            this.getItems().add((Object)deleteAlbumCollectionItem);
        }
    }

    private void deleteAlbumCollectionAlbum(Album album) {
        AlbumCollection albumCollection = (AlbumCollection)album.getParent();
        albumCollection.getDirectories().remove(album);
        if (this.dirNode.getParent().getClass().equals(FlowPane.class)) {
            ((FlowPane)this.dirNode.getParent()).getChildren().remove((Object)this.dirNode);
        }
        Userdata.saveAlbumCollection(albumCollection);
    }

    private void renameAlbumCollection(AlbumCollection albumCollection) {
        TextInputDialog nameDialog = new TextInputDialog();
        nameDialog.setContentText("New Name");
        nameDialog.setHeaderText("What would you like to rename " + albumCollection.getName() + " to?");
        nameDialog.setTitle("Rename Album Collection");
        nameDialog.getEditor().setText(albumCollection.getName());
        Optional result = nameDialog.showAndWait();
        if (result.isPresent() && !((String)result.get()).trim().isEmpty()) {
            Userdata.renameAlbumCollection(albumCollection, (String)result.get());
            this.dirNode.setText((String)result.get());
        }
    }

    private void deleteAlbumCollection(AlbumCollection albumCollection) {
        Alert confirmAlert = new Alert(Alert.AlertType.CONFIRMATION);
        confirmAlert.getButtonTypes().clear();
        confirmAlert.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        confirmAlert.setHeaderText(String.format("Are you sure you want to delete %s from your library?", albumCollection.getName()));
        confirmAlert.setTitle("Confirmation");
        Optional result = confirmAlert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.YES) {
            Userdata.deleteAlbumCollection(albumCollection);
            if (this.dirNode.getParent().getClass().equals(FlowPane.class)) {
                ((FlowPane)this.dirNode.getParent()).getChildren().remove((Object)this.dirNode);
            }
        }
    }

    private void moveUpAlbumCollectionAlbum(Album album) {
        AlbumCollection albumCollection = (AlbumCollection)album.getParent();
        List<Directory> albumCollectionDirectories = albumCollection.getDirectories();
        int albumIndex = albumCollectionDirectories.indexOf(album);
        Collections.swap(albumCollectionDirectories, albumIndex, albumIndex - 1);
        if (this.dirNode.getParent().getClass().equals(FlowPane.class)) {
            FlowPane flowPane = (FlowPane)this.dirNode.getParent();
            flowPane.getChildren().remove((Object)this.dirNode);
            flowPane.getChildren().add(albumIndex - 1, (Object)this.dirNode);
        }
        Userdata.saveAlbumCollection(albumCollection);
    }

    private void moveDownAlbumCollectionAlbum(Album album) {
        AlbumCollection albumCollection = (AlbumCollection)album.getParent();
        List<Directory> albumCollectionDirectories = albumCollection.getDirectories();
        int albumIndex = albumCollectionDirectories.indexOf(album);
        Collections.swap(albumCollectionDirectories, albumIndex, albumIndex + 1);
        if (this.dirNode.getParent().getClass().equals(FlowPane.class)) {
            FlowPane flowPane = (FlowPane)this.dirNode.getParent();
            flowPane.getChildren().remove((Object)this.dirNode);
            flowPane.getChildren().add(albumIndex + 1, (Object)this.dirNode);
        }
        Userdata.saveAlbumCollection(albumCollection);
    }

    private void moveToTopAlbumCollectionAlbum(Album album) {
        AlbumCollection albumCollection = (AlbumCollection)album.getParent();
        List<Directory> albumCollectionDirectories = albumCollection.getDirectories();
        albumCollectionDirectories.remove(album);
        albumCollectionDirectories.add(0, album);
        if (this.dirNode.getParent().getClass().equals(FlowPane.class)) {
            FlowPane flowPane = (FlowPane)this.dirNode.getParent();
            flowPane.getChildren().remove((Object)this.dirNode);
            flowPane.getChildren().add(0, (Object)this.dirNode);
        }
        Userdata.saveAlbumCollection(albumCollection);
    }

    private void moveToBottomAlbumCollectionAlbum(Album album) {
        AlbumCollection albumCollection = (AlbumCollection)album.getParent();
        List<Directory> albumCollectionDirectories = albumCollection.getDirectories();
        albumCollectionDirectories.remove(album);
        albumCollectionDirectories.add(album);
        if (this.dirNode.getParent().getClass().equals(FlowPane.class)) {
            FlowPane flowPane = (FlowPane)this.dirNode.getParent();
            flowPane.getChildren().remove((Object)this.dirNode);
            flowPane.getChildren().add(flowPane.getChildren().size() - 1, (Object)this.dirNode);
        }
        Userdata.saveAlbumCollection(albumCollection);
    }
}

