/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.components;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import tech.octopusdragon.musicplayer.Album;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.application.components.DirectoryGrid;
import tech.octopusdragon.musicplayer.application.components.DirectoryNodeContextMenu;
import tech.octopusdragon.musicplayer.application.tools.Userdata;
import tech.octopusdragon.musicplayer.util.Resource;

public class DirectoryNode
extends GridPane {
    private Directory directory;
    private DirectoryGrid dirGrid;
    @FXML
    private ImageView imageView;
    @FXML
    private Rectangle imageMask;
    @FXML
    private StackPane imagePane;
    @FXML
    private Label label;
    private ContextMenu contextMenu;
    private static final Image directoryImage = new Image(Resource.DIRECTORY_IMAGE.getResourceAsStream());
    private static final Image folderImage = new Image(Resource.FOLDER_IMAGE.getResourceAsStream());
    private static final Image albumImage = new Image(Resource.ALBUM_IMAGE.getResourceAsStream());
    private static final Image artistImage = new Image(Resource.ARTIST_IMAGE.getResourceAsStream());
    private static final Image genreImage = new Image(Resource.GENRE_IMAGE.getResourceAsStream());
    private static final Image playlistImage = new Image(Resource.PLAYLIST_IMAGE.getResourceAsStream());
    private static final Image albumCollectionImage = new Image(Resource.ALBUM_COLLECTION_IMAGE.getResourceAsStream());

    public DirectoryNode(DirectoryGrid directoryGrid, Directory directory) {
        this(directoryGrid, directory, null);
    }

    public DirectoryNode(DirectoryGrid directoryGrid, Directory directory, String name) {
        try {
            FXMLLoader loader = new FXMLLoader(DirectoryNode.class.getResource("DirectoryNode.fxml"));
            loader.setController((Object)this);
            loader.setRoot((Object)this);
            loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.dirGrid = directoryGrid;
        this.imageView.fitHeightProperty().bind((ObservableValue)this.imagePane.prefHeightProperty());
        this.imageView.fitWidthProperty().bind((ObservableValue)this.imagePane.prefWidthProperty());
        ImageView imageViewCopy = new ImageView();
        imageViewCopy.setPreserveRatio(true);
        imageViewCopy.imageProperty().bind((ObservableValue)this.imageView.imageProperty());
        imageViewCopy.fitHeightProperty().bind((ObservableValue)this.imagePane.prefHeightProperty());
        imageViewCopy.fitWidthProperty().bind((ObservableValue)this.imagePane.prefWidthProperty());
        this.imageMask.setClip((Node)imageViewCopy);
        this.imageMask.heightProperty().bind((ObservableValue)this.imagePane.prefHeightProperty());
        this.imageMask.widthProperty().bind((ObservableValue)this.imagePane.prefWidthProperty());
        this.setDirectory(directory, name);
    }

    public void setDirectory(Directory directory) {
        this.setDirectory(directory, null);
    }

    public void setDirectory(Directory directory, String name) {
        this.directory = directory;
        if (directory instanceof Album && ((Album)directory).getCoverArtData() != null) {
            Image coverArt = Userdata.getCoverArt((Album)directory) != null ? Userdata.getCoverArt((Album)directory) : new Image((InputStream)new ByteArrayInputStream(((Album)directory).getCoverArtData()));
            Platform.runLater(() -> this.setImage(coverArt));
        } else {
            Image image = null;
            switch (directory.getType()) {
                case DIRECTORY: {
                    image = directoryImage;
                    break;
                }
                case FOLDER: {
                    image = folderImage;
                    break;
                }
                case ALBUM: {
                    image = albumImage;
                    break;
                }
                case ARTIST: {
                    image = artistImage;
                    break;
                }
                case GENRE: {
                    image = genreImage;
                    break;
                }
                case PLAYLIST: {
                    image = playlistImage;
                    break;
                }
                case ALBUM_COLLECTION: {
                    image = albumCollectionImage;
                    break;
                }
            }
            this.setMask(image);
        }
        if (name == null) {
            if (this.getChildren().contains((Object)this.label)) {
                this.getChildren().remove((Object)this.label);
                this.getStyleClass().add((Object)"no-text");
            }
        } else {
            this.label.setText(name);
            if (!this.getChildren().contains((Object)this.label)) {
                this.getChildren().add((Object)this.label);
                this.getStyleClass().remove((Object)"no-text");
            }
        }
        this.contextMenu = new DirectoryNodeContextMenu(this, this.dirGrid);
        this.setOnContextMenuRequested(event -> this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY()));
    }

    public void setImage(Image image) {
        this.imageView.setImage(image);
        this.imageView.setVisible(true);
        this.imageMask.setVisible(false);
    }

    public Image getImage() {
        return this.imageView.getImage();
    }

    public void setMask(Image image) {
        this.imageView.setImage(image);
        this.imageMask.setVisible(true);
        this.imageView.setVisible(false);
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public Directory getDirectory() {
        return this.directory;
    }
}

