/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.components;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextInputDialog;
import javafx.scene.image.Image;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import tech.octopusdragon.musicplayer.Album;
import tech.octopusdragon.musicplayer.AlbumCollection;
import tech.octopusdragon.musicplayer.AlbumCollectionDirectory;
import tech.octopusdragon.musicplayer.ChooseAlbumsDirectory;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.DirectoryType;
import tech.octopusdragon.musicplayer.Song;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.application.components.DirectoryNode;
import tech.octopusdragon.musicplayer.application.tools.Userdata;
import tech.octopusdragon.musicplayer.util.Resource;

public class DirectoryGrid
extends ScrollPane {
    private FilteredList<Directory> filteredItems;
    private SortedList<Directory> sortedItems;
    private ObjectProperty<ObservableList<Directory>> itemsProperty;
    private ObjectProperty<Comparator<Directory>> comparatorProperty;
    private SelectionModel selectionModel;
    private Directory curDirectory;
    private FlowPane flowPane;
    private List<DirectoryNode> allNodes;
    private Task<Void> nodeTask;
    private Thread nodeThread;

    public DirectoryGrid() {
        this.setMinSize(0.0, 0.0);
        this.setFitToWidth(true);
        this.setFitToHeight(true);
        this.setId("directory-view");
        this.selectionModel = new SelectionModel();
        this.comparatorProperty = new SimpleObjectProperty();
        this.allNodes = new ArrayList<DirectoryNode>();
        this.setOnMouseClicked(event -> this.selectionModel.clear());
        this.itemsProperty = new SimpleObjectProperty();
        this.flowPane = new FlowPane();
        this.setContent((Node)this.flowPane);
    }

    public ObservableList<Directory> getItems() {
        return (ObservableList)this.itemsProperty.get();
    }

    private void setItems(ObservableList<Directory> items) {
        this.filteredItems = new FilteredList(items);
        this.sortedItems = new SortedList(this.filteredItems);
        this.itemsProperty.set(this.sortedItems);
        this.getSelectionModel().clear();
    }

    public ObjectProperty<Comparator<Directory>> comparatorProperty() {
        return this.comparatorProperty;
    }

    public Comparator<Directory> getComparator() {
        return (Comparator)this.comparatorProperty.get();
    }

    public void setComparator(Comparator<Directory> comparator) {
        this.comparatorProperty.set(comparator);
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void newDirectory(Directory directory) {
        this.curDirectory = directory;
        this.setItems((ObservableList<Directory>)FXCollections.observableArrayList(directory.getDirectories()));
        Directory tempDir = directory;
        boolean chooseDirectory = false;
        AlbumCollection albumCollection = null;
        while (tempDir.getParent() != null) {
            if (tempDir.getParent().getType() == DirectoryType.CHOOSE_ALBUMS_DIRECTORY) {
                chooseDirectory = true;
                albumCollection = (AlbumCollection)tempDir.getParent().getParent();
                break;
            }
            tempDir = tempDir.getParent();
        }
        if (chooseDirectory) {
            AlbumCollection finalAlbumCollection = albumCollection;
            this.filteredItems.setPredicate(album -> !finalAlbumCollection.getDirectories().contains(album));
        } else {
            this.filteredItems.setPredicate(dir -> true);
        }
        this.refresh();
    }

    public void sort() {
        this.sortedItems.setComparator((Comparator)this.comparatorProperty.get());
        this.refresh();
    }

    public void refresh() {
        if (this.nodeTask != null && this.nodeTask.isRunning()) {
            while (this.nodeTask.cancel(false)) {
            }
            try {
                this.nodeThread.join();
            }
            catch (InterruptedException e) {
                System.out.println("Thread was unexpectedly interrupted");
                e.printStackTrace();
            }
        }
        this.nodeTask = new Task<Void>(){

            /*
             * Unable to fully structure code
             */
            protected Void call() throws Exception {
                block14: {
                    items = DirectoryGrid.this.getItems();
                    index = 0;
                    albumCollection = null;
                    curDir = DirectoryGrid.access$3(DirectoryGrid.this);
                    while (curDir.getParent() != null) {
                        if (curDir.getParent().getType() == DirectoryType.CHOOSE_ALBUMS_DIRECTORY) {
                            albumCollection = (AlbumCollection)curDir.getParent().getParent();
                            break;
                        }
                        curDir = curDir.getParent();
                    }
                    if (albumCollection == null) ** GOTO lbl30
                    while (index < items.size()) {
                        if (this.isCancelled()) {
                            return null;
                        }
                        directory = (Directory)items.get(index);
                        dirNode = DirectoryGrid.this.putDirectoryNode(index, directory, directory.getName());
                        if (directory instanceof Album) {
                            dirNode.setOnMouseClicked(new ClickAddAlbumHandler((Album)directory, albumCollection));
                        } else {
                            dirNode.setOnMouseClicked(new ClickMoveForwardHandler());
                        }
                        ++index;
                    }
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        if (this.isCancelled()) {
                            return null;
                        }
                        directory = (Directory)items.get(index);
                        dirNode = DirectoryGrid.this.putDirectoryNode(index, directory, directory.getName());
                        dirNode.setOnMouseClicked(new ClickMoveForwardHandler());
                        ++index;
lbl30:
                        // 2 sources

                        ** while (index < items.size())
                    }
                }
                if (DirectoryGrid.access$3(DirectoryGrid.this).hasSongs()) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    curDirTracks = new Directory("<Current Folder>", DirectoryGrid.access$3(DirectoryGrid.this));
                    for (Song song : DirectoryGrid.access$3(DirectoryGrid.this).getSongs()) {
                        curDirTracks.addSong(song);
                    }
                    mediaNode = DirectoryGrid.this.putDirectoryNode(index, curDirTracks, curDirTracks.getName());
                    mediaNode.setOnMouseClicked(new ClickMoveForwardHandler());
                    ++index;
                }
                if (DirectoryGrid.access$3(DirectoryGrid.this).getType() == DirectoryType.ALBUM_COLLECTION_DIRECTORY) {
                    addAlbumCollectionNode = DirectoryGrid.this.putDirectoryNode(index, DirectoryGrid.access$3(DirectoryGrid.this));
                    Platform.runLater((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(tech.octopusdragon.musicplayer.application.components.DirectoryNode ), ()V)((DirectoryNode)addAlbumCollectionNode));
                    addAlbumCollectionNode.setOnMouseClicked(new ClickAddAlbumCollectionHandler());
                    ++index;
                }
                if (DirectoryGrid.access$3(DirectoryGrid.this).getType() == DirectoryType.ALBUM_COLLECTION) {
                    addAlbumCollectionAlbumNode = DirectoryGrid.this.putDirectoryNode(index, DirectoryGrid.access$3(DirectoryGrid.this));
                    Platform.runLater((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$1(tech.octopusdragon.musicplayer.application.components.DirectoryNode ), ()V)((DirectoryNode)addAlbumCollectionAlbumNode));
                    addAlbumCollectionAlbumNode.setOnMouseClicked(new ClickAddAlbumsHandler((AlbumCollection)DirectoryGrid.access$3(DirectoryGrid.this)));
                    ++index;
                }
                while (index < DirectoryGrid.access$4(DirectoryGrid.this).size()) {
                    node = (DirectoryNode)DirectoryGrid.access$4(DirectoryGrid.this).get(index);
                    Platform.runLater((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$2(tech.octopusdragon.musicplayer.application.components.DirectoryNode ), ()V)(this, (DirectoryNode)node));
                    ++index;
                }
                return null;
            }

            private static /* synthetic */ void lambda$0(DirectoryNode directoryNode) {
                directoryNode.setMask(new Image(Resource.PLUS_IMAGE.getPath()));
                directoryNode.setOnContextMenuRequested(null);
                directoryNode.setMaxHeight(Double.NEGATIVE_INFINITY);
            }

            private static /* synthetic */ void lambda$1(DirectoryNode directoryNode) {
                directoryNode.setMask(new Image(Resource.PLUS_IMAGE.getPath()));
                directoryNode.setOnContextMenuRequested(null);
                directoryNode.setMaxHeight(Double.NEGATIVE_INFINITY);
            }

            private /* synthetic */ void lambda$2(DirectoryNode directoryNode) {
                if (DirectoryGrid.this.flowPane.getChildren().contains((Object)directoryNode)) {
                    DirectoryGrid.this.flowPane.getChildren().remove((Object)directoryNode);
                }
            }
        };
        this.nodeThread = new Thread((Runnable)this.nodeTask);
        this.nodeThread.start();
    }

    public DirectoryNode putDirectoryNode(int index, Directory directory) {
        return this.putDirectoryNode(index, directory, null);
    }

    public DirectoryNode putDirectoryNode(int index, Directory directory, String name) {
        DirectoryNode dirNode;
        if (index >= this.allNodes.size()) {
            dirNode = new DirectoryNode(this, directory, name);
            dirNode.setOnMouseEntered(new MouseEnterEventHandler());
            dirNode.setOnMouseExited(new MouseExitEventHandler());
            this.allNodes.add(dirNode);
            Platform.runLater(() -> this.flowPane.getChildren().add((Object)dirNode));
        } else {
            dirNode = this.allNodes.get(index);
            Platform.runLater(() -> {
                dirNode.setDirectory(directory, name);
                if (!this.flowPane.getChildren().contains((Object)dirNode)) {
                    this.flowPane.getChildren().add((Object)dirNode);
                }
            });
        }
        dirNode.setMaxHeight(-1.0);
        return dirNode;
    }

    static /* synthetic */ Directory access$3(DirectoryGrid directoryGrid) {
        return directoryGrid.curDirectory;
    }

    static /* synthetic */ List access$4(DirectoryGrid directoryGrid) {
        return directoryGrid.allNodes;
    }

    private class ClickAddAlbumCollectionHandler
    extends MouseClickHandler {
        private ClickAddAlbumCollectionHandler() {
        }

        @Override
        public void handle(MouseEvent event) {
            super.handle(event);
            if (event.getClickCount() % 2 == 0) {
                TextInputDialog nameDialog = new TextInputDialog();
                nameDialog.setContentText("Name");
                nameDialog.setHeaderText("What would you like to call your new album collection?");
                nameDialog.setTitle("New Album Collection");
                Optional result = nameDialog.showAndWait();
                if (result.isPresent() && !((String)result.get()).trim().isEmpty()) {
                    AlbumCollectionDirectory directory = (AlbumCollectionDirectory)Userdata.getRootDirectories().getAlbumCollectionDirectory();
                    AlbumCollection newAlbumCollection = new AlbumCollection((String)result.get(), directory);
                    directory.addDirectory(newAlbumCollection);
                    DirectoryGrid.this.newDirectory(directory);
                    Userdata.saveMusicLibrary(false);
                    DirectoryGrid.this.refresh();
                    Userdata.saveAlbumCollection(newAlbumCollection);
                }
            }
        }
    }

    private class ClickAddAlbumHandler
    extends MouseClickHandler {
        private Album album;
        private AlbumCollection albumCollection;

        public ClickAddAlbumHandler(Album album, AlbumCollection albumCollection) {
            this.album = album;
            this.albumCollection = albumCollection;
        }

        @Override
        public void handle(MouseEvent event) {
            super.handle(event);
            if (event.getClickCount() % 2 == 0) {
                Album copyAlbum = new Album(this.album);
                copyAlbum.setParent(this.albumCollection);
                this.albumCollection.getDirectories().add(copyAlbum);
                Platform.runLater(() -> DirectoryGrid.this.flowPane.getChildren().remove(event.getSource()));
                Userdata.saveAlbumCollection(this.albumCollection);
            }
        }
    }

    private class ClickAddAlbumsHandler
    extends MouseClickHandler {
        private AlbumCollection albumCollection;

        public ClickAddAlbumsHandler(AlbumCollection albumCollection) {
            this.albumCollection = albumCollection;
        }

        @Override
        public void handle(MouseEvent event) {
            super.handle(event);
            if (event.getClickCount() % 2 == 0) {
                ChooseAlbumsDirectory chooser = new ChooseAlbumsDirectory("Choose Albums", this.albumCollection);
                MusicPlayerApplication.goForwardToDirectory(chooser);
            }
        }
    }

    private class ClickMoveForwardHandler
    extends MouseClickHandler {
        private ClickMoveForwardHandler() {
        }

        @Override
        public void handle(MouseEvent event) {
            super.handle(event);
            if (event.getClickCount() % 2 == 0) {
                Directory dir = ((DirectoryNode)((Object)event.getSource())).getDirectory();
                MusicPlayerApplication.goForward(dir);
            }
        }
    }

    private class MouseClickHandler
    implements EventHandler<MouseEvent> {
        private MouseClickHandler() {
        }

        public void handle(MouseEvent event) {
            DirectoryNode dirNode = (DirectoryNode)((Object)event.getSource());
            event.consume();
            if (event.isShiftDown()) {
                int thisIndex = DirectoryGrid.this.flowPane.getChildren().indexOf((Object)dirNode);
                int lastIndex = DirectoryGrid.this.flowPane.getChildren().indexOf((Object)DirectoryGrid.this.selectionModel.getLastSelected());
                DirectoryGrid.this.selectionModel.selectRange(Math.min(thisIndex, lastIndex), Math.max(thisIndex, lastIndex));
            } else if (event.isControlDown()) {
                if (!DirectoryGrid.this.selectionModel.contains(dirNode)) {
                    DirectoryGrid.this.selectionModel.add(dirNode);
                } else {
                    DirectoryGrid.this.selectionModel.remove(dirNode);
                }
            } else if (event.getButton() == MouseButton.SECONDARY) {
                if (!DirectoryGrid.this.selectionModel.contains(dirNode)) {
                    DirectoryGrid.this.selectionModel.clearAndAdd(dirNode);
                }
            } else {
                DirectoryGrid.this.selectionModel.clearAndAdd(dirNode);
            }
        }
    }

    private class MouseEnterEventHandler
    implements EventHandler<MouseEvent> {
        private MouseEnterEventHandler() {
        }

        public void handle(MouseEvent event) {
            ((DirectoryNode)((Object)event.getSource())).pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"hover"), true);
        }
    }

    private class MouseExitEventHandler
    implements EventHandler<MouseEvent> {
        private MouseExitEventHandler() {
        }

        public void handle(MouseEvent event) {
            ((DirectoryNode)((Object)event.getSource())).pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"hover"), false);
        }
    }

    public class SelectionModel {
        private Set<DirectoryNode> selection = new HashSet<DirectoryNode>();
        private DirectoryNode lastSelected;
        private Set<DirectoryNode> curRange = new HashSet<DirectoryNode>();

        public DirectoryNode getLastSelected() {
            return this.lastSelected;
        }

        public void add(DirectoryNode dirNode) {
            this.clearRange();
            dirNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"selected"), true);
            this.selection.add(dirNode);
            this.lastSelected = dirNode;
        }

        private void addIgnore(DirectoryNode dirNode) {
            dirNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"selected"), true);
            this.selection.add(dirNode);
        }

        private void addToRange(DirectoryNode dirNode) {
            this.curRange.add(dirNode);
        }

        public void remove(DirectoryNode dirNode) {
            dirNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"selected"), false);
            this.selection.remove((Object)dirNode);
        }

        private void removeFromRange(DirectoryNode dirNode) {
            this.curRange.remove((Object)dirNode);
        }

        public void clear() {
            while (!this.selection.isEmpty()) {
                this.remove(this.selection.iterator().next());
            }
        }

        private void clearRange() {
            while (!this.curRange.isEmpty()) {
                this.removeFromRange(this.curRange.iterator().next());
            }
        }

        private void clearSelectionInRange() {
            for (DirectoryNode dirNode : this.curRange) {
                this.remove(dirNode);
            }
        }

        public void clearAndAdd(DirectoryNode dirNode) {
            this.clear();
            this.add(dirNode);
        }

        private void selectRange() {
            for (DirectoryNode dirNode : this.curRange) {
                this.addIgnore(dirNode);
            }
        }

        public void selectRange(int minIndex, int maxIndex) {
            this.clearSelectionInRange();
            this.clearRange();
            int index = minIndex;
            while (index != maxIndex) {
                this.addToRange((DirectoryNode)((Object)DirectoryGrid.this.flowPane.getChildren().get(index)));
                ++index;
            }
            this.addToRange((DirectoryNode)((Object)DirectoryGrid.this.flowPane.getChildren().get(maxIndex)));
            this.selectRange();
        }

        public Directory[] getItems() {
            ArrayList<Directory> items = new ArrayList<Directory>();
            for (DirectoryNode node : this.selection) {
                items.add(node.getDirectory());
            }
            items.sort(DirectoryGrid.this.sortedItems.getComparator());
            return items.toArray(new Directory[0]);
        }

        public boolean contains(DirectoryNode dirNode) {
            return this.selection.contains((Object)dirNode);
        }
    }
}

