/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application.components;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import tech.octopusdragon.musicplayer.Album;
import tech.octopusdragon.musicplayer.Song;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;

public class AlbumInfoBox
extends GridPane {
    private static final double DEFAULT_HEIGHT = 140.0;
    private Album album;
    @FXML
    private StackPane imagePane;
    @FXML
    private ImageView albumImageView;
    @FXML
    private Label albumLabel;
    @FXML
    private Label albumArtistLabel;
    @FXML
    private Label genreLabel;
    @FXML
    private Label yearLabel;

    public AlbumInfoBox() {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("AlbumInfoBox.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.imagePane.setPrefHeight(140.0);
        this.albumImageView.fitHeightProperty().bind((ObservableValue)this.imagePane.prefHeightProperty());
        ObservableList<Song> songs = MusicPlayerApplication.getMusicPlayer().getDirSongs();
        songs.addListener(c -> {
            if (songs.isEmpty()) {
                return;
            }
            this.album = ((Song)songs.get(0)).getAlbum();
            if (this.album == null) {
                return;
            }
            if (this.album.getCoverArtData() != null) {
                this.albumImageView.setImage(new Image((InputStream)new ByteArrayInputStream(this.album.getCoverArtData())));
            }
            if (this.album.getCoverArtData() != null && !this.getChildren().contains((Object)this.albumImageView)) {
                this.getChildren().add(0, (Object)this.albumImageView);
            } else if (this.album.getCoverArtData() == null && this.getChildren().contains((Object)this.albumImageView)) {
                this.getChildren().remove((Object)this.albumImageView);
            }
            this.albumLabel.setText(this.album.getAlbum());
            this.albumArtistLabel.setText(this.album.getAlbumArtist());
            this.genreLabel.setText(this.album.getGenre());
            this.yearLabel.setText(String.valueOf(this.album.getYear()));
        });
    }
}

