/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer.application;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.MusicPlayer;
import tech.octopusdragon.musicplayer.SongDirectory;
import tech.octopusdragon.musicplayer.application.tools.Balance;
import tech.octopusdragon.musicplayer.application.tools.NavigatorView;
import tech.octopusdragon.musicplayer.application.tools.OnSetProperty;
import tech.octopusdragon.musicplayer.application.tools.Rate;
import tech.octopusdragon.musicplayer.application.tools.Theme;
import tech.octopusdragon.musicplayer.application.tools.UISize;
import tech.octopusdragon.musicplayer.application.tools.Userdata;
import tech.octopusdragon.musicplayer.application.tools.View;
import tech.octopusdragon.musicplayer.application.windows.LibraryLocationDialog;
import tech.octopusdragon.musicplayer.util.Resource;

public class MusicPlayerApplication
extends Application {
    private static final double DEFAULT_WIDTH = 600.0;
    private static final double DEFAULT_HEIGHT = 400.0;
    private static final String ROOT_FXML_PATH = "scenes/Root.fxml";
    private static final String DEFAULT_ROOT_FOLDER_PATH = System.getProperty("user.home");
    private static Stage primaryStage;
    private static Scene scene;
    private static Parent root;
    private static String rootFolderPath;
    private static ObjectProperty<Directory> currentRootDirectory;
    private static MusicPlayer musicPlayer;
    private static ObservableList<Directory> allRootDirectories;
    private static ObjectProperty<Rate> rateEnumProperty;
    private static ObjectProperty<Balance> balanceEnumProperty;
    private static ObservableList<Directory> history;
    private static ArrayList<Boolean> historyTrackView;
    private static IntegerProperty historyIndexProperty;
    private static OnSetProperty<NavigatorView> navigatorViewProperty;
    private static BooleanProperty reloadingProperty;
    private static ObjectProperty<View> currentViewProperty;
    private static UISize curUISize;
    private static Theme curTheme;
    private static StringProperty updateMessageProperty;

    public void init() {
        musicPlayer = new MusicPlayer();
        musicPlayer.setMute(Boolean.parseBoolean(Userdata.readProperty("mute", String.valueOf(false))));
        musicPlayer.muteProperty().addListener((obs, oldVal, newVal) -> Userdata.writeProperty("mute", String.valueOf(newVal)));
        musicPlayer.setShuffle(Boolean.parseBoolean(Userdata.readProperty("shuffle", String.valueOf(false))));
        musicPlayer.shuffleProperty().addListener((obs, oldVal, newVal) -> Userdata.writeProperty("shuffle", String.valueOf(newVal)));
        musicPlayer.setRepeat(Boolean.parseBoolean(Userdata.readProperty("repeat", String.valueOf(false))));
        musicPlayer.repeatProperty().addListener((obs, oldVal, newVal) -> Userdata.writeProperty("repeat", String.valueOf(newVal)));
        musicPlayer.setRepeatSingle(Boolean.parseBoolean(Userdata.readProperty("repeat-single", String.valueOf(false))));
        musicPlayer.repeatSingleProperty().addListener((obs, oldVal, newVal) -> Userdata.writeProperty("repeat-single", String.valueOf(newVal)));
        musicPlayer.setVolume(Double.parseDouble(Userdata.readProperty("volume", String.valueOf(0.8))));
        musicPlayer.volumeProperty().addListener((obs, oldVal, newVal) -> Userdata.writeProperty("volume", String.valueOf(newVal)));
        rateEnumProperty = new SimpleObjectProperty((Object)Rate.valueOf(Userdata.readProperty("rate-enum", Rate.NORMAL.name())));
        musicPlayer.rateProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            double rate = 1.0;
            switch ((Rate)((Object)((Object)rateEnumProperty.get()))) {
                case QUARTER: {
                    rate = 0.25;
                    break;
                }
                case HALF: {
                    rate = 0.5;
                    break;
                }
                case NORMAL: {
                    rate = 1.0;
                    break;
                }
                case DOUBLE: {
                    rate = 2.0;
                    break;
                }
                case QUADRUPLE: {
                    rate = 4.0;
                }
            }
            return rate;
        }, (Observable[])new Observable[]{rateEnumProperty}));
        rateEnumProperty.addListener((obs, oldVal, newVal) -> Userdata.writeProperty("rate-enum", newVal.name()));
        balanceEnumProperty = new SimpleObjectProperty((Object)Balance.valueOf(Userdata.readProperty("balance-enum", Balance.CENTER.name())));
        musicPlayer.balanceProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            double balance = 0.0;
            switch ((Balance)((Object)((Object)balanceEnumProperty.get()))) {
                case FULL_LEFT: {
                    balance = -1.0;
                    break;
                }
                case HALF_LEFT: {
                    balance = -0.5;
                    break;
                }
                case CENTER: {
                    balance = 0.0;
                    break;
                }
                case HALF_RIGHT: {
                    balance = 0.5;
                    break;
                }
                case FULL_RIGHT: {
                    balance = 1.0;
                }
            }
            return balance;
        }, (Observable[])new Observable[]{balanceEnumProperty}));
        balanceEnumProperty.addListener((obs, oldVal, newVal) -> Userdata.writeProperty("balance-enum", newVal.name()));
        history = FXCollections.observableArrayList();
        historyTrackView = new ArrayList();
        historyIndexProperty = new SimpleIntegerProperty(-1);
        currentViewProperty = new SimpleObjectProperty();
        currentViewProperty.set((Object)View.valueOf(Userdata.readProperty("view", View.EXPLORER.name())));
        curUISize = UISize.valueOf(Userdata.readProperty("ui-size", UISize.MEDIUM.name()));
        curTheme = Theme.valueOf(Userdata.readProperty("theme", Theme.BLUE.name()));
        currentRootDirectory = new SimpleObjectProperty();
        navigatorViewProperty = new OnSetProperty<NavigatorView>(NavigatorView.valueOf(Userdata.readProperty("last-directory-navigator-view", String.valueOf((Object)NavigatorView.DIRECTORY))));
        navigatorViewProperty.addListener((observable, oldValue, newValue) -> Userdata.writeProperty("last-directory-navigator-view", String.valueOf(newValue)));
        reloadingProperty = new SimpleBooleanProperty(false);
        updateMessageProperty = new SimpleStringProperty();
    }

    public void start(Stage primaryStage) {
        MusicPlayerApplication.primaryStage = primaryStage;
        allRootDirectories = FXCollections.observableArrayList();
        try {
            rootFolderPath = Userdata.getRootDirectories().getFolderDirectory().getPath();
            Platform.runLater(() -> {
                allRootDirectories.addAll((Object[])Userdata.getRootDirectories().getAllDirectories());
                Directory directory = Userdata.getLastDirectory();
                if (directory != null) {
                    switch ((NavigatorView)((Object)((Object)navigatorViewProperty.get()))) {
                        case DIRECTORY: {
                            MusicPlayerApplication.goForwardToDirectory(directory);
                            break;
                        }
                        case TRACK: {
                            MusicPlayerApplication.goForwardToTracks(directory);
                        }
                    }
                } else {
                    MusicPlayerApplication.newRootDirectory(Userdata.getRootDirectories().defaultDirectory());
                }
            });
        }
        catch (NullPointerException e) {
            rootFolderPath = DEFAULT_ROOT_FOLDER_PATH;
            Optional result = new LibraryLocationDialog(rootFolderPath).showAndWait();
            if (result == null || !result.isPresent()) {
                System.exit(0);
            } else {
                rootFolderPath = (String)result.get();
                MusicPlayerApplication.reload();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rootFolderPath = DEFAULT_ROOT_FOLDER_PATH;
            MusicPlayerApplication.selectRootFolder();
        }
        root = MusicPlayerApplication.getFXMLRoot(ROOT_FXML_PATH);
        scene = new Scene(root);
        scene.getStylesheets().add((Object)Resource.MAIN_STYLESHEET.getResource().toExternalForm());
        primaryStage.setScene(scene);
        primaryStage.setTitle("Music Player");
        primaryStage.getIcons().add((Object)new Image(Resource.ICON.getResourceAsStream()));
        MusicPlayerApplication.setUISize(curUISize);
        MusicPlayerApplication.setTheme(curTheme);
        primaryStage.setWidth(Double.parseDouble(Userdata.readProperty("window-width", String.valueOf(600.0))));
        primaryStage.widthProperty().addListener((obs, oldVal, newVal) -> {
            if (!primaryStage.isMaximized()) {
                Userdata.writeProperty("window-width", String.valueOf(newVal));
            }
        });
        primaryStage.setHeight(Double.parseDouble(Userdata.readProperty("window-height", String.valueOf(400.0))));
        primaryStage.heightProperty().addListener((obs, oldVal, newVal) -> {
            if (!primaryStage.isMaximized()) {
                Userdata.writeProperty("window-height", String.valueOf(newVal));
            }
        });
        if (Userdata.readProperty("window-x") != null) {
            primaryStage.setX(Double.parseDouble(Userdata.readProperty("window-x")));
        }
        primaryStage.xProperty().addListener((obs, oldVal, newVal) -> {
            if (!primaryStage.isMaximized()) {
                Userdata.writeProperty("window-x", String.valueOf(newVal));
                Userdata.writeProperty("old-window-x", String.valueOf(oldVal));
            }
        });
        if (Userdata.readProperty("window-y") != null) {
            primaryStage.setY(Double.parseDouble(Userdata.readProperty("window-y")));
        }
        primaryStage.yProperty().addListener((obs, oldVal, newVal) -> {
            if (!primaryStage.isMaximized()) {
                Userdata.writeProperty("window-y", String.valueOf(newVal));
                Userdata.writeProperty("old-window-y", String.valueOf(oldVal));
            }
        });
        primaryStage.setMaximized(Boolean.parseBoolean(Userdata.readProperty("maximized", String.valueOf(false))));
        primaryStage.maximizedProperty().addListener((obs, oldVal, newVal) -> {
            Userdata.writeProperty("maximized", String.valueOf(newVal));
            if (newVal.booleanValue()) {
                Userdata.writeProperty("window-x", Userdata.readProperty("old-window-x"));
                Userdata.writeProperty("window-y", Userdata.readProperty("old-window-y"));
            }
        });
        primaryStage.show();
        double decorationHeight = primaryStage.getHeight() - scene.getHeight();
        double decorationWidth = primaryStage.getWidth() - scene.getWidth();
        primaryStage.setMinWidth(root.minWidth(-1.0) + decorationWidth);
        primaryStage.setMinHeight(root.minHeight(-1.0) + decorationHeight);
    }

    public void stop() {
        Userdata.saveProperties(true);
        Userdata.saveLastDirectory(true);
        Userdata.saveMusicLibrary(true);
    }

    private static Parent getFXMLRoot(String fxmlPath) {
        Parent root = null;
        try {
            root = (Parent)FXMLLoader.load((URL)MusicPlayerApplication.class.getResource(fxmlPath));
        }
        catch (IOException e) {
            System.out.println("ERROR: Unable to load FXML");
            e.printStackTrace();
        }
        return root;
    }

    public static void main(String[] args) {
        MusicPlayerApplication.launch((String[])args);
    }

    public static void newRootDirectory(Directory directory) {
        if (directory.getClass() == SongDirectory.class) {
            MusicPlayerApplication.goForwardToTracks(directory);
        } else {
            MusicPlayerApplication.goForwardToDirectory(directory);
        }
        currentRootDirectory.set((Object)directory);
    }

    public static void selectRootFolder() {
        DirectoryChooser folderChooser = new DirectoryChooser();
        folderChooser.setTitle("Choose root music directory");
        File rootFolder = new File(rootFolderPath);
        if (!rootFolder.exists()) {
            rootFolder = new File(DEFAULT_ROOT_FOLDER_PATH);
        }
        folderChooser.setInitialDirectory(rootFolder);
        File selectedFile = folderChooser.showDialog((Window)primaryStage);
        if (selectedFile == null) {
            return;
        }
        rootFolderPath = selectedFile.getPath();
        MusicPlayerApplication.reload();
    }

    public static void search(String text) {
        musicPlayer.getFilteredDirSongs().setPredicate(song -> song.getTitle().toLowerCase().contains(text.toLowerCase()));
    }

    public static void searchAndGo(String text) {
        MusicPlayerApplication.search(text);
        MusicPlayerApplication.newRootDirectory(Userdata.getRootDirectories().getSongDirectory());
    }

    public static void switchView(View view) {
        Userdata.writeProperty("view", view.name());
        currentViewProperty.set((Object)view);
    }

    public static void setTheme(Theme theme) {
        scene.getStylesheets().remove((Object)curTheme.getResource().toExternalForm());
        scene.getStylesheets().add((Object)theme.getResource().toExternalForm());
        Userdata.writeProperty("theme", theme.name());
        curTheme = theme;
    }

    public static void setUISize(UISize uiSize) {
        scene.getStylesheets().remove((Object)curUISize.getResource().toExternalForm());
        scene.getStylesheets().add((Object)uiSize.getResource().toExternalForm());
        Userdata.writeProperty("ui-size", uiSize.name());
        curUISize = uiSize;
        primaryStage.minWidthProperty().unbind();
        primaryStage.minHeightProperty().unbind();
        double decorationHeight = primaryStage.getHeight() - scene.getHeight();
        double decorationWidth = primaryStage.getWidth() - scene.getWidth();
        root.applyCss();
        primaryStage.setMinWidth(root.minWidth(-1.0) + decorationWidth);
        primaryStage.setMinHeight(root.minHeight(-1.0) + decorationHeight);
    }

    public static void reload() {
        Task<Void> reloadTask = new Task<Void>(){

            protected Void call() {
                if (reloadingProperty.get()) {
                    return null;
                }
                reloadingProperty.set(true);
                Userdata.scanMusicLibrary(rootFolderPath);
                Platform.runLater(() -> {
                    allRootDirectories.clear();
                    allRootDirectories.addAll((Object[])Userdata.getRootDirectories().getAllDirectories());
                });
                reloadingProperty.set(false);
                Platform.runLater(() -> {
                    history.clear();
                    historyTrackView.clear();
                    historyIndexProperty.set(-1);
                    MusicPlayerApplication.newRootDirectory(Userdata.getRootDirectories().getAlbumDirectory());
                });
                return null;
            }
        };
        Thread reloadThread = new Thread((Runnable)reloadTask);
        reloadThread.start();
    }

    public static void back() {
        historyIndexProperty.set(historyIndexProperty.get() - 1);
        Directory newDirectory = (Directory)history.get(historyIndexProperty.get());
        if (historyTrackView.get(historyIndexProperty.get()).booleanValue()) {
            MusicPlayerApplication.goToTracks(newDirectory);
        } else {
            MusicPlayerApplication.goToDirectory(newDirectory);
        }
    }

    public static void forward() {
        historyIndexProperty.set(historyIndexProperty.get() + 1);
        Directory newDirectory = (Directory)history.get(historyIndexProperty.get());
        if (historyTrackView.get(historyIndexProperty.get()).booleanValue()) {
            MusicPlayerApplication.goToTracks(newDirectory);
        } else {
            MusicPlayerApplication.goToDirectory(newDirectory);
        }
    }

    public static void goForward(Directory directory) {
        if (directory.hasSongs() && !directory.hasDirectories()) {
            MusicPlayerApplication.goForwardToTracks(directory);
        } else {
            MusicPlayerApplication.goForwardToDirectory(directory);
        }
    }

    public static void goToDirectory(Directory directory) {
        musicPlayer.newDirectory(directory, true);
        navigatorViewProperty.set(NavigatorView.DIRECTORY);
        currentRootDirectory.set((Object)directory.getRoot());
        Userdata.setLastDirectory(directory);
    }

    public static void goToTracks(Directory directory) {
        musicPlayer.newDirectory(directory, false);
        navigatorViewProperty.set(NavigatorView.TRACK);
        currentRootDirectory.set((Object)directory.getRoot());
        Userdata.setLastDirectory(directory);
    }

    public static void goForwardToDirectory(Directory directory) {
        if (musicPlayer.getCurDirectory().get() == directory) {
            return;
        }
        MusicPlayerApplication.goToDirectory(directory);
        if (historyIndexProperty.get() != history.size() - 1) {
            while (history.size() - 1 > historyIndexProperty.get()) {
                history.remove(history.size() - 1);
                historyTrackView.remove(historyTrackView.size() - 1);
            }
        }
        history.add((Object)directory);
        historyTrackView.add(false);
        historyIndexProperty.set(history.size() - 1);
    }

    public static void goForwardToTracks(Directory directory) {
        if (musicPlayer.getCurDirectory().get() == directory) {
            return;
        }
        MusicPlayerApplication.goToTracks(directory);
        if (historyIndexProperty.get() != history.size() - 1) {
            while (history.size() - 1 > historyIndexProperty.get()) {
                history.remove(history.size() - 1);
                historyTrackView.remove(historyTrackView.size() - 1);
            }
        }
        history.add((Object)directory);
        historyTrackView.add(true);
        historyIndexProperty.set(history.size() - 1);
    }

    public static MusicPlayer getMusicPlayer() {
        return musicPlayer;
    }

    public static ObservableList<Directory> getRootDirectories() {
        return allRootDirectories;
    }

    public static ObjectProperty<Directory> currentRootDirectoryProperty() {
        return currentRootDirectory;
    }

    public static Directory getCurrentRootDirectory() {
        return (Directory)currentRootDirectory.get();
    }

    public static ObservableList<Directory> getHistory() {
        return history;
    }

    public static IntegerProperty historyIndexProperty() {
        return historyIndexProperty;
    }

    public static int getHistoryIndex() {
        return historyIndexProperty.get();
    }

    public static UISize getCurUISize() {
        return curUISize;
    }

    public static Theme getCurTheme() {
        return curTheme;
    }

    public static Rate getRateEnum() {
        return (Rate)((Object)rateEnumProperty.get());
    }

    public static void setRateEnum(Rate rate) {
        rateEnumProperty.set((Object)rate);
    }

    public static ObjectProperty<Rate> rateEnumProperty() {
        return rateEnumProperty;
    }

    public static Balance getBalanceEnum() {
        return (Balance)((Object)balanceEnumProperty.get());
    }

    public static void setBalanceEnum(Balance balance) {
        balanceEnumProperty.set((Object)balance);
    }

    public static ObjectProperty<Balance> balanceEnumProperty() {
        return balanceEnumProperty;
    }

    public static NavigatorView getNavigatorView() {
        return (NavigatorView)((Object)navigatorViewProperty.get());
    }

    public static OnSetProperty<NavigatorView> navigatorViewProperty() {
        return navigatorViewProperty;
    }

    public static boolean isReloading() {
        return reloadingProperty.get();
    }

    public static BooleanProperty reloadingProperty() {
        return reloadingProperty;
    }

    public static View getCurrentView() {
        return (View)((Object)currentViewProperty.get());
    }

    public static ObjectProperty<View> currentViewProperty() {
        return currentViewProperty;
    }

    public static final StringProperty updateMessageProperty() {
        return updateMessageProperty;
    }

    public static final String getUpdateMessage() {
        return (String)MusicPlayerApplication.updateMessageProperty().get();
    }

    public static final void setUpdateMessage(String currentlyLoadingSong) {
        MusicPlayerApplication.updateMessageProperty().set((Object)currentlyLoadingSong);
    }
}

