/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import tech.octopusdragon.musicplayer.Album;
import tech.octopusdragon.musicplayer.util.Util;

public class Song
implements Comparable<Song>,
Serializable {
    private static final long serialVersionUID = 1831441055680211029L;
    private String path;
    private String filename;
    private int disc;
    private int track;
    private String title;
    private String artist;
    private String albumArtist;
    private String albumStr;
    private String genre;
    private int year;
    private String duration;
    private Album album;

    public Song(File file) {
        this.path = file.getPath();
        this.filename = file.getName();
        this.initializeTags(file);
    }

    private void initializeTags(File file) {
        AudioFile audioFile = this.audioFile(file);
        Tag tag = this.tag(audioFile);
        this.initializeDisc(tag);
        this.initializeTrack(tag);
        this.initializeTitle(tag);
        this.initializeArtist(tag);
        this.initializeAlbumArtist(tag);
        this.initializeAlbum(tag);
        this.initializeGenre(tag);
        this.initializeYear(tag);
        this.initializeDuration(audioFile);
    }

    public Song(String filename) {
        this(new File(filename));
    }

    public String getURI() {
        return new File(this.path).toURI().toString();
    }

    public String getPath() {
        return this.path;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getExtension() {
        return Util.getFileExtension(this.path);
    }

    public void initializeDisc(Tag tag) {
        String disc = "";
        disc = tag.getFirst(FieldKey.DISC_NO);
        if (disc.equals("")) {
            disc = "1";
        }
        this.disc = Integer.parseInt(disc);
    }

    public void initializeTrack(Tag tag) {
        String track = "";
        track = tag.getFirst(FieldKey.TRACK);
        if (track.equals("")) {
            track = "0";
        }
        this.track = Integer.parseInt(track);
    }

    public void initializeTitle(Tag tag) {
        String title = "";
        title = tag.getFirst(FieldKey.TITLE);
        if (title.equals("")) {
            title = "Unknown Title";
        }
        this.title = title;
    }

    public void initializeArtist(Tag tag) {
        String artist = "";
        artist = tag.getFirst(FieldKey.ARTIST);
        if (artist.equals("")) {
            artist = "Unknown Artist";
        }
        this.artist = artist;
    }

    public void initializeAlbumArtist(Tag tag) {
        String albumArtist = "";
        albumArtist = tag.getFirst(FieldKey.ALBUM_ARTIST);
        if (albumArtist.equals("")) {
            albumArtist = "Unknown Album Artist";
        }
        this.albumArtist = albumArtist;
    }

    public void initializeAlbum(Tag tag) {
        String album = "";
        album = tag.getFirst(FieldKey.ALBUM);
        if (album.equals("")) {
            album = "Unknown Album";
        }
        this.albumStr = album;
    }

    public void initializeGenre(Tag tag) {
        String genre = "";
        genre = tag.getFirst(FieldKey.GENRE);
        if (genre.equals("")) {
            genre = "Unknown Genre";
        }
        this.genre = genre;
    }

    public void initializeYear(Tag tag) {
        String year = "";
        year = tag.getFirst(FieldKey.YEAR);
        if ((year = year.split("-")[0]).equals("")) {
            year = "0";
        }
        this.year = Integer.parseInt(year);
    }

    public void initializeDuration(AudioFile audioFile) {
        int seconds = audioFile.getAudioHeader().getTrackLength();
        int minutes = seconds / 60;
        this.duration = String.format("%01d:%02d", minutes, seconds %= 60);
    }

    public int getDisc() {
        return this.disc;
    }

    public int getTrack() {
        return this.track;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbumArtist() {
        return this.albumArtist;
    }

    public String getAlbumStr() {
        return this.albumStr;
    }

    public String getGenre() {
        return this.genre;
    }

    public int getYear() {
        return this.year;
    }

    public byte[] coverArtData() {
        Tag tag = this.tag();
        Artwork coverArt = null;
        if (this.getExtension().equals(".mp3")) {
            coverArt = tag.getFirstArtwork();
        } else if (this.getExtension().equals(".m4a")) {
            coverArt = ((Mp4Tag)tag).getFirstArtwork();
        }
        return coverArt != null ? coverArt.getBinaryData() : null;
    }

    public String getDuration() {
        return this.duration;
    }

    public Album getAlbum() {
        return this.album;
    }

    public void setAlbum(Album album) {
        this.album = album;
    }

    @Override
    public int compareTo(Song other) {
        int number = this.getAlbumStr().compareToIgnoreCase(other.getAlbumStr()) < 0 ? -1 : (this.getAlbumStr().compareToIgnoreCase(other.getAlbumStr()) > 0 ? 1 : (this.getAlbumArtist().compareToIgnoreCase(other.getAlbumArtist()) < 0 ? -1 : (this.getAlbumArtist().compareToIgnoreCase(other.getAlbumArtist()) > 0 ? 1 : (this.getDisc() < other.getDisc() ? -1 : (this.getDisc() > other.getDisc() ? 1 : (this.getTrack() < other.getTrack() ? -1 : (this.getTrack() > other.getTrack() ? 1 : 0)))))));
        return number;
    }

    public boolean equals(Object other) {
        if (!Object.class.getClass().equals(Song.class.getClass()) || this == null || other == null) {
            return false;
        }
        Song otherSong = (Song)other;
        return this.path.equals(otherSong.path);
    }

    private AudioFile audioFile() {
        return this.audioFile(new File(this.getPath()));
    }

    private AudioFile audioFile(File file) {
        AudioFile audioFile = null;
        try {
            audioFile = AudioFileIO.read(file);
        }
        catch (IOException | CannotReadException | InvalidAudioFrameException | ReadOnlyFileException | TagException e) {
            System.out.println("ERROR: Cannot read audio file...");
            e.printStackTrace();
        }
        return audioFile;
    }

    private Tag tag() {
        return this.tag(this.audioFile());
    }

    private Tag tag(AudioFile audioFile) {
        Tag tag = null;
        if (this.getExtension().equals(".mp3")) {
            tag = ((MP3File)audioFile).getTagAndConvertOrCreateAndSetDefault();
        } else if (this.getExtension().equals(".m4a")) {
            tag = (Mp4Tag)audioFile.getTagAndConvertOrCreateAndSetDefault();
        }
        return tag;
    }
}

