/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import tech.octopusdragon.musicplayer.Album;
import tech.octopusdragon.musicplayer.AlbumCollection;
import tech.octopusdragon.musicplayer.AlbumCollectionDirectory;
import tech.octopusdragon.musicplayer.Artist;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.DirectoryType;
import tech.octopusdragon.musicplayer.Folder;
import tech.octopusdragon.musicplayer.Genre;
import tech.octopusdragon.musicplayer.Playlist;
import tech.octopusdragon.musicplayer.Song;
import tech.octopusdragon.musicplayer.SongDirectory;
import tech.octopusdragon.musicplayer.application.MusicPlayerApplication;
import tech.octopusdragon.musicplayer.application.tools.Userdata;
import tech.octopusdragon.musicplayer.util.Util;

public class RootDirectories
implements Serializable {
    private static final long serialVersionUID = -8507744048197435913L;
    private static final DirectoryType DEFAULT_DIRECTORY_TYPE = DirectoryType.ALBUM;
    private List<Song> songs;
    private List<Album> albums;
    private SongDirectory songDirectory;
    private Directory albumDirectory;
    private Directory artistDirectory;
    private Directory genreDirectory;
    private Folder folderDirectory;
    private Directory playlistDirectory;
    private AlbumCollectionDirectory albumCollectionDirectory;

    public List<Song> getSongs() {
        return this.songs;
    }

    public List<Album> getAlbums() {
        return this.albums;
    }

    public Directory getSongDirectory() {
        return this.songDirectory;
    }

    public Directory getAlbumDirectory() {
        return this.albumDirectory;
    }

    public Directory getArtistDirectory() {
        return this.artistDirectory;
    }

    public Directory getGenreDirectory() {
        return this.genreDirectory;
    }

    public Folder getFolderDirectory() {
        return this.folderDirectory;
    }

    public Directory getPlaylistDirectory() {
        return this.playlistDirectory;
    }

    public Directory getAlbumCollectionDirectory() {
        return this.albumCollectionDirectory;
    }

    public Directory getDirectory(DirectoryType type) {
        Directory directory;
        switch (type) {
            case FOLDER: {
                directory = this.getFolderDirectory();
                break;
            }
            case ALBUM: {
                directory = this.getAlbumDirectory();
                break;
            }
            case ARTIST: {
                directory = this.getArtistDirectory();
                break;
            }
            case GENRE: {
                directory = this.getGenreDirectory();
                break;
            }
            case PLAYLIST: {
                directory = this.getPlaylistDirectory();
                break;
            }
            case ALBUM_COLLECTION: {
                directory = this.getAlbumCollectionDirectory();
                break;
            }
            default: {
                directory = null;
            }
        }
        return directory;
    }

    public Directory[] getAllDirectories() {
        return new Directory[]{this.songDirectory, this.albumDirectory, this.artistDirectory, this.genreDirectory, this.folderDirectory, this.playlistDirectory, this.albumCollectionDirectory};
    }

    public Directory defaultDirectory() {
        return this.getDirectory(DEFAULT_DIRECTORY_TYPE);
    }

    public void pullData(String directoryPath) {
        MusicPlayerApplication.setUpdateMessage("Loading folders");
        this.folderDirectory = this.getFolderDirectory(directoryPath);
        MusicPlayerApplication.setUpdateMessage("Loading songs");
        this.songs = this.folderDirectory.getSongsRecursive();
        MusicPlayerApplication.setUpdateMessage("Creating song directory");
        this.songDirectory = new SongDirectory("Songs");
        this.songDirectory.addSongs(this.songs);
        MusicPlayerApplication.setUpdateMessage("Loading albums");
        this.albumDirectory = this.getAlbumDirectory(this.songs);
        this.albums = new ArrayList<Album>();
        for (Directory directory : this.albumDirectory.getDirectories()) {
            this.albums.add((Album)directory);
        }
        MusicPlayerApplication.setUpdateMessage("Loading artists");
        this.artistDirectory = this.getArtistDirectory(this.albums);
        MusicPlayerApplication.setUpdateMessage("Loading genres");
        this.genreDirectory = this.getGenreDirectory(this.albums);
        MusicPlayerApplication.setUpdateMessage("Loading playlists");
        this.playlistDirectory = this.getPlaylistDirectory(directoryPath);
        MusicPlayerApplication.setUpdateMessage("Loading album collections");
        this.albumCollectionDirectory = new AlbumCollectionDirectory("Album Collections");
        for (AlbumCollection albumCollection : Userdata.loadAllAlbumCollections()) {
            this.albumCollectionDirectory.addDirectory(albumCollection);
        }
        MusicPlayerApplication.setUpdateMessage(null);
    }

    private List<Song> getSongsInFolder(File directory, boolean recursive) {
        ArrayList<Song> songList = new ArrayList<Song>();
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (recursive && file.isDirectory()) {
                    songList.addAll(this.getSongsInFolder(file, recursive));
                } else if (Arrays.asList(Util.MUSIC_FILE_EXTENTIONS).contains(Util.getFileExtension(file))) {
                    MusicPlayerApplication.setUpdateMessage(file.getPath());
                    Song newSong = new Song(file);
                    songList.add(newSong);
                }
                ++n2;
            }
        }
        return songList;
    }

    private Folder getFolderDirectory(File rootFolder) {
        Folder directory = new Folder(rootFolder.getPath(), "Folders");
        for (Folder folder : this.getFoldersInFolder(rootFolder, directory)) {
            directory.addDirectory(folder);
        }
        for (Song song : this.getSongsInFolder(rootFolder, false)) {
            directory.addSong(song);
        }
        MusicPlayerApplication.setUpdateMessage(null);
        return directory;
    }

    private Folder getFolderDirectory(String rootFolderPath) {
        return this.getFolderDirectory(new File(rootFolderPath));
    }

    private List<Folder> getFoldersInFolder(File directory, Directory parent) {
        ArrayList<Folder> folderList = new ArrayList<Folder>();
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    Folder curFolder = new Folder(file.getPath(), file.getName(), parent);
                    for (Folder folder : this.getFoldersInFolder(file, curFolder)) {
                        curFolder.addDirectory(folder);
                    }
                    for (Song song : this.getSongsInFolder(file, false)) {
                        curFolder.addSong(song);
                    }
                    curFolder.getSongs().sort(Comparator.naturalOrder());
                    if (curFolder.hasDirectories() || curFolder.hasSongs()) {
                        folderList.add(curFolder);
                    }
                }
                ++n2;
            }
        }
        return folderList;
    }

    private Directory getAlbumDirectory(List<Song> songs) {
        Directory directory = new Directory("Albums");
        HashMap albumMap = new HashMap();
        for (Song song : songs) {
            if (!albumMap.containsKey(song.getAlbumArtist())) {
                albumMap.put(song.getAlbumArtist(), new HashMap());
            }
            if (!((Map)albumMap.get(song.getAlbumArtist())).containsKey(song.getAlbumStr())) {
                Album newAlbum = new Album(song.getAlbumStr(), song.getAlbumArtist(), song.getGenre(), song.getYear(), song.coverArtData(), directory);
                ((Map)albumMap.get(song.getAlbumArtist())).put(song.getAlbumStr(), newAlbum);
            }
            ((Album)((Map)albumMap.get(song.getAlbumArtist())).get(song.getAlbumStr())).addSong(song);
            song.setAlbum((Album)((Map)albumMap.get(song.getAlbumArtist())).get(song.getAlbumStr()));
        }
        ArrayList<Album> albumList = new ArrayList<Album>();
        for (Map albumArtist : albumMap.values()) {
            for (Album album : albumArtist.values()) {
                albumList.add(album);
            }
        }
        albumList.sort(Comparator.naturalOrder());
        for (Album album : albumList) {
            album.getSongs().sort(Comparator.naturalOrder());
            directory.addDirectory(album);
        }
        return directory;
    }

    private Directory getArtistDirectory(List<Album> albums) {
        Directory directory = new Directory("Artists");
        HashMap<String, Artist> artistMap = new HashMap<String, Artist>();
        for (Album album : albums) {
            if (!artistMap.containsKey(album.getAlbumArtist())) {
                Artist newArtist = new Artist(album.getAlbumArtist(), directory);
                artistMap.put(album.getAlbumArtist(), newArtist);
            }
            Album albumCopy = new Album(album);
            albumCopy.setParent((Directory)artistMap.get(album.getAlbumArtist()));
            ((Artist)artistMap.get(album.getAlbumArtist())).addDirectory(albumCopy);
        }
        ArrayList artistList = new ArrayList(artistMap.values());
        artistList.sort(Comparator.naturalOrder());
        for (Artist artist : artistList) {
            directory.addDirectory(artist);
        }
        return directory;
    }

    private Directory getGenreDirectory(List<Album> albums) {
        Directory directory = new Directory("Genres");
        HashMap<String, Genre> genreMap = new HashMap<String, Genre>();
        for (Album album : albums) {
            if (!genreMap.containsKey(album.getGenre())) {
                Genre newGenre = new Genre(album.getGenre(), directory);
                genreMap.put(album.getGenre(), newGenre);
            }
            Album albumCopy = new Album(album);
            albumCopy.setParent((Directory)genreMap.get(album.getGenre()));
            ((Genre)genreMap.get(album.getGenre())).addDirectory(albumCopy);
        }
        ArrayList genreList = new ArrayList(genreMap.values());
        genreList.sort(Comparator.naturalOrder());
        for (Genre genre : genreList) {
            directory.addDirectory(genre);
        }
        return directory;
    }

    private Directory getPlaylistDirectory(File rootFolder) {
        List<File> playlistFileList = this.getPlaylistsInFolder(rootFolder);
        Directory rootDirectory = new Directory("Playlists");
        for (File playlistFile : playlistFileList) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(playlistFile);
            }
            catch (FileNotFoundException e1) {
                System.out.println("Problem reading playlist file");
                e1.printStackTrace();
            }
            String playlistName = playlistFile.getName().replace(Util.getFileExtension(playlistFile), "");
            MusicPlayerApplication.setUpdateMessage(playlistFile.getPath());
            Playlist newPlaylist = new Playlist(playlistName, rootDirectory);
            rootDirectory.addDirectory(newPlaylist);
            Scanner inputFile = new Scanner((InputStream)is, "UTF-8");
            while (inputFile.hasNext()) {
                String line = inputFile.nextLine();
                if (line.startsWith("#")) continue;
                if (line.startsWith("file:///")) {
                    line = line.substring(8);
                }
                try {
                    line = URLDecoder.decode(line, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("ERROR URL decoding line: " + line);
                    e.printStackTrace();
                }
                Song newSong = new Song(line);
                newPlaylist.addSong(newSong);
            }
            inputFile.close();
        }
        return rootDirectory;
    }

    private Directory getPlaylistDirectory(String rootFolderPath) {
        return this.getPlaylistDirectory(new File(rootFolderPath));
    }

    private List<File> getPlaylistsInFolder(File directory) {
        ArrayList<File> playlistList = new ArrayList<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    playlistList.addAll(this.getPlaylistsInFolder(file));
                } else if (Arrays.asList(Util.PLAYLIST_FILE_EXTENTIONS).contains(Util.getFileExtension(file))) {
                    playlistList.add(file);
                }
                ++n2;
            }
        }
        return playlistList;
    }
}

