/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer;

import java.util.Comparator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.Song;
import tech.octopusdragon.musicplayer.util.Util;

public class MusicPlayer {
    private ObjectProperty<Directory> curDirectory;
    private ObservableList<Song> dirSongs;
    private FilteredList<Song> dirSongsFiltered;
    private SortedList<Song> dirSongsFilteredSorted;
    private ObservableList<Song> selectedSongs;
    private ObservableList<Song> songs;
    private ObjectProperty<Song> curSong;
    private Media media;
    private ObjectProperty<MediaPlayer> playerProperty = new SimpleObjectProperty();
    private IntegerProperty index;
    private BooleanProperty loaded;
    private BooleanProperty playing;
    private DoubleProperty volume;
    private BooleanProperty mute;
    private BooleanProperty shuffle;
    private BooleanProperty repeat;
    private BooleanProperty repeatSingle;
    private DoubleProperty rate;
    private DoubleProperty balance;

    public MusicPlayer() {
        this.curDirectory = new SimpleObjectProperty();
        this.curSong = new SimpleObjectProperty();
        this.dirSongs = FXCollections.observableArrayList();
        this.dirSongsFiltered = new FilteredList(this.dirSongs);
        this.dirSongsFilteredSorted = new SortedList(this.dirSongsFiltered);
        this.selectedSongs = FXCollections.observableArrayList();
        this.songs = FXCollections.observableArrayList();
        this.index = new SimpleIntegerProperty(-1);
        this.loaded = new SimpleBooleanProperty(false);
        this.playing = new SimpleBooleanProperty(false);
        this.mute = new SimpleBooleanProperty(false);
        this.shuffle = new SimpleBooleanProperty(false);
        this.repeat = new SimpleBooleanProperty(false);
        this.repeatSingle = new SimpleBooleanProperty(false);
        this.repeat.addListener((obs, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.repeatSingle.set(false);
            }
        });
        this.repeatSingle.addListener((obs, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.repeat.set(false);
            }
        });
        this.volume = new SimpleDoubleProperty(0.8);
        this.rate = new SimpleDoubleProperty(1.0);
        this.balance = new SimpleDoubleProperty(0.0);
    }

    public void togglePlay() {
        if (this.playing.get()) {
            this.pauseMedia();
        } else {
            this.playMedia();
        }
    }

    public void playMedia() {
        if (this.curDirectory.get() == null) {
            return;
        }
        if (!this.loaded.get()) {
            this.newMediaReload();
        }
        ((MediaPlayer)this.playerProperty.get()).play();
        this.playing.set(true);
    }

    public void pauseMedia() {
        if (!this.loaded.get()) {
            return;
        }
        ((MediaPlayer)this.playerProperty.get()).pause();
        this.playing.set(false);
    }

    public void stopMedia() {
        if (!this.loaded.get()) {
            return;
        }
        ((MediaPlayer)this.playerProperty.get()).stop();
        this.curSong.set(null);
        if (this.playing.get()) {
            this.playing.set(false);
        }
        this.loaded.set(false);
        this.index.set(-1);
    }

    public void restartMedia() {
        if (!this.loaded.get()) {
            return;
        }
        ((MediaPlayer)this.playerProperty.get()).seek(Duration.seconds((double)0.0));
    }

    public void newMediaReload() {
        this.newSongList();
        if (this.shuffle.get()) {
            this.shuffleList();
        }
        this.newMedia(0);
    }

    public void newMediaReload(Song song) {
        this.newSongList();
        this.newMedia(this.songs.indexOf((Object)song));
        if (this.shuffle.get()) {
            this.shufflePlaying();
        }
    }

    public void newMediaReload(int index) {
        this.newSongList();
        this.newMedia(index);
        if (this.shuffle.get()) {
            this.shufflePlaying();
        }
    }

    public void newMedia(int newIndex) {
        if (newIndex == -1) {
            return;
        }
        if (this.playing.get()) {
            ((MediaPlayer)this.playerProperty.get()).stop();
        }
        this.curSong.set((Object)((Song)this.songs.get(newIndex)));
        this.media = new Media(((Song)this.curSong.getValue()).getURI());
        this.playerProperty.set((Object)new MediaPlayer(this.media));
        ((MediaPlayer)this.playerProperty.get()).setOnEndOfMedia(new Runnable(){

            @Override
            public void run() {
                if (MusicPlayer.this.repeatSingle.get()) {
                    MusicPlayer.this.restartMedia();
                } else if (!MusicPlayer.this.repeat.get() && MusicPlayer.this.index.get() == MusicPlayer.this.songs.size() - 1) {
                    MusicPlayer.this.stopMedia();
                } else {
                    MusicPlayer.this.next();
                }
            }
        });
        ((MediaPlayer)this.playerProperty.get()).muteProperty().bind((ObservableValue)this.mute);
        ((MediaPlayer)this.playerProperty.get()).volumeProperty().bind((ObservableValue)this.volume);
        ((MediaPlayer)this.playerProperty.get()).rateProperty().bind((ObservableValue)this.rate);
        ((MediaPlayer)this.playerProperty.get()).balanceProperty().bind((ObservableValue)this.balance);
        if (this.playing.get()) {
            ((MediaPlayer)this.playerProperty.get()).play();
        }
        if (!this.loaded.get()) {
            this.loaded.set(true);
        }
        this.index.set(newIndex);
    }

    public void previous() {
        int prevIndex;
        if (!this.loaded.get()) {
            return;
        }
        if (this.index.get() > 0) {
            prevIndex = this.index.get() - 1;
        } else {
            if (this.shuffle.get()) {
                this.shuffleList();
            }
            prevIndex = this.songs.size() - 1;
        }
        this.newMedia(prevIndex);
    }

    public void next() {
        int nextIndex;
        if (!this.loaded.get()) {
            return;
        }
        if (this.index.get() < this.songs.size() - 1) {
            nextIndex = this.index.get() + 1;
        } else {
            if (this.shuffle.get()) {
                this.shuffleList();
            }
            nextIndex = 0;
        }
        this.newMedia(nextIndex);
    }

    public void seek(double position) {
        if (!this.loaded.get()) {
            return;
        }
        ((MediaPlayer)this.playerProperty.get()).seek(Duration.millis((double)position));
    }

    public void move(double amount) {
        if (!this.loaded.get()) {
            return;
        }
        ((MediaPlayer)this.playerProperty.get()).seek(Duration.millis((double)(((MediaPlayer)this.playerProperty.get()).getCurrentTime().toMillis() + amount)));
    }

    public void toggleShuffle() {
        this.shuffle.set(!this.shuffle.get());
        if (this.playing.get()) {
            if (this.shuffle.get()) {
                this.shufflePlaying();
            } else {
                this.orderList();
            }
        }
    }

    public void rotateRepeat() {
        if (this.repeat.get()) {
            this.repeatSingle.set(true);
        } else if (this.repeatSingle.get()) {
            this.repeatSingle.set(false);
        } else {
            this.repeat.set(true);
        }
    }

    public void toggleRepeat() {
        this.repeat.set(!this.repeat.get());
    }

    public void toggleRepeatSingle() {
        this.repeatSingle.set(!this.repeatSingle.get());
    }

    public void toggleMute() {
        this.mute.set(!this.mute.get());
    }

    public void changeVolume(double value) {
        this.volume.set(value);
    }

    public void changeRate(double value) {
        this.rate.set(value);
    }

    public void changeBalance(double value) {
        this.balance.set(value);
    }

    public void newDirectory(Directory directory, boolean recursive) {
        this.curDirectory.set((Object)directory);
        this.dirSongs.clear();
        if (recursive) {
            this.dirSongs.addAll(((Directory)this.curDirectory.get()).getSongsRecursive());
        } else {
            this.dirSongs.addAll(((Directory)this.curDirectory.get()).getSongs());
        }
    }

    public void newDirectories(boolean recursive, Directory ... directories) {
        this.dirSongs.clear();
        Directory[] directoryArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            Directory directory = directoryArray[n2];
            if (recursive) {
                this.dirSongs.addAll(directory.getSongsRecursive());
            } else {
                this.dirSongs.addAll(directory.getSongs());
            }
            ++n2;
        }
    }

    private void newSongList() {
        this.songs.clear();
        if (this.selectedSongs.size() > 1) {
            this.songs.addAll(this.selectedSongs);
        } else {
            this.songs.addAll(this.dirSongsFilteredSorted);
        }
    }

    public void shufflePlaying() {
        this.shuffleList();
        if (this.loaded.get()) {
            this.songs.remove(this.curSong.getValue());
            this.songs.add(0, (Object)((Song)this.curSong.getValue()));
            this.index.set(0);
        }
    }

    public void shuffleList() {
        Util.shuffleList(this.songs);
    }

    public void orderList() {
        this.songs.sort(Comparator.comparing(item -> this.dirSongsFilteredSorted.indexOf(item)));
        if (this.playing.get()) {
            this.index.set(this.songs.indexOf(this.curSong.getValue()));
        }
    }

    public ObjectProperty<MediaPlayer> playerProperty() {
        return this.playerProperty;
    }

    public MediaPlayer getPlayer() {
        return (MediaPlayer)this.playerProperty.get();
    }

    public Media getMedia() {
        return this.media;
    }

    public ObjectProperty<Directory> getCurDirectory() {
        return this.curDirectory;
    }

    public ObjectProperty<Song> getCurSong() {
        return this.curSong;
    }

    public ObservableList<Song> getDirSongs() {
        return this.dirSongs;
    }

    public FilteredList<Song> getFilteredDirSongs() {
        return this.dirSongsFiltered;
    }

    public SortedList<Song> getSortedDirSongs() {
        return this.dirSongsFilteredSorted;
    }

    public ObservableList<Song> getSelectedSongs() {
        return this.selectedSongs;
    }

    public void setSelectedSongs(ObservableList<Song> selectedSongs) {
        this.selectedSongs = selectedSongs;
    }

    public BooleanProperty loadedProperty() {
        return this.loaded;
    }

    public boolean isLoaded() {
        return this.loadedProperty().get();
    }

    public BooleanProperty playingProperty() {
        return this.playing;
    }

    public boolean isPlaying() {
        return this.playingProperty().get();
    }

    public DoubleProperty volumeProperty() {
        return this.volume;
    }

    public double getVolume() {
        return this.volumeProperty().get();
    }

    public void setVolume(double volume) {
        this.volumeProperty().set(volume);
    }

    public BooleanProperty muteProperty() {
        return this.mute;
    }

    public boolean isMuted() {
        return this.muteProperty().get();
    }

    public void setMute(boolean mute) {
        this.muteProperty().set(mute);
    }

    public BooleanProperty shuffleProperty() {
        return this.shuffle;
    }

    public boolean isOnShuffle() {
        return this.shuffleProperty().get();
    }

    public void setShuffle(boolean shuffle) {
        this.shuffleProperty().set(shuffle);
    }

    public BooleanProperty repeatProperty() {
        return this.repeat;
    }

    public boolean isOnRepeat() {
        return this.repeatProperty().get();
    }

    public void setRepeat(boolean repeat) {
        this.repeatProperty().set(repeat);
    }

    public BooleanProperty repeatSingleProperty() {
        return this.repeatSingle;
    }

    public boolean isOnRepeatSingle() {
        return this.repeatSingleProperty().get();
    }

    public void setRepeatSingle(boolean repeatSingle) {
        this.repeatSingleProperty().set(repeatSingle);
    }

    public DoubleProperty rateProperty() {
        return this.rate;
    }

    public double getRate() {
        return this.rateProperty().get();
    }

    public void setRate(double rate) {
        this.rateProperty().set(rate);
    }

    public DoubleProperty balanceProperty() {
        return this.balance;
    }

    public double getBalance() {
        return this.balanceProperty().get();
    }

    public void setBalance(double balance) {
        this.balanceProperty().set(balance);
    }
}

