/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import tech.octopusdragon.musicplayer.DirectoryType;
import tech.octopusdragon.musicplayer.Song;

public class Directory
implements Serializable,
Comparable<Directory> {
    private static final long serialVersionUID = 8392913034804114971L;
    protected String name;
    protected DirectoryType type;
    protected Directory parent;
    protected List<Directory> directories;
    protected List<Song> songs;

    public Directory(String name) {
        this(name, null);
    }

    public Directory(String name, Directory parent) {
        this.name = name;
        this.parent = parent;
        this.type = DirectoryType.DIRECTORY;
        this.directories = new ArrayList<Directory>();
        this.songs = new ArrayList<Song>();
    }

    public String getName() {
        return this.name;
    }

    public DirectoryType getType() {
        return this.type;
    }

    public Directory getParent() {
        return this.parent;
    }

    public Directory getRoot() {
        Directory curDir = this;
        while (curDir.getParent() != null) {
            curDir = curDir.getParent();
        }
        return curDir;
    }

    public void setParent(Directory parent) {
        this.parent = parent;
    }

    public List<Directory> getDirectories() {
        return this.directories;
    }

    public List<Song> getSongs() {
        return this.songs;
    }

    public List<Song> getSongsRecursive() {
        ArrayList<Song> deepSongs = new ArrayList<Song>();
        for (Directory directory : this.directories) {
            deepSongs.addAll(directory.getSongsRecursive());
        }
        deepSongs.addAll(this.songs);
        return deepSongs;
    }

    public boolean hasDirectories() {
        return !this.directories.isEmpty();
    }

    public boolean hasSongs() {
        return !this.songs.isEmpty();
    }

    public void addDirectory(Directory directory) {
        this.directories.add(directory);
    }

    public void addSong(Song song) {
        this.songs.add(song);
    }

    public void addSongs(Collection<Song> songCollection) {
        this.songs.addAll(songCollection);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Directory)) {
            return false;
        }
        Directory otherDirectory = (Directory)other;
        return this.name.equals(otherDirectory.name) && this.type == otherDirectory.type;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Directory other) {
        return this.getName().compareToIgnoreCase(other.getName());
    }
}

