/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.musicplayer;

import java.util.ArrayList;
import java.util.Objects;
import tech.octopusdragon.musicplayer.Directory;
import tech.octopusdragon.musicplayer.DirectoryType;

public class Album
extends Directory {
    private static final long serialVersionUID = -4217132869104276041L;
    private String album;
    private String albumArtist;
    private String genre;
    private int year;
    private byte[] coverArtData;

    public Album(String album, String albumArtist, String genre, int year, byte[] coverArtData, Directory parent) {
        super(album, parent);
        this.type = DirectoryType.ALBUM;
        this.album = album;
        this.albumArtist = albumArtist;
        this.genre = genre;
        this.year = year;
        this.coverArtData = coverArtData;
    }

    public Album(Album other) {
        this(other.album, other.albumArtist, other.genre, other.year, other.coverArtData, other.parent);
        this.directories = new ArrayList(other.directories);
        this.songs = new ArrayList(other.songs);
    }

    public String getAlbum() {
        return this.album;
    }

    public String getAlbumArtist() {
        return this.albumArtist;
    }

    public String getGenre() {
        return this.genre;
    }

    public int getYear() {
        return this.year;
    }

    public byte[] getCoverArtData() {
        return this.coverArtData;
    }

    public int hashCode() {
        return Objects.hash(this.album, this.albumArtist, this.genre, this.year);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Album other = (Album)obj;
        return Objects.equals(this.album, other.album) && Objects.equals(this.albumArtist, other.albumArtist) && Objects.equals(this.genre, other.genre) && this.year == other.year;
    }
}

