/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.nio.ByteBuffer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.PartOfSet;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;

public class FrameBodyTPOS
extends AbstractID3v2FrameBody
implements ID3v23FrameBody,
ID3v24FrameBody {
    public FrameBodyTPOS() {
        this.setObjectValue("TextEncoding", (byte)0);
        this.setObjectValue("Text", new PartOfSet.PartOfSetValue());
    }

    public FrameBodyTPOS(FrameBodyTPOS body) {
        super(body);
    }

    public FrameBodyTPOS(byte textEncoding, String text) {
        this.setObjectValue("TextEncoding", textEncoding);
        this.setObjectValue("Text", new PartOfSet.PartOfSetValue(text));
    }

    public FrameBodyTPOS(byte textEncoding, Integer discNo, Integer discTotal) {
        this.setObjectValue("TextEncoding", textEncoding);
        this.setObjectValue("Text", new PartOfSet.PartOfSetValue(discNo, discTotal));
    }

    public FrameBodyTPOS(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    public String getIdentifier() {
        return "TPOS";
    }

    public String getUserFriendlyValue() {
        return String.valueOf(this.getDiscNo());
    }

    public String getText() {
        return this.getObjectValue("Text").toString();
    }

    public Integer getDiscNo() {
        return ((PartOfSet.PartOfSetValue)this.getObjectValue("Text")).getCount();
    }

    public String getDiscNoAsText() {
        return ((PartOfSet.PartOfSetValue)this.getObjectValue("Text")).getCountAsText();
    }

    public void setDiscNo(Integer discNo) {
        ((PartOfSet.PartOfSetValue)this.getObjectValue("Text")).setCount(discNo);
    }

    public void setDiscNo(String discNo) {
        ((PartOfSet.PartOfSetValue)this.getObjectValue("Text")).setCount(discNo);
    }

    public Integer getDiscTotal() {
        return ((PartOfSet.PartOfSetValue)this.getObjectValue("Text")).getTotal();
    }

    public String getDiscTotalAsText() {
        return ((PartOfSet.PartOfSetValue)this.getObjectValue("Text")).getTotalAsText();
    }

    public void setDiscTotal(Integer discTotal) {
        ((PartOfSet.PartOfSetValue)this.getObjectValue("Text")).setTotal(discTotal);
    }

    public void setDiscTotal(String discTotal) {
        ((PartOfSet.PartOfSetValue)this.getObjectValue("Text")).setTotal(discTotal);
    }

    public void setText(String text) {
        this.setObjectValue("Text", new PartOfSet.PartOfSetValue(text));
    }

    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new PartOfSet("Text", this));
    }
}

