/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.datatype.NumberFixedLength;
import org.jaudiotagger.tag.datatype.TempoCode;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.EventTimingTypes;

public class SynchronisedTempoCode
extends AbstractDataType
implements Cloneable {
    private TempoCode tempo = new TempoCode("SynchronisedTempoData", null, 1);
    private NumberFixedLength timestamp = new NumberFixedLength("DateTime", null, 4);

    public SynchronisedTempoCode(SynchronisedTempoCode copy) {
        super(copy);
        this.tempo.setValue(copy.tempo.getValue());
        this.timestamp.setValue(copy.timestamp.getValue());
    }

    public SynchronisedTempoCode(String identifier, AbstractTagFrameBody frameBody) {
        this(identifier, frameBody, 0, 0L);
    }

    public SynchronisedTempoCode(String identifier, AbstractTagFrameBody frameBody, int tempo, long timestamp) {
        super(identifier, frameBody);
        this.setBody(frameBody);
        this.tempo.setValue(tempo);
        this.timestamp.setValue(timestamp);
    }

    public void setBody(AbstractTagFrameBody frameBody) {
        super.setBody(frameBody);
        this.tempo.setBody(frameBody);
        this.timestamp.setBody(frameBody);
    }

    public long getTimestamp() {
        return ((Number)this.timestamp.getValue()).longValue();
    }

    public void setTimestamp(long timestamp) {
        this.timestamp.setValue(timestamp);
    }

    public int getTempo() {
        return ((Number)this.tempo.getValue()).intValue();
    }

    public void setTempo(int tempo) {
        if (tempo < 0 || tempo > 510) {
            throw new IllegalArgumentException("Tempo must be a positive value less than 511: " + tempo);
        }
        this.tempo.setValue(tempo);
    }

    public int getSize() {
        return this.tempo.getSize() + this.timestamp.getSize();
    }

    public void readByteArray(byte[] buffer, int originalOffset) throws InvalidDataTypeException {
        int localOffset = originalOffset;
        int size = this.getSize();
        logger.finest("offset:" + localOffset);
        if (originalOffset > buffer.length - size) {
            logger.warning("Invalid size for FrameBody");
            throw new InvalidDataTypeException("Invalid size for FrameBody");
        }
        this.tempo.readByteArray(buffer, localOffset);
        this.timestamp.readByteArray(buffer, localOffset += this.tempo.getSize());
        localOffset += this.timestamp.getSize();
    }

    public byte[] writeByteArray() {
        byte[] typeData = this.tempo.writeByteArray();
        byte[] timeData = this.timestamp.writeByteArray();
        if (typeData == null || timeData == null) {
            return null;
        }
        byte[] objectData = new byte[typeData.length + timeData.length];
        System.arraycopy(typeData, 0, objectData, 0, typeData.length);
        System.arraycopy(timeData, 0, objectData, typeData.length, timeData.length);
        return objectData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SynchronisedTempoCode that = (SynchronisedTempoCode)o;
        return this.getTempo() == that.getTempo() && this.getTimestamp() == that.getTimestamp();
    }

    public int hashCode() {
        int result = this.tempo != null ? this.tempo.hashCode() : 0;
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "" + this.getTempo() + " (\"" + EventTimingTypes.getInstanceOf().getValueForId(this.getTempo()) + "\"), " + this.getTimestamp();
    }

    public Object clone() throws CloneNotSupportedException {
        return new SynchronisedTempoCode(this);
    }
}

