/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.wav.util.WavFormatHeader;
import org.jaudiotagger.audio.wav.util.WavRIFFHeader;

public class WavInfoReader {
    public GenericAudioHeader read(RandomAccessFile raf) throws CannotReadException, IOException {
        WavFormatHeader wfh;
        GenericAudioHeader info = new GenericAudioHeader();
        if (raf.length() < 12L) {
            throw new CannotReadException("This is not a WAV File (<12 bytes)");
        }
        byte[] b = new byte[12];
        raf.read(b);
        WavRIFFHeader wh = new WavRIFFHeader(b);
        if (wh.isValid()) {
            b = new byte[34];
            raf.read(b);
            wfh = new WavFormatHeader(b);
            if (!wfh.isValid()) {
                throw new CannotReadException("Wav Format Header not valid");
            }
        } else {
            throw new CannotReadException("Wav RIFF Header not valid");
        }
        info.setPreciseLength(((float)raf.length() - 36.0f) / (float)wfh.getBytesPerSecond());
        info.setChannelNumber(wfh.getChannelNumber());
        info.setSamplingRate(wfh.getSamplingRate());
        info.setBitsPerSample(wfh.getBitsPerSample());
        info.setEncodingType("WAV-RIFF " + wfh.getBitsPerSample() + " bits");
        info.setExtraEncodingInfos("");
        info.setBitrate(wfh.getBytesPerSecond() * 8 / 1000);
        info.setVariableBitRate(false);
        return info;
    }
}

