/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.ogg.OggVorbisCommentTagCreator;
import org.jaudiotagger.audio.ogg.OggVorbisTagReader;
import org.jaudiotagger.audio.ogg.util.OggCRCFactory;
import org.jaudiotagger.audio.ogg.util.OggPageHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OggVorbisTagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg");
    private OggVorbisCommentTagCreator tc = new OggVorbisCommentTagCreator();
    private OggVorbisTagReader reader = new OggVorbisTagReader();

    public void delete(RandomAccessFile raf, RandomAccessFile tempRaf) throws IOException, CannotReadException, CannotWriteException {
        try {
            this.reader.read(raf);
        }
        catch (CannotReadException e) {
            this.write(VorbisCommentTag.createNewTag(), raf, tempRaf);
            return;
        }
        VorbisCommentTag emptyTag = VorbisCommentTag.createNewTag();
        raf.seek(0L);
        this.write(emptyTag, raf, tempRaf);
    }

    public void write(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotReadException, CannotWriteException, IOException {
        logger.config("Starting to write file:");
        logger.fine("Read 1st Page:identificationHeader:");
        OggPageHeader pageHeader = OggPageHeader.read(raf);
        raf.seek(pageHeader.getStartByte());
        rafTemp.getChannel().transferFrom(raf.getChannel(), 0L, pageHeader.getPageLength() + 27 + pageHeader.getSegmentTable().length);
        rafTemp.skipBytes(pageHeader.getPageLength() + 27 + pageHeader.getSegmentTable().length);
        logger.fine("Written identificationHeader:");
        OggPageHeader secondPageHeader = OggPageHeader.read(raf);
        long secondPageHeaderEndPos = raf.getFilePointer();
        logger.fine("Read 2nd Page:comment and setup and possibly audio:Header finishes at file position:" + secondPageHeaderEndPos);
        raf.seek(0L);
        OggVorbisTagReader.OggVorbisHeaderSizes vorbisHeaderSizes = this.reader.readOggVorbisHeaderSizes(raf);
        ByteBuffer newComment = this.tc.convert(tag);
        int newCommentLength = newComment.capacity();
        int newSecondPageDataLength = vorbisHeaderSizes.getSetupHeaderSize() + newCommentLength + vorbisHeaderSizes.getExtraPacketDataSize();
        logger.fine("Old 2nd Page no of packets: " + secondPageHeader.getPacketList().size());
        logger.fine("Old 2nd Page size: " + secondPageHeader.getPageLength());
        logger.fine("Old last packet incomplete: " + secondPageHeader.isLastPacketIncomplete());
        logger.fine("Setup Header Size: " + vorbisHeaderSizes.getSetupHeaderSize());
        logger.fine("Extra Packets: " + vorbisHeaderSizes.getExtraPacketList().size());
        logger.fine("Extra Packet Data Size: " + vorbisHeaderSizes.getExtraPacketDataSize());
        logger.fine("Old comment: " + vorbisHeaderSizes.getCommentHeaderSize());
        logger.fine("New comment: " + newCommentLength);
        logger.fine("New Page Data Size: " + newSecondPageDataLength);
        if (this.isCommentAndSetupHeaderFitsOnASinglePage(newCommentLength, vorbisHeaderSizes.getSetupHeaderSize(), vorbisHeaderSizes.getExtraPacketList())) {
            if (secondPageHeader.getPageLength() < 65025 && (secondPageHeader.getPacketList().size() == 2 && !secondPageHeader.isLastPacketIncomplete() || secondPageHeader.getPacketList().size() > 2)) {
                logger.fine("Header and Setup remain on single page:");
                this.replaceSecondPageOnly(vorbisHeaderSizes, newCommentLength, newSecondPageDataLength, secondPageHeader, newComment, secondPageHeaderEndPos, raf, rafTemp);
            } else {
                logger.fine("Header and Setup now on single page:");
                this.replaceSecondPageAndRenumberPageSeqs(vorbisHeaderSizes, newCommentLength, newSecondPageDataLength, secondPageHeader, newComment, raf, rafTemp);
            }
        } else {
            logger.fine("Header and Setup with shift audio:");
            this.replacePagesAndRenumberPageSeqs(vorbisHeaderSizes, newCommentLength, secondPageHeader, newComment, raf, rafTemp);
        }
    }

    private void calculateChecksumOverPage(ByteBuffer page) {
        page.putInt(22, 0);
        byte[] crc = OggCRCFactory.computeCRC(page.array());
        for (int i = 0; i < crc.length; ++i) {
            page.put(22 + i, crc[i]);
        }
        page.rewind();
    }

    private ByteBuffer startCreateBasicSecondPage(OggVorbisTagReader.OggVorbisHeaderSizes vorbisHeaderSizes, int newCommentLength, int newSecondPageLength, OggPageHeader secondPageHeader, ByteBuffer newComment) throws IOException {
        logger.fine("WriteOgg Type 1");
        byte[] segmentTable = this.createSegmentTable(newCommentLength, vorbisHeaderSizes.getSetupHeaderSize(), vorbisHeaderSizes.getExtraPacketList());
        int newSecondPageHeaderLength = 27 + segmentTable.length;
        logger.fine("New second page header length:" + newSecondPageHeaderLength);
        logger.fine("No of segments:" + segmentTable.length);
        ByteBuffer secondPageBuffer = ByteBuffer.allocate(newSecondPageLength + newSecondPageHeaderLength);
        secondPageBuffer.order(ByteOrder.LITTLE_ENDIAN);
        secondPageBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
        secondPageBuffer.put((byte)segmentTable.length);
        for (byte aSegmentTable : segmentTable) {
            secondPageBuffer.put(aSegmentTable);
        }
        secondPageBuffer.put(newComment);
        return secondPageBuffer;
    }

    private void replaceSecondPageOnly(OggVorbisTagReader.OggVorbisHeaderSizes vorbisHeaderSizes, int newCommentLength, int newSecondPageLength, OggPageHeader secondPageHeader, ByteBuffer newComment, long secondPageHeaderEndPos, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException {
        logger.fine("WriteOgg Type 1");
        ByteBuffer secondPageBuffer = this.startCreateBasicSecondPage(vorbisHeaderSizes, newCommentLength, newSecondPageLength, secondPageHeader, newComment);
        raf.seek(secondPageHeaderEndPos);
        raf.skipBytes(vorbisHeaderSizes.getCommentHeaderSize());
        raf.getChannel().read(secondPageBuffer);
        this.calculateChecksumOverPage(secondPageBuffer);
        rafTemp.getChannel().write(secondPageBuffer);
        rafTemp.getChannel().transferFrom(raf.getChannel(), rafTemp.getFilePointer(), raf.length() - raf.getFilePointer());
    }

    private void replaceSecondPageAndRenumberPageSeqs(OggVorbisTagReader.OggVorbisHeaderSizes originalHeaderSizes, int newCommentLength, int newSecondPageLength, OggPageHeader secondPageHeader, ByteBuffer newComment, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException, CannotReadException, CannotWriteException {
        logger.fine("WriteOgg Type 2");
        ByteBuffer secondPageBuffer = this.startCreateBasicSecondPage(originalHeaderSizes, newCommentLength, newSecondPageLength, secondPageHeader, newComment);
        int pageSequence = secondPageHeader.getPageSequence();
        byte[] setupHeaderData = this.reader.convertToVorbisSetupHeaderPacketAndAdditionalPackets(originalHeaderSizes.getSetupHeaderStartPosition(), raf);
        logger.finest(setupHeaderData.length + ":" + secondPageBuffer.position() + ":" + secondPageBuffer.capacity());
        secondPageBuffer.put(setupHeaderData);
        this.calculateChecksumOverPage(secondPageBuffer);
        rafTemp.getChannel().write(secondPageBuffer);
        this.writeRemainingPages(pageSequence, raf, rafTemp);
    }

    private void replacePagesAndRenumberPageSeqs(OggVorbisTagReader.OggVorbisHeaderSizes originalHeaderSizes, int newCommentLength, OggPageHeader secondPageHeader, ByteBuffer newComment, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException, CannotReadException, CannotWriteException {
        Object nextPartOfComment;
        ByteBuffer pageBuffer;
        int pageHeaderLength;
        byte[] segmentTable;
        int pageSequence = secondPageHeader.getPageSequence();
        int noOfCompletePagesNeededForComment = newCommentLength / 65025;
        logger.config("Comment requires:" + noOfCompletePagesNeededForComment + " complete pages");
        int newCommentOffset = 0;
        if (noOfCompletePagesNeededForComment > 0) {
            for (int i = 0; i < noOfCompletePagesNeededForComment; ++i) {
                segmentTable = this.createSegments(65025, false);
                pageHeaderLength = 27 + segmentTable.length;
                pageBuffer = ByteBuffer.allocate(pageHeaderLength + 65025);
                pageBuffer.order(ByteOrder.LITTLE_ENDIAN);
                pageBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
                pageBuffer.put((byte)segmentTable.length);
                for (Object aSegmentTable : segmentTable) {
                    pageBuffer.put((byte)aSegmentTable);
                }
                nextPartOfComment = newComment.slice();
                ((ByteBuffer)nextPartOfComment).limit(65025);
                pageBuffer.put((ByteBuffer)nextPartOfComment);
                pageBuffer.putInt(18, pageSequence);
                ++pageSequence;
                if (i != 0) {
                    pageBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
                }
                this.calculateChecksumOverPage(pageBuffer);
                rafTemp.getChannel().write(pageBuffer);
                newComment.position(newCommentOffset += 65025);
            }
        }
        int lastPageCommentPacketSize = newCommentLength % 65025;
        logger.fine("Last comment packet size:" + lastPageCommentPacketSize);
        if (!this.isCommentAndSetupHeaderFitsOnASinglePage(lastPageCommentPacketSize, originalHeaderSizes.getSetupHeaderSize(), originalHeaderSizes.getExtraPacketList())) {
            logger.fine("WriteOgg Type 3");
            segmentTable = this.createSegments(lastPageCommentPacketSize, true);
            pageHeaderLength = 27 + segmentTable.length;
            pageBuffer = ByteBuffer.allocate(lastPageCommentPacketSize + pageHeaderLength);
            pageBuffer.order(ByteOrder.LITTLE_ENDIAN);
            pageBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
            pageBuffer.put((byte)segmentTable.length);
            nextPartOfComment = segmentTable;
            int n = ((Object)nextPartOfComment).length;
            for (int i = 0; i < n; ++i) {
                Object aSegmentTable;
                aSegmentTable = nextPartOfComment[i];
                pageBuffer.put((byte)aSegmentTable);
            }
            newComment.position(newCommentOffset);
            pageBuffer.put(newComment.slice());
            pageBuffer.putInt(18, pageSequence);
            if (noOfCompletePagesNeededForComment > 0) {
                pageBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            }
            logger.fine("Writing Last Comment Page " + pageSequence + " to file");
            ++pageSequence;
            this.calculateChecksumOverPage(pageBuffer);
            rafTemp.getChannel().write(pageBuffer);
            segmentTable = this.createSegmentTable(originalHeaderSizes.getSetupHeaderSize(), originalHeaderSizes.getExtraPacketList());
            pageHeaderLength = 27 + segmentTable.length;
            byte[] setupHeaderData = this.reader.convertToVorbisSetupHeaderPacketAndAdditionalPackets(originalHeaderSizes.getSetupHeaderStartPosition(), raf);
            ByteBuffer pageBuffer2 = ByteBuffer.allocate(setupHeaderData.length + pageHeaderLength);
            pageBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            pageBuffer2.put(secondPageHeader.getRawHeaderData(), 0, 26);
            pageBuffer2.put((byte)segmentTable.length);
            for (byte aSegmentTable : segmentTable) {
                pageBuffer2.put(aSegmentTable);
            }
            pageBuffer2.put(setupHeaderData);
            pageBuffer2.putInt(18, pageSequence);
            logger.fine("Writing Setup Header and packets Page " + pageSequence + " to file");
            this.calculateChecksumOverPage(pageBuffer2);
            rafTemp.getChannel().write(pageBuffer2);
        } else {
            logger.fine("WriteOgg Type 4");
            int newSecondPageDataLength = originalHeaderSizes.getSetupHeaderSize() + lastPageCommentPacketSize + originalHeaderSizes.getExtraPacketDataSize();
            newComment.position(newCommentOffset);
            ByteBuffer lastComment = newComment.slice();
            ByteBuffer lastHeaderBuffer = this.startCreateBasicSecondPage(originalHeaderSizes, lastPageCommentPacketSize, newSecondPageDataLength, secondPageHeader, lastComment);
            raf.seek(originalHeaderSizes.getSetupHeaderStartPosition());
            byte[] setupHeaderData = this.reader.convertToVorbisSetupHeaderPacketAndAdditionalPackets(originalHeaderSizes.getSetupHeaderStartPosition(), raf);
            lastHeaderBuffer.put(setupHeaderData);
            lastHeaderBuffer.putInt(18, pageSequence);
            lastHeaderBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            this.calculateChecksumOverPage(lastHeaderBuffer);
            rafTemp.getChannel().write(lastHeaderBuffer);
        }
        this.writeRemainingPages(pageSequence, raf, rafTemp);
    }

    public void writeRemainingPages(int pageSequence, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException, CannotReadException, CannotWriteException {
        long startAudio = raf.getFilePointer();
        long startAudioWritten = rafTemp.getFilePointer();
        ByteBuffer bb = ByteBuffer.allocate((int)(raf.length() - raf.getFilePointer()));
        ByteBuffer bbTemp = ByteBuffer.allocate((int)(raf.length() - raf.getFilePointer()));
        raf.getChannel().read(bb);
        bb.rewind();
        while (bb.hasRemaining()) {
            OggPageHeader nextPage = OggPageHeader.read(bb);
            ByteBuffer nextPageHeaderBuffer = ByteBuffer.allocate(nextPage.getRawHeaderData().length + nextPage.getPageLength());
            nextPageHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            nextPageHeaderBuffer.put(nextPage.getRawHeaderData());
            ByteBuffer data = bb.slice();
            data.limit(nextPage.getPageLength());
            nextPageHeaderBuffer.put(data);
            nextPageHeaderBuffer.putInt(18, ++pageSequence);
            this.calculateChecksumOverPage(nextPageHeaderBuffer);
            bb.position(bb.position() + nextPage.getPageLength());
            nextPageHeaderBuffer.rewind();
            bbTemp.put(nextPageHeaderBuffer);
        }
        bbTemp.rewind();
        rafTemp.getChannel().write(bbTemp);
        if (raf.length() - startAudio != rafTemp.length() - startAudioWritten) {
            throw new CannotWriteException("File written counts don't match, file not written");
        }
    }

    public void writeRemainingPagesOld(int pageSequence, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException, CannotReadException, CannotWriteException {
        long startAudio = raf.getFilePointer();
        long startAudioWritten = rafTemp.getFilePointer();
        logger.fine("Writing audio, audio starts in original file at :" + startAudio + ":Written to:" + startAudioWritten);
        while (raf.getFilePointer() < raf.length()) {
            logger.fine("Reading Ogg Page");
            OggPageHeader nextPage = OggPageHeader.read(raf);
            ByteBuffer nextPageHeaderBuffer = ByteBuffer.allocate(nextPage.getRawHeaderData().length + nextPage.getPageLength());
            nextPageHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            nextPageHeaderBuffer.put(nextPage.getRawHeaderData());
            raf.getChannel().read(nextPageHeaderBuffer);
            nextPageHeaderBuffer.putInt(18, ++pageSequence);
            this.calculateChecksumOverPage(nextPageHeaderBuffer);
            rafTemp.getChannel().write(nextPageHeaderBuffer);
        }
        if (raf.length() - startAudio != rafTemp.length() - startAudioWritten) {
            throw new CannotWriteException("File written counts don't match, file not written");
        }
    }

    private byte[] createSegmentTable(int newCommentLength, int setupHeaderLength, List<OggPageHeader.PacketStartAndLength> extraPackets) {
        logger.finest("Create SegmentTable CommentLength:" + newCommentLength + ":SetupHeaderLength:" + setupHeaderLength);
        ByteArrayOutputStream resultBaos = new ByteArrayOutputStream();
        if (setupHeaderLength == 0) {
            byte[] newStart = this.createSegments(newCommentLength, false);
            return newStart;
        }
        byte[] newStart = this.createSegments(newCommentLength, true);
        byte[] restShouldBe = extraPackets.size() > 0 ? this.createSegments(setupHeaderLength, true) : this.createSegments(setupHeaderLength, false);
        logger.finest("Created " + newStart.length + " segments for header");
        logger.finest("Created " + restShouldBe.length + " segments for setup");
        try {
            resultBaos.write(newStart);
            resultBaos.write(restShouldBe);
            if (extraPackets.size() > 0) {
                logger.finer("Creating segments for " + extraPackets.size() + " packets");
                for (OggPageHeader.PacketStartAndLength packet : extraPackets) {
                    byte[] nextPacket = this.createSegments(packet.getLength(), false);
                    resultBaos.write(nextPacket);
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create segment table:" + ioe.getMessage());
        }
        return resultBaos.toByteArray();
    }

    private byte[] createSegmentTable(int setupHeaderLength, List<OggPageHeader.PacketStartAndLength> extraPackets) {
        ByteArrayOutputStream resultBaos = new ByteArrayOutputStream();
        byte[] restShouldBe = this.createSegments(setupHeaderLength, true);
        try {
            resultBaos.write(restShouldBe);
            if (extraPackets.size() > 0) {
                for (OggPageHeader.PacketStartAndLength packet : extraPackets) {
                    byte[] nextPacket = this.createSegments(packet.getLength(), false);
                    resultBaos.write(nextPacket);
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create segment table:" + ioe.getMessage());
        }
        return resultBaos.toByteArray();
    }

    private byte[] createSegments(int length, boolean quitStream) {
        int i;
        logger.finest("Create Segments for length:" + length + ":QuitStream:" + quitStream);
        if (length == 0) {
            byte[] result = new byte[]{0};
            return result;
        }
        byte[] result = new byte[length / 255 + (length % 255 == 0 && !quitStream ? 0 : 1)];
        for (i = 0; i < result.length - 1; ++i) {
            result[i] = -1;
        }
        result[result.length - 1] = (byte)(length - i * 255);
        return result;
    }

    private boolean isCommentAndSetupHeaderFitsOnASinglePage(int commentLength, int setupHeaderLength, List<OggPageHeader.PacketStartAndLength> extraPacketList) {
        int totalDataSize = 0;
        if (commentLength == 0) {
            ++totalDataSize;
        } else {
            totalDataSize = commentLength / 255 + 1;
            if (commentLength % 255 == 0) {
                ++totalDataSize;
            }
        }
        logger.finest("Require:" + totalDataSize + " segments for comment");
        if (setupHeaderLength == 0) {
            ++totalDataSize;
        } else {
            totalDataSize += setupHeaderLength / 255 + 1;
            if (setupHeaderLength % 255 == 0) {
                ++totalDataSize;
            }
        }
        logger.finest("Require:" + totalDataSize + " segments for comment plus setup");
        for (OggPageHeader.PacketStartAndLength extraPacket : extraPacketList) {
            if (extraPacket.getLength() == 0) {
                ++totalDataSize;
                continue;
            }
            totalDataSize += extraPacket.getLength() / 255 + 1;
            if (extraPacket.getLength() % 255 != 0) continue;
            ++totalDataSize;
        }
        logger.finest("Total No Of Segment If New Comment And Header Put On One Page:" + totalDataSize);
        return totalDataSize <= 255;
    }
}

