/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.TagException;

public class AiffFile
extends AudioFile {
    public static final SimpleDateFormat ISO_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public AiffFile() {
    }

    public AiffFile(String filename) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(new File(filename));
    }

    public AiffFile(File file) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AiffFile(File file, boolean readOnly) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        RandomAccessFile newFile = null;
        try {
            logger.setLevel(Level.FINEST);
            logger.fine("Called AiffFile constructor on " + file.getAbsolutePath());
            this.file = file;
            newFile = this.checkFilePermissions(file, readOnly);
            this.audioHeader = new AiffAudioHeader();
            Object var5_4 = null;
            if (newFile == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (newFile == null) throw throwable;
            newFile.close();
            throw throwable;
        }
        newFile.close();
    }

    public AiffAudioHeader getAiffAudioHeader() {
        return (AiffAudioHeader)this.audioHeader;
    }
}

